/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.ResultError;
import com.oracle.bmc.databasemigration.model.ResultType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiagnosticsResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resultType")
    private final ResultType resultType;
    @JsonProperty(value="error")
    private final ResultError error;

    @Deprecated
    @ConstructorProperties(value={"resultType", "error"})
    public DiagnosticsResult(ResultType resultType, ResultError error) {
        this.resultType = resultType;
        this.error = error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public ResultError getError() {
        return this.error;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiagnosticsResult(");
        sb.append("super=").append(super.toString());
        sb.append("resultType=").append(String.valueOf((Object)this.resultType));
        sb.append(", error=").append(String.valueOf((Object)this.error));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiagnosticsResult)) {
            return false;
        }
        DiagnosticsResult other = (DiagnosticsResult)((Object)o);
        return Objects.equals((Object)this.resultType, (Object)other.resultType) && Objects.equals((Object)this.error, (Object)other.error) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resultType == null ? 43 : this.resultType.hashCode());
        result = result * 59 + (this.error == null ? 43 : this.error.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resultType")
        private ResultType resultType;
        @JsonProperty(value="error")
        private ResultError error;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resultType(ResultType resultType) {
            this.resultType = resultType;
            this.__explicitlySet__.add("resultType");
            return this;
        }

        public Builder error(ResultError error) {
            this.error = error;
            this.__explicitlySet__.add("error");
            return this;
        }

        public DiagnosticsResult build() {
            DiagnosticsResult model = new DiagnosticsResult(this.resultType, this.error);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiagnosticsResult model) {
            if (model.wasPropertyExplicitlySet("resultType")) {
                this.resultType(model.getResultType());
            }
            if (model.wasPropertyExplicitlySet("error")) {
                this.error(model.getError());
            }
            return this;
        }
    }
}

