/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CloneMigrationDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseCombination")
@JsonFilter(value="explicitlySetFilter")
public final class OracleCloneMigrationDetails
extends CloneMigrationDetails {
    @JsonProperty(value="sourceContainerDatabaseConnectionId")
    private final String sourceContainerDatabaseConnectionId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleCloneMigrationDetails(String displayName, String compartmentId, String sourceDatabaseConnectionId, String targetDatabaseConnectionId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String sourceContainerDatabaseConnectionId) {
        super(displayName, compartmentId, sourceDatabaseConnectionId, targetDatabaseConnectionId, freeformTags, definedTags);
        this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
    }

    public String getSourceContainerDatabaseConnectionId() {
        return this.sourceContainerDatabaseConnectionId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleCloneMigrationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sourceContainerDatabaseConnectionId=").append(String.valueOf(this.sourceContainerDatabaseConnectionId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleCloneMigrationDetails)) {
            return false;
        }
        OracleCloneMigrationDetails other = (OracleCloneMigrationDetails)((Object)o);
        return Objects.equals(this.sourceContainerDatabaseConnectionId, other.sourceContainerDatabaseConnectionId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sourceContainerDatabaseConnectionId == null ? 43 : this.sourceContainerDatabaseConnectionId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceDatabaseConnectionId")
        private String sourceDatabaseConnectionId;
        @JsonProperty(value="targetDatabaseConnectionId")
        private String targetDatabaseConnectionId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="sourceContainerDatabaseConnectionId")
        private String sourceContainerDatabaseConnectionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceDatabaseConnectionId(String sourceDatabaseConnectionId) {
            this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
            this.__explicitlySet__.add("sourceDatabaseConnectionId");
            return this;
        }

        public Builder targetDatabaseConnectionId(String targetDatabaseConnectionId) {
            this.targetDatabaseConnectionId = targetDatabaseConnectionId;
            this.__explicitlySet__.add("targetDatabaseConnectionId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder sourceContainerDatabaseConnectionId(String sourceContainerDatabaseConnectionId) {
            this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
            this.__explicitlySet__.add("sourceContainerDatabaseConnectionId");
            return this;
        }

        public OracleCloneMigrationDetails build() {
            OracleCloneMigrationDetails model = new OracleCloneMigrationDetails(this.displayName, this.compartmentId, this.sourceDatabaseConnectionId, this.targetDatabaseConnectionId, this.freeformTags, this.definedTags, this.sourceContainerDatabaseConnectionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleCloneMigrationDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseConnectionId")) {
                this.sourceDatabaseConnectionId(model.getSourceDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseConnectionId")) {
                this.targetDatabaseConnectionId(model.getTargetDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("sourceContainerDatabaseConnectionId")) {
                this.sourceContainerDatabaseConnectionId(model.getSourceContainerDatabaseConnectionId());
            }
            return this;
        }
    }
}

