/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.Connection;
import com.oracle.bmc.databasemigration.model.IngressIpDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class OracleConnection
extends Connection {
    @JsonProperty(value="technologyType")
    private final TechnologyType technologyType;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="sshHost")
    private final String sshHost;
    @JsonProperty(value="sshKey")
    private final String sshKey;
    @JsonProperty(value="sshUser")
    private final String sshUser;
    @JsonProperty(value="sshSudoLocation")
    private final String sshSudoLocation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleConnection(String id, String displayName, String description, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Connection.LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, String vaultId, String keyId, String subnetId, List<IngressIpDetails> ingressIps, List<String> nsgIds, String username, String password, String replicationUsername, String replicationPassword, String secretId, String privateEndpointId, TechnologyType technologyType, String connectionString, String databaseId, String sshHost, String sshKey, String sshUser, String sshSudoLocation) {
        super(id, displayName, description, compartmentId, freeformTags, definedTags, systemTags, lifecycleState, lifecycleDetails, timeCreated, timeUpdated, vaultId, keyId, subnetId, ingressIps, nsgIds, username, password, replicationUsername, replicationPassword, secretId, privateEndpointId);
        this.technologyType = technologyType;
        this.connectionString = connectionString;
        this.databaseId = databaseId;
        this.sshHost = sshHost;
        this.sshKey = sshKey;
        this.sshUser = sshUser;
        this.sshSudoLocation = sshSudoLocation;
    }

    public TechnologyType getTechnologyType() {
        return this.technologyType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getSshHost() {
        return this.sshHost;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public String getSshSudoLocation() {
        return this.sshSudoLocation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleConnection(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", technologyType=").append(String.valueOf((Object)this.technologyType));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", sshHost=").append(String.valueOf(this.sshHost));
        sb.append(", sshKey=").append(String.valueOf(this.sshKey));
        sb.append(", sshUser=").append(String.valueOf(this.sshUser));
        sb.append(", sshSudoLocation=").append(String.valueOf(this.sshSudoLocation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleConnection)) {
            return false;
        }
        OracleConnection other = (OracleConnection)((Object)o);
        return Objects.equals((Object)this.technologyType, (Object)other.technologyType) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.sshHost, other.sshHost) && Objects.equals(this.sshKey, other.sshKey) && Objects.equals(this.sshUser, other.sshUser) && Objects.equals(this.sshSudoLocation, other.sshSudoLocation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.sshHost == null ? 43 : this.sshHost.hashCode());
        result = result * 59 + (this.sshKey == null ? 43 : this.sshKey.hashCode());
        result = result * 59 + (this.sshUser == null ? 43 : this.sshUser.hashCode());
        result = result * 59 + (this.sshSudoLocation == null ? 43 : this.sshSudoLocation.hashCode());
        return result;
    }

    public static enum TechnologyType implements BmcEnum
    {
        AmazonRdsOracle("AMAZON_RDS_ORACLE"),
        OciAutonomousDatabase("OCI_AUTONOMOUS_DATABASE"),
        OracleDatabase("ORACLE_DATABASE"),
        OracleExadata("ORACLE_EXADATA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TechnologyType> map;

        private TechnologyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TechnologyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TechnologyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TechnologyType.class);
            map = new HashMap<String, TechnologyType>();
            for (TechnologyType v : TechnologyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="lifecycleState")
        private Connection.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="ingressIps")
        private List<IngressIpDetails> ingressIps;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="replicationUsername")
        private String replicationUsername;
        @JsonProperty(value="replicationPassword")
        private String replicationPassword;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonProperty(value="technologyType")
        private TechnologyType technologyType;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="sshHost")
        private String sshHost;
        @JsonProperty(value="sshKey")
        private String sshKey;
        @JsonProperty(value="sshUser")
        private String sshUser;
        @JsonProperty(value="sshSudoLocation")
        private String sshSudoLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder lifecycleState(Connection.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder ingressIps(List<IngressIpDetails> ingressIps) {
            this.ingressIps = ingressIps;
            this.__explicitlySet__.add("ingressIps");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder replicationUsername(String replicationUsername) {
            this.replicationUsername = replicationUsername;
            this.__explicitlySet__.add("replicationUsername");
            return this;
        }

        public Builder replicationPassword(String replicationPassword) {
            this.replicationPassword = replicationPassword;
            this.__explicitlySet__.add("replicationPassword");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public Builder technologyType(TechnologyType technologyType) {
            this.technologyType = technologyType;
            this.__explicitlySet__.add("technologyType");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder sshHost(String sshHost) {
            this.sshHost = sshHost;
            this.__explicitlySet__.add("sshHost");
            return this;
        }

        public Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            this.__explicitlySet__.add("sshKey");
            return this;
        }

        public Builder sshUser(String sshUser) {
            this.sshUser = sshUser;
            this.__explicitlySet__.add("sshUser");
            return this;
        }

        public Builder sshSudoLocation(String sshSudoLocation) {
            this.sshSudoLocation = sshSudoLocation;
            this.__explicitlySet__.add("sshSudoLocation");
            return this;
        }

        public OracleConnection build() {
            OracleConnection model = new OracleConnection(this.id, this.displayName, this.description, this.compartmentId, this.freeformTags, this.definedTags, this.systemTags, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.vaultId, this.keyId, this.subnetId, this.ingressIps, this.nsgIds, this.username, this.password, this.replicationUsername, this.replicationPassword, this.secretId, this.privateEndpointId, this.technologyType, this.connectionString, this.databaseId, this.sshHost, this.sshKey, this.sshUser, this.sshSudoLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleConnection model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("ingressIps")) {
                this.ingressIps(model.getIngressIps());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("replicationUsername")) {
                this.replicationUsername(model.getReplicationUsername());
            }
            if (model.wasPropertyExplicitlySet("replicationPassword")) {
                this.replicationPassword(model.getReplicationPassword());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("technologyType")) {
                this.technologyType(model.getTechnologyType());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("sshHost")) {
                this.sshHost(model.getSshHost());
            }
            if (model.wasPropertyExplicitlySet("sshKey")) {
                this.sshKey(model.getSshKey());
            }
            if (model.wasPropertyExplicitlySet("sshUser")) {
                this.sshUser(model.getSshUser());
            }
            if (model.wasPropertyExplicitlySet("sshSudoLocation")) {
                this.sshSudoLocation(model.getSshSudoLocation());
            }
            return this;
        }
    }
}

