/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum TechnologyType implements BmcEnum
{
    OciAutonomousDatabase("OCI_AUTONOMOUS_DATABASE"),
    OciMysql("OCI_MYSQL"),
    OracleDatabase("ORACLE_DATABASE"),
    OracleExadata("ORACLE_EXADATA"),
    AmazonRdsOracle("AMAZON_RDS_ORACLE"),
    AmazonAuroraMysql("AMAZON_AURORA_MYSQL"),
    AmazonRdsMysql("AMAZON_RDS_MYSQL"),
    AzureMysql("AZURE_MYSQL"),
    GoogleCloudSqlMysql("GOOGLE_CLOUD_SQL_MYSQL"),
    MysqlServer("MYSQL_SERVER");

    private final String value;
    private static Map<String, TechnologyType> map;

    private TechnologyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static TechnologyType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid TechnologyType: " + key);
    }

    static {
        map = new HashMap<String, TechnologyType>();
        for (TechnologyType v : TechnologyType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

