/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration;

import com.oracle.bmc.databasemigration.DatabaseMigration;
import com.oracle.bmc.databasemigration.model.ConnectionSummary;
import com.oracle.bmc.databasemigration.model.ExcludedObjectSummary;
import com.oracle.bmc.databasemigration.model.JobOutputSummary;
import com.oracle.bmc.databasemigration.model.JobSummary;
import com.oracle.bmc.databasemigration.model.MigrationObjectTypeSummary;
import com.oracle.bmc.databasemigration.model.MigrationParameterSummary;
import com.oracle.bmc.databasemigration.model.MigrationSummary;
import com.oracle.bmc.databasemigration.model.WorkRequestError;
import com.oracle.bmc.databasemigration.model.WorkRequestLogEntry;
import com.oracle.bmc.databasemigration.model.WorkRequestSummary;
import com.oracle.bmc.databasemigration.requests.ListConnectionsRequest;
import com.oracle.bmc.databasemigration.requests.ListExcludedObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobOutputsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobsRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationObjectTypesRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationParametersRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasemigration.responses.ListConnectionsResponse;
import com.oracle.bmc.databasemigration.responses.ListExcludedObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobOutputsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobsResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationObjectTypesResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationParametersResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DatabaseMigrationPaginators {
    private final DatabaseMigration client;

    public DatabaseMigrationPaginators(DatabaseMigration client) {
        this.client = client;
    }

    public Iterable<ListConnectionsResponse> listConnectionsResponseIterator(final ListConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DatabaseMigrationPaginators.this.client.listConnections(request);
            }
        });
    }

    public Iterable<ConnectionSummary> listConnectionsRecordIterator(final ListConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            @Override
            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            @Override
            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            @Override
            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            @Override
            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DatabaseMigrationPaginators.this.client.listConnections(request);
            }
        }, (Function)new Function<ListConnectionsResponse, List<ConnectionSummary>>(){

            @Override
            public List<ConnectionSummary> apply(ListConnectionsResponse response) {
                return response.getConnectionCollection().getItems();
            }
        });
    }

    public Iterable<ListExcludedObjectsResponse> listExcludedObjectsResponseIterator(final ListExcludedObjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExcludedObjectsRequest.Builder>(){

            @Override
            public ListExcludedObjectsRequest.Builder get() {
                return ListExcludedObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExcludedObjectsResponse, String>(){

            @Override
            public String apply(ListExcludedObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExcludedObjectsRequest.Builder>, ListExcludedObjectsRequest>(){

            @Override
            public ListExcludedObjectsRequest apply(RequestBuilderAndToken<ListExcludedObjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExcludedObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExcludedObjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExcludedObjectsRequest, ListExcludedObjectsResponse>(){

            @Override
            public ListExcludedObjectsResponse apply(ListExcludedObjectsRequest request) {
                return DatabaseMigrationPaginators.this.client.listExcludedObjects(request);
            }
        });
    }

    public Iterable<ExcludedObjectSummary> listExcludedObjectsRecordIterator(final ListExcludedObjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExcludedObjectsRequest.Builder>(){

            @Override
            public ListExcludedObjectsRequest.Builder get() {
                return ListExcludedObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExcludedObjectsResponse, String>(){

            @Override
            public String apply(ListExcludedObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExcludedObjectsRequest.Builder>, ListExcludedObjectsRequest>(){

            @Override
            public ListExcludedObjectsRequest apply(RequestBuilderAndToken<ListExcludedObjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExcludedObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExcludedObjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExcludedObjectsRequest, ListExcludedObjectsResponse>(){

            @Override
            public ListExcludedObjectsResponse apply(ListExcludedObjectsRequest request) {
                return DatabaseMigrationPaginators.this.client.listExcludedObjects(request);
            }
        }, (Function)new Function<ListExcludedObjectsResponse, List<ExcludedObjectSummary>>(){

            @Override
            public List<ExcludedObjectSummary> apply(ListExcludedObjectsResponse response) {
                return response.getExcludedObjectSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListJobOutputsResponse> listJobOutputsResponseIterator(final ListJobOutputsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobOutputsRequest.Builder>(){

            @Override
            public ListJobOutputsRequest.Builder get() {
                return ListJobOutputsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, String>(){

            @Override
            public String apply(ListJobOutputsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobOutputsRequest.Builder>, ListJobOutputsRequest>(){

            @Override
            public ListJobOutputsRequest apply(RequestBuilderAndToken<ListJobOutputsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobOutputsRequest, ListJobOutputsResponse>(){

            @Override
            public ListJobOutputsResponse apply(ListJobOutputsRequest request) {
                return DatabaseMigrationPaginators.this.client.listJobOutputs(request);
            }
        });
    }

    public Iterable<JobOutputSummary> listJobOutputsRecordIterator(final ListJobOutputsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobOutputsRequest.Builder>(){

            @Override
            public ListJobOutputsRequest.Builder get() {
                return ListJobOutputsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, String>(){

            @Override
            public String apply(ListJobOutputsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobOutputsRequest.Builder>, ListJobOutputsRequest>(){

            @Override
            public ListJobOutputsRequest apply(RequestBuilderAndToken<ListJobOutputsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobOutputsRequest, ListJobOutputsResponse>(){

            @Override
            public ListJobOutputsResponse apply(ListJobOutputsRequest request) {
                return DatabaseMigrationPaginators.this.client.listJobOutputs(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, List<JobOutputSummary>>(){

            @Override
            public List<JobOutputSummary> apply(ListJobOutputsResponse response) {
                return response.getJobOutputSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            @Override
            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            @Override
            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            @Override
            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            @Override
            public ListJobsResponse apply(ListJobsRequest request) {
                return DatabaseMigrationPaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            @Override
            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            @Override
            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            @Override
            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            @Override
            public ListJobsResponse apply(ListJobsRequest request) {
                return DatabaseMigrationPaginators.this.client.listJobs(request);
            }
        }, (Function)new Function<ListJobsResponse, List<JobSummary>>(){

            @Override
            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getJobCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationObjectTypesResponse> listMigrationObjectTypesResponseIterator(final ListMigrationObjectTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationObjectTypesRequest.Builder>(){

            @Override
            public ListMigrationObjectTypesRequest.Builder get() {
                return ListMigrationObjectTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationObjectTypesResponse, String>(){

            @Override
            public String apply(ListMigrationObjectTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationObjectTypesRequest.Builder>, ListMigrationObjectTypesRequest>(){

            @Override
            public ListMigrationObjectTypesRequest apply(RequestBuilderAndToken<ListMigrationObjectTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationObjectTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationObjectTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationObjectTypesRequest, ListMigrationObjectTypesResponse>(){

            @Override
            public ListMigrationObjectTypesResponse apply(ListMigrationObjectTypesRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrationObjectTypes(request);
            }
        });
    }

    public Iterable<MigrationObjectTypeSummary> listMigrationObjectTypesRecordIterator(final ListMigrationObjectTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationObjectTypesRequest.Builder>(){

            @Override
            public ListMigrationObjectTypesRequest.Builder get() {
                return ListMigrationObjectTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationObjectTypesResponse, String>(){

            @Override
            public String apply(ListMigrationObjectTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationObjectTypesRequest.Builder>, ListMigrationObjectTypesRequest>(){

            @Override
            public ListMigrationObjectTypesRequest apply(RequestBuilderAndToken<ListMigrationObjectTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationObjectTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationObjectTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationObjectTypesRequest, ListMigrationObjectTypesResponse>(){

            @Override
            public ListMigrationObjectTypesResponse apply(ListMigrationObjectTypesRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrationObjectTypes(request);
            }
        }, (Function)new Function<ListMigrationObjectTypesResponse, List<MigrationObjectTypeSummary>>(){

            @Override
            public List<MigrationObjectTypeSummary> apply(ListMigrationObjectTypesResponse response) {
                return response.getMigrationObjectTypeSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationParametersResponse> listMigrationParametersResponseIterator(final ListMigrationParametersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationParametersRequest.Builder>(){

            @Override
            public ListMigrationParametersRequest.Builder get() {
                return ListMigrationParametersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationParametersResponse, String>(){

            @Override
            public String apply(ListMigrationParametersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationParametersRequest.Builder>, ListMigrationParametersRequest>(){

            @Override
            public ListMigrationParametersRequest apply(RequestBuilderAndToken<ListMigrationParametersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationParametersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationParametersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationParametersRequest, ListMigrationParametersResponse>(){

            @Override
            public ListMigrationParametersResponse apply(ListMigrationParametersRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrationParameters(request);
            }
        });
    }

    public Iterable<MigrationParameterSummary> listMigrationParametersRecordIterator(final ListMigrationParametersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationParametersRequest.Builder>(){

            @Override
            public ListMigrationParametersRequest.Builder get() {
                return ListMigrationParametersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationParametersResponse, String>(){

            @Override
            public String apply(ListMigrationParametersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationParametersRequest.Builder>, ListMigrationParametersRequest>(){

            @Override
            public ListMigrationParametersRequest apply(RequestBuilderAndToken<ListMigrationParametersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationParametersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationParametersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationParametersRequest, ListMigrationParametersResponse>(){

            @Override
            public ListMigrationParametersResponse apply(ListMigrationParametersRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrationParameters(request);
            }
        }, (Function)new Function<ListMigrationParametersResponse, List<MigrationParameterSummary>>(){

            @Override
            public List<MigrationParameterSummary> apply(ListMigrationParametersResponse response) {
                return response.getMigrationParameterSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationsResponse> listMigrationsResponseIterator(final ListMigrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrations(request);
            }
        });
    }

    public Iterable<MigrationSummary> listMigrationsRecordIterator(final ListMigrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return DatabaseMigrationPaginators.this.client.listMigrations(request);
            }
        }, (Function)new Function<ListMigrationsResponse, List<MigrationSummary>>(){

            @Override
            public List<MigrationSummary> apply(ListMigrationsResponse response) {
                return response.getMigrationCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseMigrationPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

