/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.AdvisorReportLocationDetails;
import com.oracle.bmc.databasemigration.model.AdvisorResults;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AdvisorReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="reportLocationDetails")
    private final AdvisorReportLocationDetails reportLocationDetails;
    @JsonProperty(value="result")
    private final AdvisorResults result;
    @JsonProperty(value="numberOfFatal")
    private final Integer numberOfFatal;
    @JsonProperty(value="numberOfFatalBlockers")
    private final Integer numberOfFatalBlockers;
    @JsonProperty(value="numberOfWarnings")
    private final Integer numberOfWarnings;
    @JsonProperty(value="numberOfInformationalResults")
    private final Integer numberOfInformationalResults;

    @Deprecated
    @ConstructorProperties(value={"reportLocationDetails", "result", "numberOfFatal", "numberOfFatalBlockers", "numberOfWarnings", "numberOfInformationalResults"})
    public AdvisorReport(AdvisorReportLocationDetails reportLocationDetails, AdvisorResults result, Integer numberOfFatal, Integer numberOfFatalBlockers, Integer numberOfWarnings, Integer numberOfInformationalResults) {
        this.reportLocationDetails = reportLocationDetails;
        this.result = result;
        this.numberOfFatal = numberOfFatal;
        this.numberOfFatalBlockers = numberOfFatalBlockers;
        this.numberOfWarnings = numberOfWarnings;
        this.numberOfInformationalResults = numberOfInformationalResults;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AdvisorReportLocationDetails getReportLocationDetails() {
        return this.reportLocationDetails;
    }

    public AdvisorResults getResult() {
        return this.result;
    }

    public Integer getNumberOfFatal() {
        return this.numberOfFatal;
    }

    public Integer getNumberOfFatalBlockers() {
        return this.numberOfFatalBlockers;
    }

    public Integer getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public Integer getNumberOfInformationalResults() {
        return this.numberOfInformationalResults;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AdvisorReport(");
        sb.append("super=").append(super.toString());
        sb.append("reportLocationDetails=").append(String.valueOf((Object)this.reportLocationDetails));
        sb.append(", result=").append(String.valueOf((Object)this.result));
        sb.append(", numberOfFatal=").append(String.valueOf(this.numberOfFatal));
        sb.append(", numberOfFatalBlockers=").append(String.valueOf(this.numberOfFatalBlockers));
        sb.append(", numberOfWarnings=").append(String.valueOf(this.numberOfWarnings));
        sb.append(", numberOfInformationalResults=").append(String.valueOf(this.numberOfInformationalResults));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdvisorReport)) {
            return false;
        }
        AdvisorReport other = (AdvisorReport)((Object)o);
        return Objects.equals((Object)this.reportLocationDetails, (Object)other.reportLocationDetails) && Objects.equals((Object)this.result, (Object)other.result) && Objects.equals(this.numberOfFatal, other.numberOfFatal) && Objects.equals(this.numberOfFatalBlockers, other.numberOfFatalBlockers) && Objects.equals(this.numberOfWarnings, other.numberOfWarnings) && Objects.equals(this.numberOfInformationalResults, other.numberOfInformationalResults) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reportLocationDetails == null ? 43 : this.reportLocationDetails.hashCode());
        result = result * 59 + (this.result == null ? 43 : this.result.hashCode());
        result = result * 59 + (this.numberOfFatal == null ? 43 : this.numberOfFatal.hashCode());
        result = result * 59 + (this.numberOfFatalBlockers == null ? 43 : this.numberOfFatalBlockers.hashCode());
        result = result * 59 + (this.numberOfWarnings == null ? 43 : this.numberOfWarnings.hashCode());
        result = result * 59 + (this.numberOfInformationalResults == null ? 43 : this.numberOfInformationalResults.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="reportLocationDetails")
        private AdvisorReportLocationDetails reportLocationDetails;
        @JsonProperty(value="result")
        private AdvisorResults result;
        @JsonProperty(value="numberOfFatal")
        private Integer numberOfFatal;
        @JsonProperty(value="numberOfFatalBlockers")
        private Integer numberOfFatalBlockers;
        @JsonProperty(value="numberOfWarnings")
        private Integer numberOfWarnings;
        @JsonProperty(value="numberOfInformationalResults")
        private Integer numberOfInformationalResults;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder reportLocationDetails(AdvisorReportLocationDetails reportLocationDetails) {
            this.reportLocationDetails = reportLocationDetails;
            this.__explicitlySet__.add("reportLocationDetails");
            return this;
        }

        public Builder result(AdvisorResults result) {
            this.result = result;
            this.__explicitlySet__.add("result");
            return this;
        }

        public Builder numberOfFatal(Integer numberOfFatal) {
            this.numberOfFatal = numberOfFatal;
            this.__explicitlySet__.add("numberOfFatal");
            return this;
        }

        public Builder numberOfFatalBlockers(Integer numberOfFatalBlockers) {
            this.numberOfFatalBlockers = numberOfFatalBlockers;
            this.__explicitlySet__.add("numberOfFatalBlockers");
            return this;
        }

        public Builder numberOfWarnings(Integer numberOfWarnings) {
            this.numberOfWarnings = numberOfWarnings;
            this.__explicitlySet__.add("numberOfWarnings");
            return this;
        }

        public Builder numberOfInformationalResults(Integer numberOfInformationalResults) {
            this.numberOfInformationalResults = numberOfInformationalResults;
            this.__explicitlySet__.add("numberOfInformationalResults");
            return this;
        }

        public AdvisorReport build() {
            AdvisorReport model = new AdvisorReport(this.reportLocationDetails, this.result, this.numberOfFatal, this.numberOfFatalBlockers, this.numberOfWarnings, this.numberOfInformationalResults);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AdvisorReport model) {
            if (model.wasPropertyExplicitlySet("reportLocationDetails")) {
                this.reportLocationDetails(model.getReportLocationDetails());
            }
            if (model.wasPropertyExplicitlySet("result")) {
                this.result(model.getResult());
            }
            if (model.wasPropertyExplicitlySet("numberOfFatal")) {
                this.numberOfFatal(model.getNumberOfFatal());
            }
            if (model.wasPropertyExplicitlySet("numberOfFatalBlockers")) {
                this.numberOfFatalBlockers(model.getNumberOfFatalBlockers());
            }
            if (model.wasPropertyExplicitlySet("numberOfWarnings")) {
                this.numberOfWarnings(model.getNumberOfWarnings());
            }
            if (model.wasPropertyExplicitlySet("numberOfInformationalResults")) {
                this.numberOfInformationalResults(model.getNumberOfInformationalResults());
            }
            return this;
        }
    }
}

