/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.ObjectStoreBucket;
import com.oracle.bmc.databasemigration.model.OracleDataTransferMediumDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class OracleAwsS3DataTransferMediumDetails
extends OracleDataTransferMediumDetails {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="accessKeyId")
    private final String accessKeyId;
    @JsonProperty(value="secretAccessKey")
    private final String secretAccessKey;
    @JsonProperty(value="objectStorageBucket")
    private final ObjectStoreBucket objectStorageBucket;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleAwsS3DataTransferMediumDetails(String name, String region, String accessKeyId, String secretAccessKey, ObjectStoreBucket objectStorageBucket) {
        this.name = name;
        this.region = region;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.objectStorageBucket = objectStorageBucket;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public ObjectStoreBucket getObjectStorageBucket() {
        return this.objectStorageBucket;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleAwsS3DataTransferMediumDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", accessKeyId=").append("<redacted>");
        sb.append(", secretAccessKey=").append("<redacted>");
        sb.append(", objectStorageBucket=").append(String.valueOf((Object)this.objectStorageBucket));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleAwsS3DataTransferMediumDetails)) {
            return false;
        }
        OracleAwsS3DataTransferMediumDetails other = (OracleAwsS3DataTransferMediumDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.region, other.region) && Objects.equals(this.accessKeyId, other.accessKeyId) && Objects.equals(this.secretAccessKey, other.secretAccessKey) && Objects.equals((Object)this.objectStorageBucket, (Object)other.objectStorageBucket) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.accessKeyId == null ? 43 : this.accessKeyId.hashCode());
        result = result * 59 + (this.secretAccessKey == null ? 43 : this.secretAccessKey.hashCode());
        result = result * 59 + (this.objectStorageBucket == null ? 43 : this.objectStorageBucket.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="accessKeyId")
        private String accessKeyId;
        @JsonProperty(value="secretAccessKey")
        private String secretAccessKey;
        @JsonProperty(value="objectStorageBucket")
        private ObjectStoreBucket objectStorageBucket;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            this.__explicitlySet__.add("accessKeyId");
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            this.__explicitlySet__.add("secretAccessKey");
            return this;
        }

        public Builder objectStorageBucket(ObjectStoreBucket objectStorageBucket) {
            this.objectStorageBucket = objectStorageBucket;
            this.__explicitlySet__.add("objectStorageBucket");
            return this;
        }

        public OracleAwsS3DataTransferMediumDetails build() {
            OracleAwsS3DataTransferMediumDetails model = new OracleAwsS3DataTransferMediumDetails(this.name, this.region, this.accessKeyId, this.secretAccessKey, this.objectStorageBucket);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleAwsS3DataTransferMediumDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("accessKeyId")) {
                this.accessKeyId(model.getAccessKeyId());
            }
            if (model.wasPropertyExplicitlySet("secretAccessKey")) {
                this.secretAccessKey(model.getSecretAccessKey());
            }
            if (model.wasPropertyExplicitlySet("objectStorageBucket")) {
                this.objectStorageBucket(model.getObjectStorageBucket());
            }
            return this;
        }
    }
}

