/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CreateConnectionDetails;
import com.oracle.bmc.databasemigration.model.OracleConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOracleConnectionDetails
extends CreateConnectionDetails {
    @JsonProperty(value="technologyType")
    private final OracleConnection.TechnologyType technologyType;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="wallet")
    private final String wallet;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="sshHost")
    private final String sshHost;
    @JsonProperty(value="sshKey")
    private final String sshKey;
    @JsonProperty(value="sshUser")
    private final String sshUser;
    @JsonProperty(value="sshSudoLocation")
    private final String sshSudoLocation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOracleConnectionDetails(String displayName, String description, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String vaultId, String keyId, String subnetId, List<String> nsgIds, String username, String password, String replicationUsername, String replicationPassword, OracleConnection.TechnologyType technologyType, String connectionString, String wallet, String databaseId, String sshHost, String sshKey, String sshUser, String sshSudoLocation) {
        super(displayName, description, compartmentId, freeformTags, definedTags, vaultId, keyId, subnetId, nsgIds, username, password, replicationUsername, replicationPassword);
        this.technologyType = technologyType;
        this.connectionString = connectionString;
        this.wallet = wallet;
        this.databaseId = databaseId;
        this.sshHost = sshHost;
        this.sshKey = sshKey;
        this.sshUser = sshUser;
        this.sshSudoLocation = sshSudoLocation;
    }

    public OracleConnection.TechnologyType getTechnologyType() {
        return this.technologyType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getWallet() {
        return this.wallet;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getSshHost() {
        return this.sshHost;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public String getSshSudoLocation() {
        return this.sshSudoLocation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOracleConnectionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", technologyType=").append(String.valueOf((Object)this.technologyType));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", wallet=").append(String.valueOf(this.wallet));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", sshHost=").append(String.valueOf(this.sshHost));
        sb.append(", sshKey=").append(String.valueOf(this.sshKey));
        sb.append(", sshUser=").append(String.valueOf(this.sshUser));
        sb.append(", sshSudoLocation=").append(String.valueOf(this.sshSudoLocation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOracleConnectionDetails)) {
            return false;
        }
        CreateOracleConnectionDetails other = (CreateOracleConnectionDetails)((Object)o);
        return Objects.equals((Object)this.technologyType, (Object)other.technologyType) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.wallet, other.wallet) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.sshHost, other.sshHost) && Objects.equals(this.sshKey, other.sshKey) && Objects.equals(this.sshUser, other.sshUser) && Objects.equals(this.sshSudoLocation, other.sshSudoLocation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.technologyType == null ? 43 : this.technologyType.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.wallet == null ? 43 : this.wallet.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.sshHost == null ? 43 : this.sshHost.hashCode());
        result = result * 59 + (this.sshKey == null ? 43 : this.sshKey.hashCode());
        result = result * 59 + (this.sshUser == null ? 43 : this.sshUser.hashCode());
        result = result * 59 + (this.sshSudoLocation == null ? 43 : this.sshSudoLocation.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="replicationUsername")
        private String replicationUsername;
        @JsonProperty(value="replicationPassword")
        private String replicationPassword;
        @JsonProperty(value="technologyType")
        private OracleConnection.TechnologyType technologyType;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="wallet")
        private String wallet;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="sshHost")
        private String sshHost;
        @JsonProperty(value="sshKey")
        private String sshKey;
        @JsonProperty(value="sshUser")
        private String sshUser;
        @JsonProperty(value="sshSudoLocation")
        private String sshSudoLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder replicationUsername(String replicationUsername) {
            this.replicationUsername = replicationUsername;
            this.__explicitlySet__.add("replicationUsername");
            return this;
        }

        public Builder replicationPassword(String replicationPassword) {
            this.replicationPassword = replicationPassword;
            this.__explicitlySet__.add("replicationPassword");
            return this;
        }

        public Builder technologyType(OracleConnection.TechnologyType technologyType) {
            this.technologyType = technologyType;
            this.__explicitlySet__.add("technologyType");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder wallet(String wallet) {
            this.wallet = wallet;
            this.__explicitlySet__.add("wallet");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder sshHost(String sshHost) {
            this.sshHost = sshHost;
            this.__explicitlySet__.add("sshHost");
            return this;
        }

        public Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            this.__explicitlySet__.add("sshKey");
            return this;
        }

        public Builder sshUser(String sshUser) {
            this.sshUser = sshUser;
            this.__explicitlySet__.add("sshUser");
            return this;
        }

        public Builder sshSudoLocation(String sshSudoLocation) {
            this.sshSudoLocation = sshSudoLocation;
            this.__explicitlySet__.add("sshSudoLocation");
            return this;
        }

        public CreateOracleConnectionDetails build() {
            CreateOracleConnectionDetails model = new CreateOracleConnectionDetails(this.displayName, this.description, this.compartmentId, this.freeformTags, this.definedTags, this.vaultId, this.keyId, this.subnetId, this.nsgIds, this.username, this.password, this.replicationUsername, this.replicationPassword, this.technologyType, this.connectionString, this.wallet, this.databaseId, this.sshHost, this.sshKey, this.sshUser, this.sshSudoLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOracleConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("replicationUsername")) {
                this.replicationUsername(model.getReplicationUsername());
            }
            if (model.wasPropertyExplicitlySet("replicationPassword")) {
                this.replicationPassword(model.getReplicationPassword());
            }
            if (model.wasPropertyExplicitlySet("technologyType")) {
                this.technologyType(model.getTechnologyType());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("wallet")) {
                this.wallet(model.getWallet());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("sshHost")) {
                this.sshHost(model.getSshHost());
            }
            if (model.wasPropertyExplicitlySet("sshKey")) {
                this.sshKey(model.getSshKey());
            }
            if (model.wasPropertyExplicitlySet("sshUser")) {
                this.sshUser(model.getSshUser());
            }
            if (model.wasPropertyExplicitlySet("sshSudoLocation")) {
                this.sshSudoLocation(model.getSshSudoLocation());
            }
            return this;
        }
    }
}

