/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.GoldenGateHubDetails;
import com.oracle.bmc.databasemigration.model.Migration;
import com.oracle.bmc.databasemigration.model.MigrationLifecycleStates;
import com.oracle.bmc.databasemigration.model.MigrationParameterDetails;
import com.oracle.bmc.databasemigration.model.MigrationStatus;
import com.oracle.bmc.databasemigration.model.MigrationTypes;
import com.oracle.bmc.databasemigration.model.OdmsJobPhases;
import com.oracle.bmc.databasemigration.model.OracleAdvisorSettings;
import com.oracle.bmc.databasemigration.model.OracleDataTransferMediumDetails;
import com.oracle.bmc.databasemigration.model.OracleGgsDeploymentDetails;
import com.oracle.bmc.databasemigration.model.OracleInitialLoadSettings;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseCombination")
@JsonFilter(value="explicitlySetFilter")
public final class OracleMigration
extends Migration {
    @JsonProperty(value="dataTransferMediumDetails")
    private final OracleDataTransferMediumDetails dataTransferMediumDetails;
    @JsonProperty(value="initialLoadSettings")
    private final OracleInitialLoadSettings initialLoadSettings;
    @JsonProperty(value="advisorSettings")
    private final OracleAdvisorSettings advisorSettings;
    @JsonProperty(value="hubDetails")
    private final GoldenGateHubDetails hubDetails;
    @JsonProperty(value="ggsDetails")
    private final OracleGgsDeploymentDetails ggsDetails;
    @JsonProperty(value="sourceContainerDatabaseConnectionId")
    private final String sourceContainerDatabaseConnectionId;
    @JsonProperty(value="advancedParameters")
    private final List<MigrationParameterDetails> advancedParameters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleMigration(String id, String description, String displayName, String compartmentId, MigrationTypes type, OdmsJobPhases waitAfter, String sourceDatabaseConnectionId, String targetDatabaseConnectionId, String executingJobId, Date timeCreated, Date timeUpdated, Date timeLastMigration, MigrationLifecycleStates lifecycleState, MigrationStatus lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, OracleDataTransferMediumDetails dataTransferMediumDetails, OracleInitialLoadSettings initialLoadSettings, OracleAdvisorSettings advisorSettings, GoldenGateHubDetails hubDetails, OracleGgsDeploymentDetails ggsDetails, String sourceContainerDatabaseConnectionId, List<MigrationParameterDetails> advancedParameters) {
        super(id, description, displayName, compartmentId, type, waitAfter, sourceDatabaseConnectionId, targetDatabaseConnectionId, executingJobId, timeCreated, timeUpdated, timeLastMigration, lifecycleState, lifecycleDetails, freeformTags, definedTags, systemTags);
        this.dataTransferMediumDetails = dataTransferMediumDetails;
        this.initialLoadSettings = initialLoadSettings;
        this.advisorSettings = advisorSettings;
        this.hubDetails = hubDetails;
        this.ggsDetails = ggsDetails;
        this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
        this.advancedParameters = advancedParameters;
    }

    public OracleDataTransferMediumDetails getDataTransferMediumDetails() {
        return this.dataTransferMediumDetails;
    }

    public OracleInitialLoadSettings getInitialLoadSettings() {
        return this.initialLoadSettings;
    }

    public OracleAdvisorSettings getAdvisorSettings() {
        return this.advisorSettings;
    }

    public GoldenGateHubDetails getHubDetails() {
        return this.hubDetails;
    }

    public OracleGgsDeploymentDetails getGgsDetails() {
        return this.ggsDetails;
    }

    public String getSourceContainerDatabaseConnectionId() {
        return this.sourceContainerDatabaseConnectionId;
    }

    public List<MigrationParameterDetails> getAdvancedParameters() {
        return this.advancedParameters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleMigration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dataTransferMediumDetails=").append(String.valueOf((Object)this.dataTransferMediumDetails));
        sb.append(", initialLoadSettings=").append(String.valueOf((Object)this.initialLoadSettings));
        sb.append(", advisorSettings=").append(String.valueOf((Object)this.advisorSettings));
        sb.append(", hubDetails=").append(String.valueOf((Object)this.hubDetails));
        sb.append(", ggsDetails=").append(String.valueOf((Object)this.ggsDetails));
        sb.append(", sourceContainerDatabaseConnectionId=").append(String.valueOf(this.sourceContainerDatabaseConnectionId));
        sb.append(", advancedParameters=").append(String.valueOf(this.advancedParameters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleMigration)) {
            return false;
        }
        OracleMigration other = (OracleMigration)((Object)o);
        return Objects.equals((Object)this.dataTransferMediumDetails, (Object)other.dataTransferMediumDetails) && Objects.equals((Object)this.initialLoadSettings, (Object)other.initialLoadSettings) && Objects.equals((Object)this.advisorSettings, (Object)other.advisorSettings) && Objects.equals((Object)this.hubDetails, (Object)other.hubDetails) && Objects.equals((Object)this.ggsDetails, (Object)other.ggsDetails) && Objects.equals(this.sourceContainerDatabaseConnectionId, other.sourceContainerDatabaseConnectionId) && Objects.equals(this.advancedParameters, other.advancedParameters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataTransferMediumDetails == null ? 43 : this.dataTransferMediumDetails.hashCode());
        result = result * 59 + (this.initialLoadSettings == null ? 43 : this.initialLoadSettings.hashCode());
        result = result * 59 + (this.advisorSettings == null ? 43 : this.advisorSettings.hashCode());
        result = result * 59 + (this.hubDetails == null ? 43 : this.hubDetails.hashCode());
        result = result * 59 + (this.ggsDetails == null ? 43 : this.ggsDetails.hashCode());
        result = result * 59 + (this.sourceContainerDatabaseConnectionId == null ? 43 : this.sourceContainerDatabaseConnectionId.hashCode());
        result = result * 59 + (this.advancedParameters == null ? 43 : this.advancedParameters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="type")
        private MigrationTypes type;
        @JsonProperty(value="waitAfter")
        private OdmsJobPhases waitAfter;
        @JsonProperty(value="sourceDatabaseConnectionId")
        private String sourceDatabaseConnectionId;
        @JsonProperty(value="targetDatabaseConnectionId")
        private String targetDatabaseConnectionId;
        @JsonProperty(value="executingJobId")
        private String executingJobId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeLastMigration")
        private Date timeLastMigration;
        @JsonProperty(value="lifecycleState")
        private MigrationLifecycleStates lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private MigrationStatus lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="dataTransferMediumDetails")
        private OracleDataTransferMediumDetails dataTransferMediumDetails;
        @JsonProperty(value="initialLoadSettings")
        private OracleInitialLoadSettings initialLoadSettings;
        @JsonProperty(value="advisorSettings")
        private OracleAdvisorSettings advisorSettings;
        @JsonProperty(value="hubDetails")
        private GoldenGateHubDetails hubDetails;
        @JsonProperty(value="ggsDetails")
        private OracleGgsDeploymentDetails ggsDetails;
        @JsonProperty(value="sourceContainerDatabaseConnectionId")
        private String sourceContainerDatabaseConnectionId;
        @JsonProperty(value="advancedParameters")
        private List<MigrationParameterDetails> advancedParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder type(MigrationTypes type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder waitAfter(OdmsJobPhases waitAfter) {
            this.waitAfter = waitAfter;
            this.__explicitlySet__.add("waitAfter");
            return this;
        }

        public Builder sourceDatabaseConnectionId(String sourceDatabaseConnectionId) {
            this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
            this.__explicitlySet__.add("sourceDatabaseConnectionId");
            return this;
        }

        public Builder targetDatabaseConnectionId(String targetDatabaseConnectionId) {
            this.targetDatabaseConnectionId = targetDatabaseConnectionId;
            this.__explicitlySet__.add("targetDatabaseConnectionId");
            return this;
        }

        public Builder executingJobId(String executingJobId) {
            this.executingJobId = executingJobId;
            this.__explicitlySet__.add("executingJobId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeLastMigration(Date timeLastMigration) {
            this.timeLastMigration = timeLastMigration;
            this.__explicitlySet__.add("timeLastMigration");
            return this;
        }

        public Builder lifecycleState(MigrationLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(MigrationStatus lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder dataTransferMediumDetails(OracleDataTransferMediumDetails dataTransferMediumDetails) {
            this.dataTransferMediumDetails = dataTransferMediumDetails;
            this.__explicitlySet__.add("dataTransferMediumDetails");
            return this;
        }

        public Builder initialLoadSettings(OracleInitialLoadSettings initialLoadSettings) {
            this.initialLoadSettings = initialLoadSettings;
            this.__explicitlySet__.add("initialLoadSettings");
            return this;
        }

        public Builder advisorSettings(OracleAdvisorSettings advisorSettings) {
            this.advisorSettings = advisorSettings;
            this.__explicitlySet__.add("advisorSettings");
            return this;
        }

        public Builder hubDetails(GoldenGateHubDetails hubDetails) {
            this.hubDetails = hubDetails;
            this.__explicitlySet__.add("hubDetails");
            return this;
        }

        public Builder ggsDetails(OracleGgsDeploymentDetails ggsDetails) {
            this.ggsDetails = ggsDetails;
            this.__explicitlySet__.add("ggsDetails");
            return this;
        }

        public Builder sourceContainerDatabaseConnectionId(String sourceContainerDatabaseConnectionId) {
            this.sourceContainerDatabaseConnectionId = sourceContainerDatabaseConnectionId;
            this.__explicitlySet__.add("sourceContainerDatabaseConnectionId");
            return this;
        }

        public Builder advancedParameters(List<MigrationParameterDetails> advancedParameters) {
            this.advancedParameters = advancedParameters;
            this.__explicitlySet__.add("advancedParameters");
            return this;
        }

        public OracleMigration build() {
            OracleMigration model = new OracleMigration(this.id, this.description, this.displayName, this.compartmentId, this.type, this.waitAfter, this.sourceDatabaseConnectionId, this.targetDatabaseConnectionId, this.executingJobId, this.timeCreated, this.timeUpdated, this.timeLastMigration, this.lifecycleState, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags, this.dataTransferMediumDetails, this.initialLoadSettings, this.advisorSettings, this.hubDetails, this.ggsDetails, this.sourceContainerDatabaseConnectionId, this.advancedParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleMigration model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("waitAfter")) {
                this.waitAfter(model.getWaitAfter());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseConnectionId")) {
                this.sourceDatabaseConnectionId(model.getSourceDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseConnectionId")) {
                this.targetDatabaseConnectionId(model.getTargetDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("executingJobId")) {
                this.executingJobId(model.getExecutingJobId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeLastMigration")) {
                this.timeLastMigration(model.getTimeLastMigration());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("dataTransferMediumDetails")) {
                this.dataTransferMediumDetails(model.getDataTransferMediumDetails());
            }
            if (model.wasPropertyExplicitlySet("initialLoadSettings")) {
                this.initialLoadSettings(model.getInitialLoadSettings());
            }
            if (model.wasPropertyExplicitlySet("advisorSettings")) {
                this.advisorSettings(model.getAdvisorSettings());
            }
            if (model.wasPropertyExplicitlySet("hubDetails")) {
                this.hubDetails(model.getHubDetails());
            }
            if (model.wasPropertyExplicitlySet("ggsDetails")) {
                this.ggsDetails(model.getGgsDetails());
            }
            if (model.wasPropertyExplicitlySet("sourceContainerDatabaseConnectionId")) {
                this.sourceContainerDatabaseConnectionId(model.getSourceContainerDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("advancedParameters")) {
                this.advancedParameters(model.getAdvancedParameters());
            }
            return this;
        }
    }
}

