/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.MigrationObjectCollection;
import com.oracle.bmc.databasemigration.model.OracleDatabaseObjectSummary;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseCombination")
@JsonFilter(value="explicitlySetFilter")
public final class OracleMigrationObjectCollection
extends MigrationObjectCollection {
    @JsonProperty(value="items")
    private final List<OracleDatabaseObjectSummary> items;
    @JsonProperty(value="bulkIncludeExcludeData")
    private final String bulkIncludeExcludeData;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleMigrationObjectCollection(List<OracleDatabaseObjectSummary> items, String bulkIncludeExcludeData) {
        this.items = items;
        this.bulkIncludeExcludeData = bulkIncludeExcludeData;
    }

    public List<OracleDatabaseObjectSummary> getItems() {
        return this.items;
    }

    public String getBulkIncludeExcludeData() {
        return this.bulkIncludeExcludeData;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleMigrationObjectCollection(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(", bulkIncludeExcludeData=").append(String.valueOf(this.bulkIncludeExcludeData));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleMigrationObjectCollection)) {
            return false;
        }
        OracleMigrationObjectCollection other = (OracleMigrationObjectCollection)((Object)o);
        return Objects.equals(this.items, other.items) && Objects.equals(this.bulkIncludeExcludeData, other.bulkIncludeExcludeData) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.bulkIncludeExcludeData == null ? 43 : this.bulkIncludeExcludeData.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="items")
        private List<OracleDatabaseObjectSummary> items;
        @JsonProperty(value="bulkIncludeExcludeData")
        private String bulkIncludeExcludeData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder items(List<OracleDatabaseObjectSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder bulkIncludeExcludeData(String bulkIncludeExcludeData) {
            this.bulkIncludeExcludeData = bulkIncludeExcludeData;
            this.__explicitlySet__.add("bulkIncludeExcludeData");
            return this;
        }

        public OracleMigrationObjectCollection build() {
            OracleMigrationObjectCollection model = new OracleMigrationObjectCollection(this.items, this.bulkIncludeExcludeData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleMigrationObjectCollection model) {
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("bulkIncludeExcludeData")) {
                this.bulkIncludeExcludeData(model.getBulkIncludeExcludeData());
            }
            return this;
        }
    }
}

