/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.JobParameterFileVersionKind;
import com.oracle.bmc.databasemigration.model.JobPhaseStatus;
import com.oracle.bmc.databasemigration.model.LogLocationBucketDetails;
import com.oracle.bmc.databasemigration.model.OdmsJobPhases;
import com.oracle.bmc.databasemigration.model.PhaseExtractEntry;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PhaseStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final OdmsJobPhases name;
    @JsonProperty(value="status")
    private final JobPhaseStatus status;
    @JsonProperty(value="durationInMs")
    private final Integer durationInMs;
    @JsonProperty(value="isAdvisorReportAvailable")
    private final Boolean isAdvisorReportAvailable;
    @JsonProperty(value="issue")
    private final String issue;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="extract")
    private final List<PhaseExtractEntry> extract;
    @JsonProperty(value="logLocation")
    private final LogLocationBucketDetails logLocation;
    @JsonProperty(value="progress")
    private final Integer progress;
    @JsonProperty(value="isSuspendAvailable")
    private final Boolean isSuspendAvailable;
    @JsonProperty(value="editableParameterFiles")
    private final List<JobParameterFileVersionKind> editableParameterFiles;

    @Deprecated
    @ConstructorProperties(value={"name", "status", "durationInMs", "isAdvisorReportAvailable", "issue", "action", "extract", "logLocation", "progress", "isSuspendAvailable", "editableParameterFiles"})
    public PhaseStatus(OdmsJobPhases name, JobPhaseStatus status, Integer durationInMs, Boolean isAdvisorReportAvailable, String issue, String action, List<PhaseExtractEntry> extract, LogLocationBucketDetails logLocation, Integer progress, Boolean isSuspendAvailable, List<JobParameterFileVersionKind> editableParameterFiles) {
        this.name = name;
        this.status = status;
        this.durationInMs = durationInMs;
        this.isAdvisorReportAvailable = isAdvisorReportAvailable;
        this.issue = issue;
        this.action = action;
        this.extract = extract;
        this.logLocation = logLocation;
        this.progress = progress;
        this.isSuspendAvailable = isSuspendAvailable;
        this.editableParameterFiles = editableParameterFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OdmsJobPhases getName() {
        return this.name;
    }

    public JobPhaseStatus getStatus() {
        return this.status;
    }

    public Integer getDurationInMs() {
        return this.durationInMs;
    }

    public Boolean getIsAdvisorReportAvailable() {
        return this.isAdvisorReportAvailable;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getAction() {
        return this.action;
    }

    public List<PhaseExtractEntry> getExtract() {
        return this.extract;
    }

    public LogLocationBucketDetails getLogLocation() {
        return this.logLocation;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public Boolean getIsSuspendAvailable() {
        return this.isSuspendAvailable;
    }

    public List<JobParameterFileVersionKind> getEditableParameterFiles() {
        return this.editableParameterFiles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PhaseStatus(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf((Object)this.name));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", durationInMs=").append(String.valueOf(this.durationInMs));
        sb.append(", isAdvisorReportAvailable=").append(String.valueOf(this.isAdvisorReportAvailable));
        sb.append(", issue=").append(String.valueOf(this.issue));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", extract=").append(String.valueOf(this.extract));
        sb.append(", logLocation=").append(String.valueOf((Object)this.logLocation));
        sb.append(", progress=").append(String.valueOf(this.progress));
        sb.append(", isSuspendAvailable=").append(String.valueOf(this.isSuspendAvailable));
        sb.append(", editableParameterFiles=").append(String.valueOf(this.editableParameterFiles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhaseStatus)) {
            return false;
        }
        PhaseStatus other = (PhaseStatus)((Object)o);
        return Objects.equals((Object)this.name, (Object)other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.durationInMs, other.durationInMs) && Objects.equals(this.isAdvisorReportAvailable, other.isAdvisorReportAvailable) && Objects.equals(this.issue, other.issue) && Objects.equals(this.action, other.action) && Objects.equals(this.extract, other.extract) && Objects.equals((Object)this.logLocation, (Object)other.logLocation) && Objects.equals(this.progress, other.progress) && Objects.equals(this.isSuspendAvailable, other.isSuspendAvailable) && Objects.equals(this.editableParameterFiles, other.editableParameterFiles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.durationInMs == null ? 43 : this.durationInMs.hashCode());
        result = result * 59 + (this.isAdvisorReportAvailable == null ? 43 : this.isAdvisorReportAvailable.hashCode());
        result = result * 59 + (this.issue == null ? 43 : this.issue.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.extract == null ? 43 : this.extract.hashCode());
        result = result * 59 + (this.logLocation == null ? 43 : this.logLocation.hashCode());
        result = result * 59 + (this.progress == null ? 43 : this.progress.hashCode());
        result = result * 59 + (this.isSuspendAvailable == null ? 43 : this.isSuspendAvailable.hashCode());
        result = result * 59 + (this.editableParameterFiles == null ? 43 : this.editableParameterFiles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private OdmsJobPhases name;
        @JsonProperty(value="status")
        private JobPhaseStatus status;
        @JsonProperty(value="durationInMs")
        private Integer durationInMs;
        @JsonProperty(value="isAdvisorReportAvailable")
        private Boolean isAdvisorReportAvailable;
        @JsonProperty(value="issue")
        private String issue;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="extract")
        private List<PhaseExtractEntry> extract;
        @JsonProperty(value="logLocation")
        private LogLocationBucketDetails logLocation;
        @JsonProperty(value="progress")
        private Integer progress;
        @JsonProperty(value="isSuspendAvailable")
        private Boolean isSuspendAvailable;
        @JsonProperty(value="editableParameterFiles")
        private List<JobParameterFileVersionKind> editableParameterFiles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(OdmsJobPhases name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(JobPhaseStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder durationInMs(Integer durationInMs) {
            this.durationInMs = durationInMs;
            this.__explicitlySet__.add("durationInMs");
            return this;
        }

        public Builder isAdvisorReportAvailable(Boolean isAdvisorReportAvailable) {
            this.isAdvisorReportAvailable = isAdvisorReportAvailable;
            this.__explicitlySet__.add("isAdvisorReportAvailable");
            return this;
        }

        public Builder issue(String issue) {
            this.issue = issue;
            this.__explicitlySet__.add("issue");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder extract(List<PhaseExtractEntry> extract) {
            this.extract = extract;
            this.__explicitlySet__.add("extract");
            return this;
        }

        public Builder logLocation(LogLocationBucketDetails logLocation) {
            this.logLocation = logLocation;
            this.__explicitlySet__.add("logLocation");
            return this;
        }

        public Builder progress(Integer progress) {
            this.progress = progress;
            this.__explicitlySet__.add("progress");
            return this;
        }

        public Builder isSuspendAvailable(Boolean isSuspendAvailable) {
            this.isSuspendAvailable = isSuspendAvailable;
            this.__explicitlySet__.add("isSuspendAvailable");
            return this;
        }

        public Builder editableParameterFiles(List<JobParameterFileVersionKind> editableParameterFiles) {
            this.editableParameterFiles = editableParameterFiles;
            this.__explicitlySet__.add("editableParameterFiles");
            return this;
        }

        public PhaseStatus build() {
            PhaseStatus model = new PhaseStatus(this.name, this.status, this.durationInMs, this.isAdvisorReportAvailable, this.issue, this.action, this.extract, this.logLocation, this.progress, this.isSuspendAvailable, this.editableParameterFiles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PhaseStatus model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("durationInMs")) {
                this.durationInMs(model.getDurationInMs());
            }
            if (model.wasPropertyExplicitlySet("isAdvisorReportAvailable")) {
                this.isAdvisorReportAvailable(model.getIsAdvisorReportAvailable());
            }
            if (model.wasPropertyExplicitlySet("issue")) {
                this.issue(model.getIssue());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("extract")) {
                this.extract(model.getExtract());
            }
            if (model.wasPropertyExplicitlySet("logLocation")) {
                this.logLocation(model.getLogLocation());
            }
            if (model.wasPropertyExplicitlySet("progress")) {
                this.progress(model.getProgress());
            }
            if (model.wasPropertyExplicitlySet("isSuspendAvailable")) {
                this.isSuspendAvailable(model.getIsSuspendAvailable());
            }
            if (model.wasPropertyExplicitlySet("editableParameterFiles")) {
                this.editableParameterFiles(model.getEditableParameterFiles());
            }
            return this;
        }
    }
}

