/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.MigrationTypes;
import com.oracle.bmc.databasemigration.model.UpdateGoldenGateHubDetails;
import com.oracle.bmc.databasemigration.model.UpdateMigrationDetails;
import com.oracle.bmc.databasemigration.model.UpdateMySqlAdvisorSettings;
import com.oracle.bmc.databasemigration.model.UpdateMySqlDataTransferMediumDetails;
import com.oracle.bmc.databasemigration.model.UpdateMySqlGgsDeploymentDetails;
import com.oracle.bmc.databasemigration.model.UpdateMySqlInitialLoadSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseCombination")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateMySqlMigrationDetails
extends UpdateMigrationDetails {
    @JsonProperty(value="dataTransferMediumDetails")
    private final UpdateMySqlDataTransferMediumDetails dataTransferMediumDetails;
    @JsonProperty(value="initialLoadSettings")
    private final UpdateMySqlInitialLoadSettings initialLoadSettings;
    @JsonProperty(value="advisorSettings")
    private final UpdateMySqlAdvisorSettings advisorSettings;
    @JsonProperty(value="hubDetails")
    private final UpdateGoldenGateHubDetails hubDetails;
    @JsonProperty(value="ggsDetails")
    private final UpdateMySqlGgsDeploymentDetails ggsDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateMySqlMigrationDetails(String description, MigrationTypes type, String displayName, String sourceDatabaseConnectionId, String targetDatabaseConnectionId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, UpdateMySqlDataTransferMediumDetails dataTransferMediumDetails, UpdateMySqlInitialLoadSettings initialLoadSettings, UpdateMySqlAdvisorSettings advisorSettings, UpdateGoldenGateHubDetails hubDetails, UpdateMySqlGgsDeploymentDetails ggsDetails) {
        super(description, type, displayName, sourceDatabaseConnectionId, targetDatabaseConnectionId, freeformTags, definedTags);
        this.dataTransferMediumDetails = dataTransferMediumDetails;
        this.initialLoadSettings = initialLoadSettings;
        this.advisorSettings = advisorSettings;
        this.hubDetails = hubDetails;
        this.ggsDetails = ggsDetails;
    }

    public UpdateMySqlDataTransferMediumDetails getDataTransferMediumDetails() {
        return this.dataTransferMediumDetails;
    }

    public UpdateMySqlInitialLoadSettings getInitialLoadSettings() {
        return this.initialLoadSettings;
    }

    public UpdateMySqlAdvisorSettings getAdvisorSettings() {
        return this.advisorSettings;
    }

    public UpdateGoldenGateHubDetails getHubDetails() {
        return this.hubDetails;
    }

    public UpdateMySqlGgsDeploymentDetails getGgsDetails() {
        return this.ggsDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateMySqlMigrationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dataTransferMediumDetails=").append(String.valueOf((Object)this.dataTransferMediumDetails));
        sb.append(", initialLoadSettings=").append(String.valueOf((Object)this.initialLoadSettings));
        sb.append(", advisorSettings=").append(String.valueOf((Object)this.advisorSettings));
        sb.append(", hubDetails=").append(String.valueOf((Object)this.hubDetails));
        sb.append(", ggsDetails=").append(String.valueOf((Object)this.ggsDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMySqlMigrationDetails)) {
            return false;
        }
        UpdateMySqlMigrationDetails other = (UpdateMySqlMigrationDetails)((Object)o);
        return Objects.equals((Object)this.dataTransferMediumDetails, (Object)other.dataTransferMediumDetails) && Objects.equals((Object)this.initialLoadSettings, (Object)other.initialLoadSettings) && Objects.equals((Object)this.advisorSettings, (Object)other.advisorSettings) && Objects.equals((Object)this.hubDetails, (Object)other.hubDetails) && Objects.equals((Object)this.ggsDetails, (Object)other.ggsDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataTransferMediumDetails == null ? 43 : this.dataTransferMediumDetails.hashCode());
        result = result * 59 + (this.initialLoadSettings == null ? 43 : this.initialLoadSettings.hashCode());
        result = result * 59 + (this.advisorSettings == null ? 43 : this.advisorSettings.hashCode());
        result = result * 59 + (this.hubDetails == null ? 43 : this.hubDetails.hashCode());
        result = result * 59 + (this.ggsDetails == null ? 43 : this.ggsDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private MigrationTypes type;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="sourceDatabaseConnectionId")
        private String sourceDatabaseConnectionId;
        @JsonProperty(value="targetDatabaseConnectionId")
        private String targetDatabaseConnectionId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="dataTransferMediumDetails")
        private UpdateMySqlDataTransferMediumDetails dataTransferMediumDetails;
        @JsonProperty(value="initialLoadSettings")
        private UpdateMySqlInitialLoadSettings initialLoadSettings;
        @JsonProperty(value="advisorSettings")
        private UpdateMySqlAdvisorSettings advisorSettings;
        @JsonProperty(value="hubDetails")
        private UpdateGoldenGateHubDetails hubDetails;
        @JsonProperty(value="ggsDetails")
        private UpdateMySqlGgsDeploymentDetails ggsDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder type(MigrationTypes type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder sourceDatabaseConnectionId(String sourceDatabaseConnectionId) {
            this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
            this.__explicitlySet__.add("sourceDatabaseConnectionId");
            return this;
        }

        public Builder targetDatabaseConnectionId(String targetDatabaseConnectionId) {
            this.targetDatabaseConnectionId = targetDatabaseConnectionId;
            this.__explicitlySet__.add("targetDatabaseConnectionId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder dataTransferMediumDetails(UpdateMySqlDataTransferMediumDetails dataTransferMediumDetails) {
            this.dataTransferMediumDetails = dataTransferMediumDetails;
            this.__explicitlySet__.add("dataTransferMediumDetails");
            return this;
        }

        public Builder initialLoadSettings(UpdateMySqlInitialLoadSettings initialLoadSettings) {
            this.initialLoadSettings = initialLoadSettings;
            this.__explicitlySet__.add("initialLoadSettings");
            return this;
        }

        public Builder advisorSettings(UpdateMySqlAdvisorSettings advisorSettings) {
            this.advisorSettings = advisorSettings;
            this.__explicitlySet__.add("advisorSettings");
            return this;
        }

        public Builder hubDetails(UpdateGoldenGateHubDetails hubDetails) {
            this.hubDetails = hubDetails;
            this.__explicitlySet__.add("hubDetails");
            return this;
        }

        public Builder ggsDetails(UpdateMySqlGgsDeploymentDetails ggsDetails) {
            this.ggsDetails = ggsDetails;
            this.__explicitlySet__.add("ggsDetails");
            return this;
        }

        public UpdateMySqlMigrationDetails build() {
            UpdateMySqlMigrationDetails model = new UpdateMySqlMigrationDetails(this.description, this.type, this.displayName, this.sourceDatabaseConnectionId, this.targetDatabaseConnectionId, this.freeformTags, this.definedTags, this.dataTransferMediumDetails, this.initialLoadSettings, this.advisorSettings, this.hubDetails, this.ggsDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateMySqlMigrationDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseConnectionId")) {
                this.sourceDatabaseConnectionId(model.getSourceDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseConnectionId")) {
                this.targetDatabaseConnectionId(model.getTargetDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("dataTransferMediumDetails")) {
                this.dataTransferMediumDetails(model.getDataTransferMediumDetails());
            }
            if (model.wasPropertyExplicitlySet("initialLoadSettings")) {
                this.initialLoadSettings(model.getInitialLoadSettings());
            }
            if (model.wasPropertyExplicitlySet("advisorSettings")) {
                this.advisorSettings(model.getAdvisorSettings());
            }
            if (model.wasPropertyExplicitlySet("hubDetails")) {
                this.hubDetails(model.getHubDetails());
            }
            if (model.wasPropertyExplicitlySet("ggsDetails")) {
                this.ggsDetails(model.getGgsDetails());
            }
            return this;
        }
    }
}

