/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemigration.model.DatabaseCombination;
import com.oracle.bmc.databasemigration.model.MigrationTypes;
import com.oracle.bmc.databasemigration.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListMigrationParametersRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private MigrationTypes migrationType;
    private DatabaseCombination databaseCombination;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrders sortOrder;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MigrationTypes getMigrationType() {
        return this.migrationType;
    }

    public DatabaseCombination getDatabaseCombination() {
        return this.databaseCombination;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).migrationType(this.migrationType).databaseCombination(this.databaseCombination).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",migrationType=").append(String.valueOf((Object)this.migrationType));
        sb.append(",databaseCombination=").append(String.valueOf((Object)this.databaseCombination));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMigrationParametersRequest)) {
            return false;
        }
        ListMigrationParametersRequest other = (ListMigrationParametersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.migrationType, (Object)other.migrationType) && Objects.equals((Object)this.databaseCombination, (Object)other.databaseCombination) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.migrationType == null ? 43 : this.migrationType.hashCode());
        result = result * 59 + (this.databaseCombination == null ? 43 : this.databaseCombination.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMigrationParametersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private MigrationTypes migrationType = null;
        private DatabaseCombination databaseCombination = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder migrationType(MigrationTypes migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        public Builder databaseCombination(DatabaseCombination databaseCombination) {
            this.databaseCombination = databaseCombination;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMigrationParametersRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.migrationType(o.getMigrationType());
            this.databaseCombination(o.getDatabaseCombination());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMigrationParametersRequest build() {
            ListMigrationParametersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMigrationParametersRequest buildWithoutInvocationCallback() {
            ListMigrationParametersRequest request = new ListMigrationParametersRequest();
            request.opcRequestId = this.opcRequestId;
            request.migrationType = this.migrationType;
            request.databaseCombination = this.databaseCombination;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

