/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class MakeCurrentParameterFileVersionRequest
extends BmcRequest<Void> {
    private String jobId;
    private String parameterFileName;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getJobId() {
        return this.jobId;
    }

    public String getParameterFileName() {
        return this.parameterFileName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).parameterFileName(this.parameterFileName).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",parameterFileName=").append(String.valueOf(this.parameterFileName));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MakeCurrentParameterFileVersionRequest)) {
            return false;
        }
        MakeCurrentParameterFileVersionRequest other = (MakeCurrentParameterFileVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.parameterFileName, other.parameterFileName) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.parameterFileName == null ? 43 : this.parameterFileName.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<MakeCurrentParameterFileVersionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String parameterFileName = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder parameterFileName(String parameterFileName) {
            this.parameterFileName = parameterFileName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MakeCurrentParameterFileVersionRequest o) {
            this.jobId(o.getJobId());
            this.parameterFileName(o.getParameterFileName());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MakeCurrentParameterFileVersionRequest build() {
            MakeCurrentParameterFileVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public MakeCurrentParameterFileVersionRequest buildWithoutInvocationCallback() {
            MakeCurrentParameterFileVersionRequest request = new MakeCurrentParameterFileVersionRequest();
            request.jobId = this.jobId;
            request.parameterFileName = this.parameterFileName;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

