/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.NodeCount;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PoolMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeLastStarted")
    private final Date timeLastStarted;
    @JsonProperty(value="timeLastStopped")
    private final Date timeLastStopped;
    @JsonProperty(value="timeLastUsed")
    private final Date timeLastUsed;
    @JsonProperty(value="timeLastMetricsUpdated")
    private final Date timeLastMetricsUpdated;
    @JsonProperty(value="activeRunsCount")
    private final Long activeRunsCount;
    @JsonProperty(value="activelyUsedNodeCount")
    private final List<NodeCount> activelyUsedNodeCount;

    @Deprecated
    @ConstructorProperties(value={"timeLastStarted", "timeLastStopped", "timeLastUsed", "timeLastMetricsUpdated", "activeRunsCount", "activelyUsedNodeCount"})
    public PoolMetrics(Date timeLastStarted, Date timeLastStopped, Date timeLastUsed, Date timeLastMetricsUpdated, Long activeRunsCount, List<NodeCount> activelyUsedNodeCount) {
        this.timeLastStarted = timeLastStarted;
        this.timeLastStopped = timeLastStopped;
        this.timeLastUsed = timeLastUsed;
        this.timeLastMetricsUpdated = timeLastMetricsUpdated;
        this.activeRunsCount = activeRunsCount;
        this.activelyUsedNodeCount = activelyUsedNodeCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeLastStarted() {
        return this.timeLastStarted;
    }

    public Date getTimeLastStopped() {
        return this.timeLastStopped;
    }

    public Date getTimeLastUsed() {
        return this.timeLastUsed;
    }

    public Date getTimeLastMetricsUpdated() {
        return this.timeLastMetricsUpdated;
    }

    public Long getActiveRunsCount() {
        return this.activeRunsCount;
    }

    public List<NodeCount> getActivelyUsedNodeCount() {
        return this.activelyUsedNodeCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("timeLastStarted=").append(String.valueOf(this.timeLastStarted));
        sb.append(", timeLastStopped=").append(String.valueOf(this.timeLastStopped));
        sb.append(", timeLastUsed=").append(String.valueOf(this.timeLastUsed));
        sb.append(", timeLastMetricsUpdated=").append(String.valueOf(this.timeLastMetricsUpdated));
        sb.append(", activeRunsCount=").append(String.valueOf(this.activeRunsCount));
        sb.append(", activelyUsedNodeCount=").append(String.valueOf(this.activelyUsedNodeCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolMetrics)) {
            return false;
        }
        PoolMetrics other = (PoolMetrics)((Object)o);
        return Objects.equals(this.timeLastStarted, other.timeLastStarted) && Objects.equals(this.timeLastStopped, other.timeLastStopped) && Objects.equals(this.timeLastUsed, other.timeLastUsed) && Objects.equals(this.timeLastMetricsUpdated, other.timeLastMetricsUpdated) && Objects.equals(this.activeRunsCount, other.activeRunsCount) && Objects.equals(this.activelyUsedNodeCount, other.activelyUsedNodeCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeLastStarted == null ? 43 : this.timeLastStarted.hashCode());
        result = result * 59 + (this.timeLastStopped == null ? 43 : this.timeLastStopped.hashCode());
        result = result * 59 + (this.timeLastUsed == null ? 43 : this.timeLastUsed.hashCode());
        result = result * 59 + (this.timeLastMetricsUpdated == null ? 43 : this.timeLastMetricsUpdated.hashCode());
        result = result * 59 + (this.activeRunsCount == null ? 43 : this.activeRunsCount.hashCode());
        result = result * 59 + (this.activelyUsedNodeCount == null ? 43 : this.activelyUsedNodeCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeLastStarted")
        private Date timeLastStarted;
        @JsonProperty(value="timeLastStopped")
        private Date timeLastStopped;
        @JsonProperty(value="timeLastUsed")
        private Date timeLastUsed;
        @JsonProperty(value="timeLastMetricsUpdated")
        private Date timeLastMetricsUpdated;
        @JsonProperty(value="activeRunsCount")
        private Long activeRunsCount;
        @JsonProperty(value="activelyUsedNodeCount")
        private List<NodeCount> activelyUsedNodeCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeLastStarted(Date timeLastStarted) {
            this.timeLastStarted = timeLastStarted;
            this.__explicitlySet__.add("timeLastStarted");
            return this;
        }

        public Builder timeLastStopped(Date timeLastStopped) {
            this.timeLastStopped = timeLastStopped;
            this.__explicitlySet__.add("timeLastStopped");
            return this;
        }

        public Builder timeLastUsed(Date timeLastUsed) {
            this.timeLastUsed = timeLastUsed;
            this.__explicitlySet__.add("timeLastUsed");
            return this;
        }

        public Builder timeLastMetricsUpdated(Date timeLastMetricsUpdated) {
            this.timeLastMetricsUpdated = timeLastMetricsUpdated;
            this.__explicitlySet__.add("timeLastMetricsUpdated");
            return this;
        }

        public Builder activeRunsCount(Long activeRunsCount) {
            this.activeRunsCount = activeRunsCount;
            this.__explicitlySet__.add("activeRunsCount");
            return this;
        }

        public Builder activelyUsedNodeCount(List<NodeCount> activelyUsedNodeCount) {
            this.activelyUsedNodeCount = activelyUsedNodeCount;
            this.__explicitlySet__.add("activelyUsedNodeCount");
            return this;
        }

        public PoolMetrics build() {
            PoolMetrics model = new PoolMetrics(this.timeLastStarted, this.timeLastStopped, this.timeLastUsed, this.timeLastMetricsUpdated, this.activeRunsCount, this.activelyUsedNodeCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PoolMetrics model) {
            if (model.wasPropertyExplicitlySet("timeLastStarted")) {
                this.timeLastStarted(model.getTimeLastStarted());
            }
            if (model.wasPropertyExplicitlySet("timeLastStopped")) {
                this.timeLastStopped(model.getTimeLastStopped());
            }
            if (model.wasPropertyExplicitlySet("timeLastUsed")) {
                this.timeLastUsed(model.getTimeLastUsed());
            }
            if (model.wasPropertyExplicitlySet("timeLastMetricsUpdated")) {
                this.timeLastMetricsUpdated(model.getTimeLastMetricsUpdated());
            }
            if (model.wasPropertyExplicitlySet("activeRunsCount")) {
                this.activeRunsCount(model.getActiveRunsCount());
            }
            if (model.wasPropertyExplicitlySet("activelyUsedNodeCount")) {
                this.activelyUsedNodeCount(model.getActivelyUsedNodeCount());
            }
            return this;
        }
    }
}

