/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.ApplicationLanguage;
import com.oracle.bmc.dataflow.model.ApplicationLogConfig;
import com.oracle.bmc.dataflow.model.ApplicationParameter;
import com.oracle.bmc.dataflow.model.ApplicationType;
import com.oracle.bmc.dataflow.model.RunLifecycleState;
import com.oracle.bmc.dataflow.model.ShapeConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Run
extends ExplicitlySetBmcModel {
    @JsonProperty(value="archiveUri")
    private final String archiveUri;
    @JsonProperty(value="arguments")
    private final List<String> arguments;
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="applicationLogConfig")
    private final ApplicationLogConfig applicationLogConfig;
    @JsonProperty(value="className")
    private final String className;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="configuration")
    private final Map<String, String> configuration;
    @JsonProperty(value="dataReadInBytes")
    private final Long dataReadInBytes;
    @JsonProperty(value="dataWrittenInBytes")
    private final Long dataWrittenInBytes;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="driverShape")
    private final String driverShape;
    @JsonProperty(value="driverShapeConfig")
    private final ShapeConfig driverShapeConfig;
    @JsonProperty(value="execute")
    private final String execute;
    @JsonProperty(value="executorShape")
    private final String executorShape;
    @JsonProperty(value="executorShapeConfig")
    private final ShapeConfig executorShapeConfig;
    @JsonProperty(value="fileUri")
    private final String fileUri;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="language")
    private final ApplicationLanguage language;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="lifecycleState")
    private final RunLifecycleState lifecycleState;
    @JsonProperty(value="logsBucketUri")
    private final String logsBucketUri;
    @JsonProperty(value="metastoreId")
    private final String metastoreId;
    @JsonProperty(value="numExecutors")
    private final Integer numExecutors;
    @JsonProperty(value="opcRequestId")
    private final String opcRequestId;
    @JsonProperty(value="ownerPrincipalId")
    private final String ownerPrincipalId;
    @JsonProperty(value="ownerUserName")
    private final String ownerUserName;
    @JsonProperty(value="parameters")
    private final List<ApplicationParameter> parameters;
    @JsonProperty(value="poolId")
    private final String poolId;
    @JsonProperty(value="privateEndpointDnsZones")
    private final List<String> privateEndpointDnsZones;
    @JsonProperty(value="privateEndpointMaxHostCount")
    private final Integer privateEndpointMaxHostCount;
    @JsonProperty(value="privateEndpointNsgIds")
    private final List<String> privateEndpointNsgIds;
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;
    @JsonProperty(value="privateEndpointSubnetId")
    private final String privateEndpointSubnetId;
    @JsonProperty(value="runDurationInMilliseconds")
    private final Long runDurationInMilliseconds;
    @JsonProperty(value="sparkVersion")
    private final String sparkVersion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="totalOCpu")
    private final Integer totalOCpu;
    @JsonProperty(value="type")
    private final ApplicationType type;
    @JsonProperty(value="warehouseBucketUri")
    private final String warehouseBucketUri;
    @JsonProperty(value="maxDurationInMinutes")
    private final Long maxDurationInMinutes;
    @JsonProperty(value="idleTimeoutInMinutes")
    private final Long idleTimeoutInMinutes;

    @Deprecated
    @ConstructorProperties(value={"archiveUri", "arguments", "applicationId", "applicationLogConfig", "className", "compartmentId", "configuration", "dataReadInBytes", "dataWrittenInBytes", "definedTags", "displayName", "driverShape", "driverShapeConfig", "execute", "executorShape", "executorShapeConfig", "fileUri", "freeformTags", "id", "language", "lifecycleDetails", "lifecycleState", "logsBucketUri", "metastoreId", "numExecutors", "opcRequestId", "ownerPrincipalId", "ownerUserName", "parameters", "poolId", "privateEndpointDnsZones", "privateEndpointMaxHostCount", "privateEndpointNsgIds", "privateEndpointId", "privateEndpointSubnetId", "runDurationInMilliseconds", "sparkVersion", "timeCreated", "timeUpdated", "totalOCpu", "type", "warehouseBucketUri", "maxDurationInMinutes", "idleTimeoutInMinutes"})
    public Run(String archiveUri, List<String> arguments, String applicationId, ApplicationLogConfig applicationLogConfig, String className, String compartmentId, Map<String, String> configuration, Long dataReadInBytes, Long dataWrittenInBytes, Map<String, Map<String, Object>> definedTags, String displayName, String driverShape, ShapeConfig driverShapeConfig, String execute, String executorShape, ShapeConfig executorShapeConfig, String fileUri, Map<String, String> freeformTags, String id, ApplicationLanguage language, String lifecycleDetails, RunLifecycleState lifecycleState, String logsBucketUri, String metastoreId, Integer numExecutors, String opcRequestId, String ownerPrincipalId, String ownerUserName, List<ApplicationParameter> parameters, String poolId, List<String> privateEndpointDnsZones, Integer privateEndpointMaxHostCount, List<String> privateEndpointNsgIds, String privateEndpointId, String privateEndpointSubnetId, Long runDurationInMilliseconds, String sparkVersion, Date timeCreated, Date timeUpdated, Integer totalOCpu, ApplicationType type, String warehouseBucketUri, Long maxDurationInMinutes, Long idleTimeoutInMinutes) {
        this.archiveUri = archiveUri;
        this.arguments = arguments;
        this.applicationId = applicationId;
        this.applicationLogConfig = applicationLogConfig;
        this.className = className;
        this.compartmentId = compartmentId;
        this.configuration = configuration;
        this.dataReadInBytes = dataReadInBytes;
        this.dataWrittenInBytes = dataWrittenInBytes;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.driverShape = driverShape;
        this.driverShapeConfig = driverShapeConfig;
        this.execute = execute;
        this.executorShape = executorShape;
        this.executorShapeConfig = executorShapeConfig;
        this.fileUri = fileUri;
        this.freeformTags = freeformTags;
        this.id = id;
        this.language = language;
        this.lifecycleDetails = lifecycleDetails;
        this.lifecycleState = lifecycleState;
        this.logsBucketUri = logsBucketUri;
        this.metastoreId = metastoreId;
        this.numExecutors = numExecutors;
        this.opcRequestId = opcRequestId;
        this.ownerPrincipalId = ownerPrincipalId;
        this.ownerUserName = ownerUserName;
        this.parameters = parameters;
        this.poolId = poolId;
        this.privateEndpointDnsZones = privateEndpointDnsZones;
        this.privateEndpointMaxHostCount = privateEndpointMaxHostCount;
        this.privateEndpointNsgIds = privateEndpointNsgIds;
        this.privateEndpointId = privateEndpointId;
        this.privateEndpointSubnetId = privateEndpointSubnetId;
        this.runDurationInMilliseconds = runDurationInMilliseconds;
        this.sparkVersion = sparkVersion;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.totalOCpu = totalOCpu;
        this.type = type;
        this.warehouseBucketUri = warehouseBucketUri;
        this.maxDurationInMinutes = maxDurationInMinutes;
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public ApplicationLogConfig getApplicationLogConfig() {
        return this.applicationLogConfig;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Long getDataReadInBytes() {
        return this.dataReadInBytes;
    }

    public Long getDataWrittenInBytes() {
        return this.dataWrittenInBytes;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDriverShape() {
        return this.driverShape;
    }

    public ShapeConfig getDriverShapeConfig() {
        return this.driverShapeConfig;
    }

    public String getExecute() {
        return this.execute;
    }

    public String getExecutorShape() {
        return this.executorShape;
    }

    public ShapeConfig getExecutorShapeConfig() {
        return this.executorShapeConfig;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public ApplicationLanguage getLanguage() {
        return this.language;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public RunLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLogsBucketUri() {
        return this.logsBucketUri;
    }

    public String getMetastoreId() {
        return this.metastoreId;
    }

    public Integer getNumExecutors() {
        return this.numExecutors;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOwnerPrincipalId() {
        return this.ownerPrincipalId;
    }

    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public List<ApplicationParameter> getParameters() {
        return this.parameters;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public List<String> getPrivateEndpointDnsZones() {
        return this.privateEndpointDnsZones;
    }

    public Integer getPrivateEndpointMaxHostCount() {
        return this.privateEndpointMaxHostCount;
    }

    public List<String> getPrivateEndpointNsgIds() {
        return this.privateEndpointNsgIds;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String getPrivateEndpointSubnetId() {
        return this.privateEndpointSubnetId;
    }

    public Long getRunDurationInMilliseconds() {
        return this.runDurationInMilliseconds;
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getTotalOCpu() {
        return this.totalOCpu;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String getWarehouseBucketUri() {
        return this.warehouseBucketUri;
    }

    public Long getMaxDurationInMinutes() {
        return this.maxDurationInMinutes;
    }

    public Long getIdleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Run(");
        sb.append("super=").append(super.toString());
        sb.append("archiveUri=").append(String.valueOf(this.archiveUri));
        sb.append(", arguments=").append(String.valueOf(this.arguments));
        sb.append(", applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", applicationLogConfig=").append(String.valueOf((Object)this.applicationLogConfig));
        sb.append(", className=").append(String.valueOf(this.className));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", configuration=").append(String.valueOf(this.configuration));
        sb.append(", dataReadInBytes=").append(String.valueOf(this.dataReadInBytes));
        sb.append(", dataWrittenInBytes=").append(String.valueOf(this.dataWrittenInBytes));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", driverShape=").append(String.valueOf(this.driverShape));
        sb.append(", driverShapeConfig=").append(String.valueOf((Object)this.driverShapeConfig));
        sb.append(", execute=").append(String.valueOf(this.execute));
        sb.append(", executorShape=").append(String.valueOf(this.executorShape));
        sb.append(", executorShapeConfig=").append(String.valueOf((Object)this.executorShapeConfig));
        sb.append(", fileUri=").append(String.valueOf(this.fileUri));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", language=").append(String.valueOf((Object)this.language));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", logsBucketUri=").append(String.valueOf(this.logsBucketUri));
        sb.append(", metastoreId=").append(String.valueOf(this.metastoreId));
        sb.append(", numExecutors=").append(String.valueOf(this.numExecutors));
        sb.append(", opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(", ownerPrincipalId=").append(String.valueOf(this.ownerPrincipalId));
        sb.append(", ownerUserName=").append(String.valueOf(this.ownerUserName));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", poolId=").append(String.valueOf(this.poolId));
        sb.append(", privateEndpointDnsZones=").append(String.valueOf(this.privateEndpointDnsZones));
        sb.append(", privateEndpointMaxHostCount=").append(String.valueOf(this.privateEndpointMaxHostCount));
        sb.append(", privateEndpointNsgIds=").append(String.valueOf(this.privateEndpointNsgIds));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(", privateEndpointSubnetId=").append(String.valueOf(this.privateEndpointSubnetId));
        sb.append(", runDurationInMilliseconds=").append(String.valueOf(this.runDurationInMilliseconds));
        sb.append(", sparkVersion=").append(String.valueOf(this.sparkVersion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", totalOCpu=").append(String.valueOf(this.totalOCpu));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", warehouseBucketUri=").append(String.valueOf(this.warehouseBucketUri));
        sb.append(", maxDurationInMinutes=").append(String.valueOf(this.maxDurationInMinutes));
        sb.append(", idleTimeoutInMinutes=").append(String.valueOf(this.idleTimeoutInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Run)) {
            return false;
        }
        Run other = (Run)((Object)o);
        return Objects.equals(this.archiveUri, other.archiveUri) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals((Object)this.applicationLogConfig, (Object)other.applicationLogConfig) && Objects.equals(this.className, other.className) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.dataReadInBytes, other.dataReadInBytes) && Objects.equals(this.dataWrittenInBytes, other.dataWrittenInBytes) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.driverShape, other.driverShape) && Objects.equals((Object)this.driverShapeConfig, (Object)other.driverShapeConfig) && Objects.equals(this.execute, other.execute) && Objects.equals(this.executorShape, other.executorShape) && Objects.equals((Object)this.executorShapeConfig, (Object)other.executorShapeConfig) && Objects.equals(this.fileUri, other.fileUri) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.language, (Object)other.language) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.logsBucketUri, other.logsBucketUri) && Objects.equals(this.metastoreId, other.metastoreId) && Objects.equals(this.numExecutors, other.numExecutors) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ownerPrincipalId, other.ownerPrincipalId) && Objects.equals(this.ownerUserName, other.ownerUserName) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.poolId, other.poolId) && Objects.equals(this.privateEndpointDnsZones, other.privateEndpointDnsZones) && Objects.equals(this.privateEndpointMaxHostCount, other.privateEndpointMaxHostCount) && Objects.equals(this.privateEndpointNsgIds, other.privateEndpointNsgIds) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals(this.privateEndpointSubnetId, other.privateEndpointSubnetId) && Objects.equals(this.runDurationInMilliseconds, other.runDurationInMilliseconds) && Objects.equals(this.sparkVersion, other.sparkVersion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.totalOCpu, other.totalOCpu) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.warehouseBucketUri, other.warehouseBucketUri) && Objects.equals(this.maxDurationInMinutes, other.maxDurationInMinutes) && Objects.equals(this.idleTimeoutInMinutes, other.idleTimeoutInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.archiveUri == null ? 43 : this.archiveUri.hashCode());
        result = result * 59 + (this.arguments == null ? 43 : this.arguments.hashCode());
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.applicationLogConfig == null ? 43 : this.applicationLogConfig.hashCode());
        result = result * 59 + (this.className == null ? 43 : this.className.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.configuration == null ? 43 : this.configuration.hashCode());
        result = result * 59 + (this.dataReadInBytes == null ? 43 : this.dataReadInBytes.hashCode());
        result = result * 59 + (this.dataWrittenInBytes == null ? 43 : this.dataWrittenInBytes.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.driverShape == null ? 43 : this.driverShape.hashCode());
        result = result * 59 + (this.driverShapeConfig == null ? 43 : this.driverShapeConfig.hashCode());
        result = result * 59 + (this.execute == null ? 43 : this.execute.hashCode());
        result = result * 59 + (this.executorShape == null ? 43 : this.executorShape.hashCode());
        result = result * 59 + (this.executorShapeConfig == null ? 43 : this.executorShapeConfig.hashCode());
        result = result * 59 + (this.fileUri == null ? 43 : this.fileUri.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.logsBucketUri == null ? 43 : this.logsBucketUri.hashCode());
        result = result * 59 + (this.metastoreId == null ? 43 : this.metastoreId.hashCode());
        result = result * 59 + (this.numExecutors == null ? 43 : this.numExecutors.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ownerPrincipalId == null ? 43 : this.ownerPrincipalId.hashCode());
        result = result * 59 + (this.ownerUserName == null ? 43 : this.ownerUserName.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.poolId == null ? 43 : this.poolId.hashCode());
        result = result * 59 + (this.privateEndpointDnsZones == null ? 43 : this.privateEndpointDnsZones.hashCode());
        result = result * 59 + (this.privateEndpointMaxHostCount == null ? 43 : this.privateEndpointMaxHostCount.hashCode());
        result = result * 59 + (this.privateEndpointNsgIds == null ? 43 : this.privateEndpointNsgIds.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.privateEndpointSubnetId == null ? 43 : this.privateEndpointSubnetId.hashCode());
        result = result * 59 + (this.runDurationInMilliseconds == null ? 43 : this.runDurationInMilliseconds.hashCode());
        result = result * 59 + (this.sparkVersion == null ? 43 : this.sparkVersion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.totalOCpu == null ? 43 : this.totalOCpu.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.warehouseBucketUri == null ? 43 : this.warehouseBucketUri.hashCode());
        result = result * 59 + (this.maxDurationInMinutes == null ? 43 : this.maxDurationInMinutes.hashCode());
        result = result * 59 + (this.idleTimeoutInMinutes == null ? 43 : this.idleTimeoutInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="archiveUri")
        private String archiveUri;
        @JsonProperty(value="arguments")
        private List<String> arguments;
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="applicationLogConfig")
        private ApplicationLogConfig applicationLogConfig;
        @JsonProperty(value="className")
        private String className;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="configuration")
        private Map<String, String> configuration;
        @JsonProperty(value="dataReadInBytes")
        private Long dataReadInBytes;
        @JsonProperty(value="dataWrittenInBytes")
        private Long dataWrittenInBytes;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="driverShape")
        private String driverShape;
        @JsonProperty(value="driverShapeConfig")
        private ShapeConfig driverShapeConfig;
        @JsonProperty(value="execute")
        private String execute;
        @JsonProperty(value="executorShape")
        private String executorShape;
        @JsonProperty(value="executorShapeConfig")
        private ShapeConfig executorShapeConfig;
        @JsonProperty(value="fileUri")
        private String fileUri;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="language")
        private ApplicationLanguage language;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="lifecycleState")
        private RunLifecycleState lifecycleState;
        @JsonProperty(value="logsBucketUri")
        private String logsBucketUri;
        @JsonProperty(value="metastoreId")
        private String metastoreId;
        @JsonProperty(value="numExecutors")
        private Integer numExecutors;
        @JsonProperty(value="opcRequestId")
        private String opcRequestId;
        @JsonProperty(value="ownerPrincipalId")
        private String ownerPrincipalId;
        @JsonProperty(value="ownerUserName")
        private String ownerUserName;
        @JsonProperty(value="parameters")
        private List<ApplicationParameter> parameters;
        @JsonProperty(value="poolId")
        private String poolId;
        @JsonProperty(value="privateEndpointDnsZones")
        private List<String> privateEndpointDnsZones;
        @JsonProperty(value="privateEndpointMaxHostCount")
        private Integer privateEndpointMaxHostCount;
        @JsonProperty(value="privateEndpointNsgIds")
        private List<String> privateEndpointNsgIds;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonProperty(value="privateEndpointSubnetId")
        private String privateEndpointSubnetId;
        @JsonProperty(value="runDurationInMilliseconds")
        private Long runDurationInMilliseconds;
        @JsonProperty(value="sparkVersion")
        private String sparkVersion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="totalOCpu")
        private Integer totalOCpu;
        @JsonProperty(value="type")
        private ApplicationType type;
        @JsonProperty(value="warehouseBucketUri")
        private String warehouseBucketUri;
        @JsonProperty(value="maxDurationInMinutes")
        private Long maxDurationInMinutes;
        @JsonProperty(value="idleTimeoutInMinutes")
        private Long idleTimeoutInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder archiveUri(String archiveUri) {
            this.archiveUri = archiveUri;
            this.__explicitlySet__.add("archiveUri");
            return this;
        }

        public Builder arguments(List<String> arguments) {
            this.arguments = arguments;
            this.__explicitlySet__.add("arguments");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder applicationLogConfig(ApplicationLogConfig applicationLogConfig) {
            this.applicationLogConfig = applicationLogConfig;
            this.__explicitlySet__.add("applicationLogConfig");
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            this.__explicitlySet__.add("className");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder configuration(Map<String, String> configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        public Builder dataReadInBytes(Long dataReadInBytes) {
            this.dataReadInBytes = dataReadInBytes;
            this.__explicitlySet__.add("dataReadInBytes");
            return this;
        }

        public Builder dataWrittenInBytes(Long dataWrittenInBytes) {
            this.dataWrittenInBytes = dataWrittenInBytes;
            this.__explicitlySet__.add("dataWrittenInBytes");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder driverShape(String driverShape) {
            this.driverShape = driverShape;
            this.__explicitlySet__.add("driverShape");
            return this;
        }

        public Builder driverShapeConfig(ShapeConfig driverShapeConfig) {
            this.driverShapeConfig = driverShapeConfig;
            this.__explicitlySet__.add("driverShapeConfig");
            return this;
        }

        public Builder execute(String execute) {
            this.execute = execute;
            this.__explicitlySet__.add("execute");
            return this;
        }

        public Builder executorShape(String executorShape) {
            this.executorShape = executorShape;
            this.__explicitlySet__.add("executorShape");
            return this;
        }

        public Builder executorShapeConfig(ShapeConfig executorShapeConfig) {
            this.executorShapeConfig = executorShapeConfig;
            this.__explicitlySet__.add("executorShapeConfig");
            return this;
        }

        public Builder fileUri(String fileUri) {
            this.fileUri = fileUri;
            this.__explicitlySet__.add("fileUri");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder language(ApplicationLanguage language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder lifecycleState(RunLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder logsBucketUri(String logsBucketUri) {
            this.logsBucketUri = logsBucketUri;
            this.__explicitlySet__.add("logsBucketUri");
            return this;
        }

        public Builder metastoreId(String metastoreId) {
            this.metastoreId = metastoreId;
            this.__explicitlySet__.add("metastoreId");
            return this;
        }

        public Builder numExecutors(Integer numExecutors) {
            this.numExecutors = numExecutors;
            this.__explicitlySet__.add("numExecutors");
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            this.__explicitlySet__.add("opcRequestId");
            return this;
        }

        public Builder ownerPrincipalId(String ownerPrincipalId) {
            this.ownerPrincipalId = ownerPrincipalId;
            this.__explicitlySet__.add("ownerPrincipalId");
            return this;
        }

        public Builder ownerUserName(String ownerUserName) {
            this.ownerUserName = ownerUserName;
            this.__explicitlySet__.add("ownerUserName");
            return this;
        }

        public Builder parameters(List<ApplicationParameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            this.__explicitlySet__.add("poolId");
            return this;
        }

        public Builder privateEndpointDnsZones(List<String> privateEndpointDnsZones) {
            this.privateEndpointDnsZones = privateEndpointDnsZones;
            this.__explicitlySet__.add("privateEndpointDnsZones");
            return this;
        }

        public Builder privateEndpointMaxHostCount(Integer privateEndpointMaxHostCount) {
            this.privateEndpointMaxHostCount = privateEndpointMaxHostCount;
            this.__explicitlySet__.add("privateEndpointMaxHostCount");
            return this;
        }

        public Builder privateEndpointNsgIds(List<String> privateEndpointNsgIds) {
            this.privateEndpointNsgIds = privateEndpointNsgIds;
            this.__explicitlySet__.add("privateEndpointNsgIds");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public Builder privateEndpointSubnetId(String privateEndpointSubnetId) {
            this.privateEndpointSubnetId = privateEndpointSubnetId;
            this.__explicitlySet__.add("privateEndpointSubnetId");
            return this;
        }

        public Builder runDurationInMilliseconds(Long runDurationInMilliseconds) {
            this.runDurationInMilliseconds = runDurationInMilliseconds;
            this.__explicitlySet__.add("runDurationInMilliseconds");
            return this;
        }

        public Builder sparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            this.__explicitlySet__.add("sparkVersion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder totalOCpu(Integer totalOCpu) {
            this.totalOCpu = totalOCpu;
            this.__explicitlySet__.add("totalOCpu");
            return this;
        }

        public Builder type(ApplicationType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder warehouseBucketUri(String warehouseBucketUri) {
            this.warehouseBucketUri = warehouseBucketUri;
            this.__explicitlySet__.add("warehouseBucketUri");
            return this;
        }

        public Builder maxDurationInMinutes(Long maxDurationInMinutes) {
            this.maxDurationInMinutes = maxDurationInMinutes;
            this.__explicitlySet__.add("maxDurationInMinutes");
            return this;
        }

        public Builder idleTimeoutInMinutes(Long idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
            this.__explicitlySet__.add("idleTimeoutInMinutes");
            return this;
        }

        public Run build() {
            Run model = new Run(this.archiveUri, this.arguments, this.applicationId, this.applicationLogConfig, this.className, this.compartmentId, this.configuration, this.dataReadInBytes, this.dataWrittenInBytes, this.definedTags, this.displayName, this.driverShape, this.driverShapeConfig, this.execute, this.executorShape, this.executorShapeConfig, this.fileUri, this.freeformTags, this.id, this.language, this.lifecycleDetails, this.lifecycleState, this.logsBucketUri, this.metastoreId, this.numExecutors, this.opcRequestId, this.ownerPrincipalId, this.ownerUserName, this.parameters, this.poolId, this.privateEndpointDnsZones, this.privateEndpointMaxHostCount, this.privateEndpointNsgIds, this.privateEndpointId, this.privateEndpointSubnetId, this.runDurationInMilliseconds, this.sparkVersion, this.timeCreated, this.timeUpdated, this.totalOCpu, this.type, this.warehouseBucketUri, this.maxDurationInMinutes, this.idleTimeoutInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Run model) {
            if (model.wasPropertyExplicitlySet("archiveUri")) {
                this.archiveUri(model.getArchiveUri());
            }
            if (model.wasPropertyExplicitlySet("arguments")) {
                this.arguments(model.getArguments());
            }
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("applicationLogConfig")) {
                this.applicationLogConfig(model.getApplicationLogConfig());
            }
            if (model.wasPropertyExplicitlySet("className")) {
                this.className(model.getClassName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("configuration")) {
                this.configuration(model.getConfiguration());
            }
            if (model.wasPropertyExplicitlySet("dataReadInBytes")) {
                this.dataReadInBytes(model.getDataReadInBytes());
            }
            if (model.wasPropertyExplicitlySet("dataWrittenInBytes")) {
                this.dataWrittenInBytes(model.getDataWrittenInBytes());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("driverShape")) {
                this.driverShape(model.getDriverShape());
            }
            if (model.wasPropertyExplicitlySet("driverShapeConfig")) {
                this.driverShapeConfig(model.getDriverShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("execute")) {
                this.execute(model.getExecute());
            }
            if (model.wasPropertyExplicitlySet("executorShape")) {
                this.executorShape(model.getExecutorShape());
            }
            if (model.wasPropertyExplicitlySet("executorShapeConfig")) {
                this.executorShapeConfig(model.getExecutorShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("fileUri")) {
                this.fileUri(model.getFileUri());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("logsBucketUri")) {
                this.logsBucketUri(model.getLogsBucketUri());
            }
            if (model.wasPropertyExplicitlySet("metastoreId")) {
                this.metastoreId(model.getMetastoreId());
            }
            if (model.wasPropertyExplicitlySet("numExecutors")) {
                this.numExecutors(model.getNumExecutors());
            }
            if (model.wasPropertyExplicitlySet("opcRequestId")) {
                this.opcRequestId(model.getOpcRequestId());
            }
            if (model.wasPropertyExplicitlySet("ownerPrincipalId")) {
                this.ownerPrincipalId(model.getOwnerPrincipalId());
            }
            if (model.wasPropertyExplicitlySet("ownerUserName")) {
                this.ownerUserName(model.getOwnerUserName());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("poolId")) {
                this.poolId(model.getPoolId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointDnsZones")) {
                this.privateEndpointDnsZones(model.getPrivateEndpointDnsZones());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointMaxHostCount")) {
                this.privateEndpointMaxHostCount(model.getPrivateEndpointMaxHostCount());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointNsgIds")) {
                this.privateEndpointNsgIds(model.getPrivateEndpointNsgIds());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointSubnetId")) {
                this.privateEndpointSubnetId(model.getPrivateEndpointSubnetId());
            }
            if (model.wasPropertyExplicitlySet("runDurationInMilliseconds")) {
                this.runDurationInMilliseconds(model.getRunDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("sparkVersion")) {
                this.sparkVersion(model.getSparkVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("totalOCpu")) {
                this.totalOCpu(model.getTotalOCpu());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("warehouseBucketUri")) {
                this.warehouseBucketUri(model.getWarehouseBucketUri());
            }
            if (model.wasPropertyExplicitlySet("maxDurationInMinutes")) {
                this.maxDurationInMinutes(model.getMaxDurationInMinutes());
            }
            if (model.wasPropertyExplicitlySet("idleTimeoutInMinutes")) {
                this.idleTimeoutInMinutes(model.getIdleTimeoutInMinutes());
            }
            return this;
        }
    }
}

