/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.ApplicationLanguage;
import com.oracle.bmc.dataflow.model.ApplicationType;
import com.oracle.bmc.dataflow.model.RunLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RunSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dataReadInBytes")
    private final Long dataReadInBytes;
    @JsonProperty(value="dataWrittenInBytes")
    private final Long dataWrittenInBytes;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="language")
    private final ApplicationLanguage language;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="lifecycleState")
    private final RunLifecycleState lifecycleState;
    @JsonProperty(value="opcRequestId")
    private final String opcRequestId;
    @JsonProperty(value="ownerPrincipalId")
    private final String ownerPrincipalId;
    @JsonProperty(value="ownerUserName")
    private final String ownerUserName;
    @JsonProperty(value="poolId")
    private final String poolId;
    @JsonProperty(value="runDurationInMilliseconds")
    private final Long runDurationInMilliseconds;
    @JsonProperty(value="totalOCpu")
    private final Integer totalOCpu;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="type")
    private final ApplicationType type;

    @Deprecated
    @ConstructorProperties(value={"applicationId", "compartmentId", "dataReadInBytes", "dataWrittenInBytes", "definedTags", "displayName", "freeformTags", "id", "language", "lifecycleDetails", "lifecycleState", "opcRequestId", "ownerPrincipalId", "ownerUserName", "poolId", "runDurationInMilliseconds", "totalOCpu", "timeCreated", "timeUpdated", "type"})
    public RunSummary(String applicationId, String compartmentId, Long dataReadInBytes, Long dataWrittenInBytes, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, ApplicationLanguage language, String lifecycleDetails, RunLifecycleState lifecycleState, String opcRequestId, String ownerPrincipalId, String ownerUserName, String poolId, Long runDurationInMilliseconds, Integer totalOCpu, Date timeCreated, Date timeUpdated, ApplicationType type) {
        this.applicationId = applicationId;
        this.compartmentId = compartmentId;
        this.dataReadInBytes = dataReadInBytes;
        this.dataWrittenInBytes = dataWrittenInBytes;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.language = language;
        this.lifecycleDetails = lifecycleDetails;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
        this.ownerPrincipalId = ownerPrincipalId;
        this.ownerUserName = ownerUserName;
        this.poolId = poolId;
        this.runDurationInMilliseconds = runDurationInMilliseconds;
        this.totalOCpu = totalOCpu;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Long getDataReadInBytes() {
        return this.dataReadInBytes;
    }

    public Long getDataWrittenInBytes() {
        return this.dataWrittenInBytes;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public ApplicationLanguage getLanguage() {
        return this.language;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public RunLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOwnerPrincipalId() {
        return this.ownerPrincipalId;
    }

    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public Long getRunDurationInMilliseconds() {
        return this.runDurationInMilliseconds;
    }

    public Integer getTotalOCpu() {
        return this.totalOCpu;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RunSummary(");
        sb.append("super=").append(super.toString());
        sb.append("applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dataReadInBytes=").append(String.valueOf(this.dataReadInBytes));
        sb.append(", dataWrittenInBytes=").append(String.valueOf(this.dataWrittenInBytes));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", language=").append(String.valueOf((Object)this.language));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(", ownerPrincipalId=").append(String.valueOf(this.ownerPrincipalId));
        sb.append(", ownerUserName=").append(String.valueOf(this.ownerUserName));
        sb.append(", poolId=").append(String.valueOf(this.poolId));
        sb.append(", runDurationInMilliseconds=").append(String.valueOf(this.runDurationInMilliseconds));
        sb.append(", totalOCpu=").append(String.valueOf(this.totalOCpu));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunSummary)) {
            return false;
        }
        RunSummary other = (RunSummary)((Object)o);
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dataReadInBytes, other.dataReadInBytes) && Objects.equals(this.dataWrittenInBytes, other.dataWrittenInBytes) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.language, (Object)other.language) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ownerPrincipalId, other.ownerPrincipalId) && Objects.equals(this.ownerUserName, other.ownerUserName) && Objects.equals(this.poolId, other.poolId) && Objects.equals(this.runDurationInMilliseconds, other.runDurationInMilliseconds) && Objects.equals(this.totalOCpu, other.totalOCpu) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dataReadInBytes == null ? 43 : this.dataReadInBytes.hashCode());
        result = result * 59 + (this.dataWrittenInBytes == null ? 43 : this.dataWrittenInBytes.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ownerPrincipalId == null ? 43 : this.ownerPrincipalId.hashCode());
        result = result * 59 + (this.ownerUserName == null ? 43 : this.ownerUserName.hashCode());
        result = result * 59 + (this.poolId == null ? 43 : this.poolId.hashCode());
        result = result * 59 + (this.runDurationInMilliseconds == null ? 43 : this.runDurationInMilliseconds.hashCode());
        result = result * 59 + (this.totalOCpu == null ? 43 : this.totalOCpu.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dataReadInBytes")
        private Long dataReadInBytes;
        @JsonProperty(value="dataWrittenInBytes")
        private Long dataWrittenInBytes;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="language")
        private ApplicationLanguage language;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="lifecycleState")
        private RunLifecycleState lifecycleState;
        @JsonProperty(value="opcRequestId")
        private String opcRequestId;
        @JsonProperty(value="ownerPrincipalId")
        private String ownerPrincipalId;
        @JsonProperty(value="ownerUserName")
        private String ownerUserName;
        @JsonProperty(value="poolId")
        private String poolId;
        @JsonProperty(value="runDurationInMilliseconds")
        private Long runDurationInMilliseconds;
        @JsonProperty(value="totalOCpu")
        private Integer totalOCpu;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="type")
        private ApplicationType type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dataReadInBytes(Long dataReadInBytes) {
            this.dataReadInBytes = dataReadInBytes;
            this.__explicitlySet__.add("dataReadInBytes");
            return this;
        }

        public Builder dataWrittenInBytes(Long dataWrittenInBytes) {
            this.dataWrittenInBytes = dataWrittenInBytes;
            this.__explicitlySet__.add("dataWrittenInBytes");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder language(ApplicationLanguage language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder lifecycleState(RunLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            this.__explicitlySet__.add("opcRequestId");
            return this;
        }

        public Builder ownerPrincipalId(String ownerPrincipalId) {
            this.ownerPrincipalId = ownerPrincipalId;
            this.__explicitlySet__.add("ownerPrincipalId");
            return this;
        }

        public Builder ownerUserName(String ownerUserName) {
            this.ownerUserName = ownerUserName;
            this.__explicitlySet__.add("ownerUserName");
            return this;
        }

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            this.__explicitlySet__.add("poolId");
            return this;
        }

        public Builder runDurationInMilliseconds(Long runDurationInMilliseconds) {
            this.runDurationInMilliseconds = runDurationInMilliseconds;
            this.__explicitlySet__.add("runDurationInMilliseconds");
            return this;
        }

        public Builder totalOCpu(Integer totalOCpu) {
            this.totalOCpu = totalOCpu;
            this.__explicitlySet__.add("totalOCpu");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder type(ApplicationType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public RunSummary build() {
            RunSummary model = new RunSummary(this.applicationId, this.compartmentId, this.dataReadInBytes, this.dataWrittenInBytes, this.definedTags, this.displayName, this.freeformTags, this.id, this.language, this.lifecycleDetails, this.lifecycleState, this.opcRequestId, this.ownerPrincipalId, this.ownerUserName, this.poolId, this.runDurationInMilliseconds, this.totalOCpu, this.timeCreated, this.timeUpdated, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RunSummary model) {
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dataReadInBytes")) {
                this.dataReadInBytes(model.getDataReadInBytes());
            }
            if (model.wasPropertyExplicitlySet("dataWrittenInBytes")) {
                this.dataWrittenInBytes(model.getDataWrittenInBytes());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("opcRequestId")) {
                this.opcRequestId(model.getOpcRequestId());
            }
            if (model.wasPropertyExplicitlySet("ownerPrincipalId")) {
                this.ownerPrincipalId(model.getOwnerPrincipalId());
            }
            if (model.wasPropertyExplicitlySet("ownerUserName")) {
                this.ownerUserName(model.getOwnerUserName());
            }
            if (model.wasPropertyExplicitlySet("poolId")) {
                this.poolId(model.getPoolId());
            }
            if (model.wasPropertyExplicitlySet("runDurationInMilliseconds")) {
                this.runDurationInMilliseconds(model.getRunDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("totalOCpu")) {
                this.totalOCpu(model.getTotalOCpu());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }
}

