/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.ShapeConfig;
import com.oracle.bmc.dataflow.model.SqlEndpointLifecycleState;
import com.oracle.bmc.dataflow.model.SqlEndpointNetworkConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="jdbcEndpointUrl")
    private final String jdbcEndpointUrl;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final SqlEndpointLifecycleState lifecycleState;
    @JsonProperty(value="stateMessage")
    private final String stateMessage;
    @JsonProperty(value="sqlEndpointVersion")
    private final String sqlEndpointVersion;
    @JsonProperty(value="driverShape")
    private final String driverShape;
    @JsonProperty(value="driverShapeConfig")
    private final ShapeConfig driverShapeConfig;
    @JsonProperty(value="executorShape")
    private final String executorShape;
    @JsonProperty(value="executorShapeConfig")
    private final ShapeConfig executorShapeConfig;
    @JsonProperty(value="minExecutorCount")
    private final Integer minExecutorCount;
    @JsonProperty(value="maxExecutorCount")
    private final Integer maxExecutorCount;
    @JsonProperty(value="metastoreId")
    private final String metastoreId;
    @JsonProperty(value="lakeId")
    private final String lakeId;
    @JsonProperty(value="warehouseBucketUri")
    private final String warehouseBucketUri;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="lastAcceptedRequestToken")
    private final String lastAcceptedRequestToken;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="sparkAdvancedConfigurations")
    private final Map<String, String> sparkAdvancedConfigurations;
    @JsonProperty(value="bannerMessage")
    private final String bannerMessage;
    @JsonProperty(value="networkConfiguration")
    private final SqlEndpointNetworkConfiguration networkConfiguration;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "jdbcEndpointUrl", "timeCreated", "timeUpdated", "lifecycleState", "stateMessage", "sqlEndpointVersion", "driverShape", "driverShapeConfig", "executorShape", "executorShapeConfig", "minExecutorCount", "maxExecutorCount", "metastoreId", "lakeId", "warehouseBucketUri", "description", "lastAcceptedRequestToken", "freeformTags", "definedTags", "systemTags", "sparkAdvancedConfigurations", "bannerMessage", "networkConfiguration"})
    public SqlEndpoint(String id, String displayName, String compartmentId, String jdbcEndpointUrl, Date timeCreated, Date timeUpdated, SqlEndpointLifecycleState lifecycleState, String stateMessage, String sqlEndpointVersion, String driverShape, ShapeConfig driverShapeConfig, String executorShape, ShapeConfig executorShapeConfig, Integer minExecutorCount, Integer maxExecutorCount, String metastoreId, String lakeId, String warehouseBucketUri, String description, String lastAcceptedRequestToken, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Map<String, String> sparkAdvancedConfigurations, String bannerMessage, SqlEndpointNetworkConfiguration networkConfiguration) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.jdbcEndpointUrl = jdbcEndpointUrl;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.stateMessage = stateMessage;
        this.sqlEndpointVersion = sqlEndpointVersion;
        this.driverShape = driverShape;
        this.driverShapeConfig = driverShapeConfig;
        this.executorShape = executorShape;
        this.executorShapeConfig = executorShapeConfig;
        this.minExecutorCount = minExecutorCount;
        this.maxExecutorCount = maxExecutorCount;
        this.metastoreId = metastoreId;
        this.lakeId = lakeId;
        this.warehouseBucketUri = warehouseBucketUri;
        this.description = description;
        this.lastAcceptedRequestToken = lastAcceptedRequestToken;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.sparkAdvancedConfigurations = sparkAdvancedConfigurations;
        this.bannerMessage = bannerMessage;
        this.networkConfiguration = networkConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getJdbcEndpointUrl() {
        return this.jdbcEndpointUrl;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public SqlEndpointLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public String getSqlEndpointVersion() {
        return this.sqlEndpointVersion;
    }

    public String getDriverShape() {
        return this.driverShape;
    }

    public ShapeConfig getDriverShapeConfig() {
        return this.driverShapeConfig;
    }

    public String getExecutorShape() {
        return this.executorShape;
    }

    public ShapeConfig getExecutorShapeConfig() {
        return this.executorShapeConfig;
    }

    public Integer getMinExecutorCount() {
        return this.minExecutorCount;
    }

    public Integer getMaxExecutorCount() {
        return this.maxExecutorCount;
    }

    public String getMetastoreId() {
        return this.metastoreId;
    }

    public String getLakeId() {
        return this.lakeId;
    }

    public String getWarehouseBucketUri() {
        return this.warehouseBucketUri;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLastAcceptedRequestToken() {
        return this.lastAcceptedRequestToken;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Map<String, String> getSparkAdvancedConfigurations() {
        return this.sparkAdvancedConfigurations;
    }

    public String getBannerMessage() {
        return this.bannerMessage;
    }

    public SqlEndpointNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", jdbcEndpointUrl=").append(String.valueOf(this.jdbcEndpointUrl));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", stateMessage=").append(String.valueOf(this.stateMessage));
        sb.append(", sqlEndpointVersion=").append(String.valueOf(this.sqlEndpointVersion));
        sb.append(", driverShape=").append(String.valueOf(this.driverShape));
        sb.append(", driverShapeConfig=").append(String.valueOf((Object)this.driverShapeConfig));
        sb.append(", executorShape=").append(String.valueOf(this.executorShape));
        sb.append(", executorShapeConfig=").append(String.valueOf((Object)this.executorShapeConfig));
        sb.append(", minExecutorCount=").append(String.valueOf(this.minExecutorCount));
        sb.append(", maxExecutorCount=").append(String.valueOf(this.maxExecutorCount));
        sb.append(", metastoreId=").append(String.valueOf(this.metastoreId));
        sb.append(", lakeId=").append(String.valueOf(this.lakeId));
        sb.append(", warehouseBucketUri=").append(String.valueOf(this.warehouseBucketUri));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", lastAcceptedRequestToken=").append(String.valueOf(this.lastAcceptedRequestToken));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", sparkAdvancedConfigurations=").append(String.valueOf(this.sparkAdvancedConfigurations));
        sb.append(", bannerMessage=").append(String.valueOf(this.bannerMessage));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlEndpoint)) {
            return false;
        }
        SqlEndpoint other = (SqlEndpoint)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.jdbcEndpointUrl, other.jdbcEndpointUrl) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.stateMessage, other.stateMessage) && Objects.equals(this.sqlEndpointVersion, other.sqlEndpointVersion) && Objects.equals(this.driverShape, other.driverShape) && Objects.equals((Object)this.driverShapeConfig, (Object)other.driverShapeConfig) && Objects.equals(this.executorShape, other.executorShape) && Objects.equals((Object)this.executorShapeConfig, (Object)other.executorShapeConfig) && Objects.equals(this.minExecutorCount, other.minExecutorCount) && Objects.equals(this.maxExecutorCount, other.maxExecutorCount) && Objects.equals(this.metastoreId, other.metastoreId) && Objects.equals(this.lakeId, other.lakeId) && Objects.equals(this.warehouseBucketUri, other.warehouseBucketUri) && Objects.equals(this.description, other.description) && Objects.equals(this.lastAcceptedRequestToken, other.lastAcceptedRequestToken) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.sparkAdvancedConfigurations, other.sparkAdvancedConfigurations) && Objects.equals(this.bannerMessage, other.bannerMessage) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.jdbcEndpointUrl == null ? 43 : this.jdbcEndpointUrl.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.stateMessage == null ? 43 : this.stateMessage.hashCode());
        result = result * 59 + (this.sqlEndpointVersion == null ? 43 : this.sqlEndpointVersion.hashCode());
        result = result * 59 + (this.driverShape == null ? 43 : this.driverShape.hashCode());
        result = result * 59 + (this.driverShapeConfig == null ? 43 : this.driverShapeConfig.hashCode());
        result = result * 59 + (this.executorShape == null ? 43 : this.executorShape.hashCode());
        result = result * 59 + (this.executorShapeConfig == null ? 43 : this.executorShapeConfig.hashCode());
        result = result * 59 + (this.minExecutorCount == null ? 43 : this.minExecutorCount.hashCode());
        result = result * 59 + (this.maxExecutorCount == null ? 43 : this.maxExecutorCount.hashCode());
        result = result * 59 + (this.metastoreId == null ? 43 : this.metastoreId.hashCode());
        result = result * 59 + (this.lakeId == null ? 43 : this.lakeId.hashCode());
        result = result * 59 + (this.warehouseBucketUri == null ? 43 : this.warehouseBucketUri.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.lastAcceptedRequestToken == null ? 43 : this.lastAcceptedRequestToken.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.sparkAdvancedConfigurations == null ? 43 : this.sparkAdvancedConfigurations.hashCode());
        result = result * 59 + (this.bannerMessage == null ? 43 : this.bannerMessage.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="jdbcEndpointUrl")
        private String jdbcEndpointUrl;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private SqlEndpointLifecycleState lifecycleState;
        @JsonProperty(value="stateMessage")
        private String stateMessage;
        @JsonProperty(value="sqlEndpointVersion")
        private String sqlEndpointVersion;
        @JsonProperty(value="driverShape")
        private String driverShape;
        @JsonProperty(value="driverShapeConfig")
        private ShapeConfig driverShapeConfig;
        @JsonProperty(value="executorShape")
        private String executorShape;
        @JsonProperty(value="executorShapeConfig")
        private ShapeConfig executorShapeConfig;
        @JsonProperty(value="minExecutorCount")
        private Integer minExecutorCount;
        @JsonProperty(value="maxExecutorCount")
        private Integer maxExecutorCount;
        @JsonProperty(value="metastoreId")
        private String metastoreId;
        @JsonProperty(value="lakeId")
        private String lakeId;
        @JsonProperty(value="warehouseBucketUri")
        private String warehouseBucketUri;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="lastAcceptedRequestToken")
        private String lastAcceptedRequestToken;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="sparkAdvancedConfigurations")
        private Map<String, String> sparkAdvancedConfigurations;
        @JsonProperty(value="bannerMessage")
        private String bannerMessage;
        @JsonProperty(value="networkConfiguration")
        private SqlEndpointNetworkConfiguration networkConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder jdbcEndpointUrl(String jdbcEndpointUrl) {
            this.jdbcEndpointUrl = jdbcEndpointUrl;
            this.__explicitlySet__.add("jdbcEndpointUrl");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(SqlEndpointLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            this.__explicitlySet__.add("stateMessage");
            return this;
        }

        public Builder sqlEndpointVersion(String sqlEndpointVersion) {
            this.sqlEndpointVersion = sqlEndpointVersion;
            this.__explicitlySet__.add("sqlEndpointVersion");
            return this;
        }

        public Builder driverShape(String driverShape) {
            this.driverShape = driverShape;
            this.__explicitlySet__.add("driverShape");
            return this;
        }

        public Builder driverShapeConfig(ShapeConfig driverShapeConfig) {
            this.driverShapeConfig = driverShapeConfig;
            this.__explicitlySet__.add("driverShapeConfig");
            return this;
        }

        public Builder executorShape(String executorShape) {
            this.executorShape = executorShape;
            this.__explicitlySet__.add("executorShape");
            return this;
        }

        public Builder executorShapeConfig(ShapeConfig executorShapeConfig) {
            this.executorShapeConfig = executorShapeConfig;
            this.__explicitlySet__.add("executorShapeConfig");
            return this;
        }

        public Builder minExecutorCount(Integer minExecutorCount) {
            this.minExecutorCount = minExecutorCount;
            this.__explicitlySet__.add("minExecutorCount");
            return this;
        }

        public Builder maxExecutorCount(Integer maxExecutorCount) {
            this.maxExecutorCount = maxExecutorCount;
            this.__explicitlySet__.add("maxExecutorCount");
            return this;
        }

        public Builder metastoreId(String metastoreId) {
            this.metastoreId = metastoreId;
            this.__explicitlySet__.add("metastoreId");
            return this;
        }

        public Builder lakeId(String lakeId) {
            this.lakeId = lakeId;
            this.__explicitlySet__.add("lakeId");
            return this;
        }

        public Builder warehouseBucketUri(String warehouseBucketUri) {
            this.warehouseBucketUri = warehouseBucketUri;
            this.__explicitlySet__.add("warehouseBucketUri");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder lastAcceptedRequestToken(String lastAcceptedRequestToken) {
            this.lastAcceptedRequestToken = lastAcceptedRequestToken;
            this.__explicitlySet__.add("lastAcceptedRequestToken");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder sparkAdvancedConfigurations(Map<String, String> sparkAdvancedConfigurations) {
            this.sparkAdvancedConfigurations = sparkAdvancedConfigurations;
            this.__explicitlySet__.add("sparkAdvancedConfigurations");
            return this;
        }

        public Builder bannerMessage(String bannerMessage) {
            this.bannerMessage = bannerMessage;
            this.__explicitlySet__.add("bannerMessage");
            return this;
        }

        public Builder networkConfiguration(SqlEndpointNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public SqlEndpoint build() {
            SqlEndpoint model = new SqlEndpoint(this.id, this.displayName, this.compartmentId, this.jdbcEndpointUrl, this.timeCreated, this.timeUpdated, this.lifecycleState, this.stateMessage, this.sqlEndpointVersion, this.driverShape, this.driverShapeConfig, this.executorShape, this.executorShapeConfig, this.minExecutorCount, this.maxExecutorCount, this.metastoreId, this.lakeId, this.warehouseBucketUri, this.description, this.lastAcceptedRequestToken, this.freeformTags, this.definedTags, this.systemTags, this.sparkAdvancedConfigurations, this.bannerMessage, this.networkConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlEndpoint model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("jdbcEndpointUrl")) {
                this.jdbcEndpointUrl(model.getJdbcEndpointUrl());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("stateMessage")) {
                this.stateMessage(model.getStateMessage());
            }
            if (model.wasPropertyExplicitlySet("sqlEndpointVersion")) {
                this.sqlEndpointVersion(model.getSqlEndpointVersion());
            }
            if (model.wasPropertyExplicitlySet("driverShape")) {
                this.driverShape(model.getDriverShape());
            }
            if (model.wasPropertyExplicitlySet("driverShapeConfig")) {
                this.driverShapeConfig(model.getDriverShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("executorShape")) {
                this.executorShape(model.getExecutorShape());
            }
            if (model.wasPropertyExplicitlySet("executorShapeConfig")) {
                this.executorShapeConfig(model.getExecutorShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("minExecutorCount")) {
                this.minExecutorCount(model.getMinExecutorCount());
            }
            if (model.wasPropertyExplicitlySet("maxExecutorCount")) {
                this.maxExecutorCount(model.getMaxExecutorCount());
            }
            if (model.wasPropertyExplicitlySet("metastoreId")) {
                this.metastoreId(model.getMetastoreId());
            }
            if (model.wasPropertyExplicitlySet("lakeId")) {
                this.lakeId(model.getLakeId());
            }
            if (model.wasPropertyExplicitlySet("warehouseBucketUri")) {
                this.warehouseBucketUri(model.getWarehouseBucketUri());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("lastAcceptedRequestToken")) {
                this.lastAcceptedRequestToken(model.getLastAcceptedRequestToken());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("sparkAdvancedConfigurations")) {
                this.sparkAdvancedConfigurations(model.getSparkAdvancedConfigurations());
            }
            if (model.wasPropertyExplicitlySet("bannerMessage")) {
                this.bannerMessage(model.getBannerMessage());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            return this;
        }
    }
}

