/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.SecureAccessControlRule;
import com.oracle.bmc.dataflow.model.SqlEndpointNetworkConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="networkType")
@JsonFilter(value="explicitlySetFilter")
public final class SqlEndpointSecureAccessConfig
extends SqlEndpointNetworkConfiguration {
    @JsonProperty(value="accessControlRules")
    private final List<SecureAccessControlRule> accessControlRules;
    @JsonProperty(value="publicEndpointIp")
    private final String publicEndpointIp;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SqlEndpointSecureAccessConfig(List<SecureAccessControlRule> accessControlRules, String publicEndpointIp) {
        this.accessControlRules = accessControlRules;
        this.publicEndpointIp = publicEndpointIp;
    }

    public List<SecureAccessControlRule> getAccessControlRules() {
        return this.accessControlRules;
    }

    public String getPublicEndpointIp() {
        return this.publicEndpointIp;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlEndpointSecureAccessConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", accessControlRules=").append(String.valueOf(this.accessControlRules));
        sb.append(", publicEndpointIp=").append(String.valueOf(this.publicEndpointIp));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlEndpointSecureAccessConfig)) {
            return false;
        }
        SqlEndpointSecureAccessConfig other = (SqlEndpointSecureAccessConfig)((Object)o);
        return Objects.equals(this.accessControlRules, other.accessControlRules) && Objects.equals(this.publicEndpointIp, other.publicEndpointIp) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessControlRules == null ? 43 : this.accessControlRules.hashCode());
        result = result * 59 + (this.publicEndpointIp == null ? 43 : this.publicEndpointIp.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="accessControlRules")
        private List<SecureAccessControlRule> accessControlRules;
        @JsonProperty(value="publicEndpointIp")
        private String publicEndpointIp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder accessControlRules(List<SecureAccessControlRule> accessControlRules) {
            this.accessControlRules = accessControlRules;
            this.__explicitlySet__.add("accessControlRules");
            return this;
        }

        public Builder publicEndpointIp(String publicEndpointIp) {
            this.publicEndpointIp = publicEndpointIp;
            this.__explicitlySet__.add("publicEndpointIp");
            return this;
        }

        public SqlEndpointSecureAccessConfig build() {
            SqlEndpointSecureAccessConfig model = new SqlEndpointSecureAccessConfig(this.accessControlRules, this.publicEndpointIp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlEndpointSecureAccessConfig model) {
            if (model.wasPropertyExplicitlySet("accessControlRules")) {
                this.accessControlRules(model.getAccessControlRules());
            }
            if (model.wasPropertyExplicitlySet("publicEndpointIp")) {
                this.publicEndpointIp(model.getPublicEndpointIp());
            }
            return this;
        }
    }
}

