/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.ChangeApplicationCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeApplicationCompartmentRequest
extends BmcRequest<ChangeApplicationCompartmentDetails> {
    private String applicationId;
    private ChangeApplicationCompartmentDetails changeApplicationCompartmentDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getApplicationId() {
        return this.applicationId;
    }

    public ChangeApplicationCompartmentDetails getChangeApplicationCompartmentDetails() {
        return this.changeApplicationCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeApplicationCompartmentDetails getBody$() {
        return this.changeApplicationCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().applicationId(this.applicationId).changeApplicationCompartmentDetails(this.changeApplicationCompartmentDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",applicationId=").append(String.valueOf(this.applicationId));
        sb.append(",changeApplicationCompartmentDetails=").append(String.valueOf((Object)this.changeApplicationCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeApplicationCompartmentRequest)) {
            return false;
        }
        ChangeApplicationCompartmentRequest other = (ChangeApplicationCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals((Object)this.changeApplicationCompartmentDetails, (Object)other.changeApplicationCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.changeApplicationCompartmentDetails == null ? 43 : this.changeApplicationCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String applicationId = null;
        private ChangeApplicationCompartmentDetails changeApplicationCompartmentDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder changeApplicationCompartmentDetails(ChangeApplicationCompartmentDetails changeApplicationCompartmentDetails) {
            this.changeApplicationCompartmentDetails = changeApplicationCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeApplicationCompartmentRequest o) {
            this.applicationId(o.getApplicationId());
            this.changeApplicationCompartmentDetails(o.getChangeApplicationCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeApplicationCompartmentRequest build() {
            ChangeApplicationCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeApplicationCompartmentDetails body) {
            this.changeApplicationCompartmentDetails(body);
            return this;
        }

        public ChangeApplicationCompartmentRequest buildWithoutInvocationCallback() {
            ChangeApplicationCompartmentRequest request = new ChangeApplicationCompartmentRequest();
            request.applicationId = this.applicationId;
            request.changeApplicationCompartmentDetails = this.changeApplicationCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

