/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.ChangePoolCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangePoolCompartmentRequest
extends BmcRequest<ChangePoolCompartmentDetails> {
    private String poolId;
    private ChangePoolCompartmentDetails changePoolCompartmentDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getPoolId() {
        return this.poolId;
    }

    public ChangePoolCompartmentDetails getChangePoolCompartmentDetails() {
        return this.changePoolCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangePoolCompartmentDetails getBody$() {
        return this.changePoolCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().poolId(this.poolId).changePoolCompartmentDetails(this.changePoolCompartmentDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",poolId=").append(String.valueOf(this.poolId));
        sb.append(",changePoolCompartmentDetails=").append(String.valueOf((Object)this.changePoolCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangePoolCompartmentRequest)) {
            return false;
        }
        ChangePoolCompartmentRequest other = (ChangePoolCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.poolId, other.poolId) && Objects.equals((Object)this.changePoolCompartmentDetails, (Object)other.changePoolCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.poolId == null ? 43 : this.poolId.hashCode());
        result = result * 59 + (this.changePoolCompartmentDetails == null ? 43 : this.changePoolCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangePoolCompartmentRequest, ChangePoolCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String poolId = null;
        private ChangePoolCompartmentDetails changePoolCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public Builder changePoolCompartmentDetails(ChangePoolCompartmentDetails changePoolCompartmentDetails) {
            this.changePoolCompartmentDetails = changePoolCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangePoolCompartmentRequest o) {
            this.poolId(o.getPoolId());
            this.changePoolCompartmentDetails(o.getChangePoolCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangePoolCompartmentRequest build() {
            ChangePoolCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangePoolCompartmentDetails body) {
            this.changePoolCompartmentDetails(body);
            return this;
        }

        public ChangePoolCompartmentRequest buildWithoutInvocationCallback() {
            ChangePoolCompartmentRequest request = new ChangePoolCompartmentRequest();
            request.poolId = this.poolId;
            request.changePoolCompartmentDetails = this.changePoolCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

