/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStatementRequest
extends BmcRequest<Void> {
    private String runId;
    private String statementId;
    private String opcRequestId;

    public String getRunId() {
        return this.runId;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().runId(this.runId).statementId(this.statementId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",runId=").append(String.valueOf(this.runId));
        sb.append(",statementId=").append(String.valueOf(this.statementId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStatementRequest)) {
            return false;
        }
        GetStatementRequest other = (GetStatementRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.runId, other.runId) && Objects.equals(this.statementId, other.statementId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.statementId == null ? 43 : this.statementId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStatementRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String runId = null;
        private String statementId = null;
        private String opcRequestId = null;

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStatementRequest o) {
            this.runId(o.getRunId());
            this.statementId(o.getStatementId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStatementRequest build() {
            GetStatementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStatementRequest buildWithoutInvocationCallback() {
            GetStatementRequest request = new GetStatementRequest();
            request.runId = this.runId;
            request.statementId = this.statementId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

