/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataflow.model.PrivateEndpointLifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPrivateEndpointsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private PrivateEndpointLifecycleState lifecycleState;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String displayName;
    private String ownerPrincipalId;
    private String displayNameStartsWith;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public PrivateEndpointLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOwnerPrincipalId() {
        return this.ownerPrincipalId;
    }

    public String getDisplayNameStartsWith() {
        return this.displayNameStartsWith;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sortBy(this.sortBy).sortOrder(this.sortOrder).displayName(this.displayName).ownerPrincipalId(this.ownerPrincipalId).displayNameStartsWith(this.displayNameStartsWith);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",ownerPrincipalId=").append(String.valueOf(this.ownerPrincipalId));
        sb.append(",displayNameStartsWith=").append(String.valueOf(this.displayNameStartsWith));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPrivateEndpointsRequest)) {
            return false;
        }
        ListPrivateEndpointsRequest other = (ListPrivateEndpointsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.ownerPrincipalId, other.ownerPrincipalId) && Objects.equals(this.displayNameStartsWith, other.displayNameStartsWith);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.ownerPrincipalId == null ? 43 : this.ownerPrincipalId.hashCode());
        result = result * 59 + (this.displayNameStartsWith == null ? 43 : this.displayNameStartsWith.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPrivateEndpointsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private PrivateEndpointLifecycleState lifecycleState = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String displayName = null;
        private String ownerPrincipalId = null;
        private String displayNameStartsWith = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(PrivateEndpointLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder ownerPrincipalId(String ownerPrincipalId) {
            this.ownerPrincipalId = ownerPrincipalId;
            return this;
        }

        public Builder displayNameStartsWith(String displayNameStartsWith) {
            this.displayNameStartsWith = displayNameStartsWith;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPrivateEndpointsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.displayName(o.getDisplayName());
            this.ownerPrincipalId(o.getOwnerPrincipalId());
            this.displayNameStartsWith(o.getDisplayNameStartsWith());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPrivateEndpointsRequest build() {
            ListPrivateEndpointsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPrivateEndpointsRequest buildWithoutInvocationCallback() {
            ListPrivateEndpointsRequest request = new ListPrivateEndpointsRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.displayName = this.displayName;
            request.ownerPrincipalId = this.ownerPrincipalId;
            request.displayNameStartsWith = this.displayNameStartsWith;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

