/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.UpdateApplicationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateApplicationRequest
extends BmcRequest<UpdateApplicationDetails> {
    private UpdateApplicationDetails updateApplicationDetails;
    private String applicationId;
    private String opcRequestId;
    private String ifMatch;

    public UpdateApplicationDetails getUpdateApplicationDetails() {
        return this.updateApplicationDetails;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateApplicationDetails getBody$() {
        return this.updateApplicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().updateApplicationDetails(this.updateApplicationDetails).applicationId(this.applicationId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",updateApplicationDetails=").append(String.valueOf((Object)this.updateApplicationDetails));
        sb.append(",applicationId=").append(String.valueOf(this.applicationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.updateApplicationDetails, (Object)other.updateApplicationDetails) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.updateApplicationDetails == null ? 43 : this.updateApplicationDetails.hashCode());
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateApplicationRequest, UpdateApplicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private UpdateApplicationDetails updateApplicationDetails = null;
        private String applicationId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder updateApplicationDetails(UpdateApplicationDetails updateApplicationDetails) {
            this.updateApplicationDetails = updateApplicationDetails;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateApplicationRequest o) {
            this.updateApplicationDetails(o.getUpdateApplicationDetails());
            this.applicationId(o.getApplicationId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateApplicationRequest build() {
            UpdateApplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateApplicationDetails body) {
            this.updateApplicationDetails(body);
            return this;
        }

        public UpdateApplicationRequest buildWithoutInvocationCallback() {
            UpdateApplicationRequest request = new UpdateApplicationRequest();
            request.updateApplicationDetails = this.updateApplicationDetails;
            request.applicationId = this.applicationId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

