/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.responses;

import com.oracle.bmc.dataflow.model.PrivateEndpoint;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreatePrivateEndpointResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private String location;
    private PrivateEndpoint privateEndpoint;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public PrivateEndpoint getPrivateEndpoint() {
        return this.privateEndpoint;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "opcWorkRequestId", "location", "privateEndpoint"})
    private CreatePrivateEndpointResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, String opcWorkRequestId, String location, PrivateEndpoint privateEndpoint) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.location = location;
        this.privateEndpoint = privateEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",privateEndpoint=").append(String.valueOf((Object)this.privateEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePrivateEndpointResponse)) {
            return false;
        }
        CreatePrivateEndpointResponse other = (CreatePrivateEndpointResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.location, other.location) && Objects.equals((Object)this.privateEndpoint, (Object)other.privateEndpoint);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.privateEndpoint == null ? 43 : this.privateEndpoint.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreatePrivateEndpointResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String location;
        private PrivateEndpoint privateEndpoint;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder privateEndpoint(PrivateEndpoint privateEndpoint) {
            this.privateEndpoint = privateEndpoint;
            return this;
        }

        public Builder copy(CreatePrivateEndpointResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.location(o.getLocation());
            this.privateEndpoint(o.getPrivateEndpoint());
            return this;
        }

        public CreatePrivateEndpointResponse build() {
            return new CreatePrivateEndpointResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.opcWorkRequestId, this.location, this.privateEndpoint);
        }
    }
}

