/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.responses;

import com.oracle.bmc.dataflow.model.SqlEndpoint;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateSqlEndpointResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcWorkRequestId;
    private String etag;
    private SqlEndpoint sqlEndpoint;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public SqlEndpoint getSqlEndpoint() {
        return this.sqlEndpoint;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcWorkRequestId", "etag", "sqlEndpoint"})
    private CreateSqlEndpointResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcWorkRequestId, String etag, SqlEndpoint sqlEndpoint) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.etag = etag;
        this.sqlEndpoint = sqlEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",sqlEndpoint=").append(String.valueOf((Object)this.sqlEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSqlEndpointResponse)) {
            return false;
        }
        CreateSqlEndpointResponse other = (CreateSqlEndpointResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.sqlEndpoint, (Object)other.sqlEndpoint);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.sqlEndpoint == null ? 43 : this.sqlEndpoint.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateSqlEndpointResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String etag;
        private SqlEndpoint sqlEndpoint;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder sqlEndpoint(SqlEndpoint sqlEndpoint) {
            this.sqlEndpoint = sqlEndpoint;
            return this;
        }

        public Builder copy(CreateSqlEndpointResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.etag(o.getEtag());
            this.sqlEndpoint(o.getSqlEndpoint());
            return this;
        }

        public CreateSqlEndpointResponse build() {
            return new CreateSqlEndpointResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcWorkRequestId, this.etag, this.sqlEndpoint);
        }
    }
}

