/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataflow.DataFlow;
import com.oracle.bmc.dataflow.DataFlowPaginators;
import com.oracle.bmc.dataflow.DataFlowWaiters;
import com.oracle.bmc.dataflow.model.Application;
import com.oracle.bmc.dataflow.model.ApplicationSummary;
import com.oracle.bmc.dataflow.model.Pool;
import com.oracle.bmc.dataflow.model.PoolCollection;
import com.oracle.bmc.dataflow.model.PrivateEndpoint;
import com.oracle.bmc.dataflow.model.PrivateEndpointCollection;
import com.oracle.bmc.dataflow.model.Run;
import com.oracle.bmc.dataflow.model.RunLogSummary;
import com.oracle.bmc.dataflow.model.RunSummary;
import com.oracle.bmc.dataflow.model.SqlEndpoint;
import com.oracle.bmc.dataflow.model.SqlEndpointCollection;
import com.oracle.bmc.dataflow.model.Statement;
import com.oracle.bmc.dataflow.model.StatementCollection;
import com.oracle.bmc.dataflow.model.WorkRequest;
import com.oracle.bmc.dataflow.model.WorkRequestCollection;
import com.oracle.bmc.dataflow.model.WorkRequestErrorCollection;
import com.oracle.bmc.dataflow.model.WorkRequestLogCollection;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePoolCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeSqlEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePoolRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.CreateSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateStatementRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePoolRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteStatementRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPoolRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetStatementRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPoolsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListSqlEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListStatementsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.StartPoolRequest;
import com.oracle.bmc.dataflow.requests.StartSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.StopPoolRequest;
import com.oracle.bmc.dataflow.requests.StopSqlEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePoolRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.requests.UpdateSqlEndpointRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePoolCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeSqlEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePoolResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.CreateSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateStatementResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePoolResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteStatementResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPoolResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetStatementResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPoolsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListSqlEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListStatementsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.StartPoolResponse;
import com.oracle.bmc.dataflow.responses.StartSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.StopPoolResponse;
import com.oracle.bmc.dataflow.responses.StopSqlEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePoolResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.dataflow.responses.UpdateSqlEndpointResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlowClient
extends BaseSyncClient
implements DataFlow {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAFLOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataflow.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataFlowClient.class);
    private final DataFlowWaiters waiters;
    private final DataFlowPaginators paginators;

    DataFlowClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    DataFlowClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataFlow-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataFlowWaiters(executorService, this);
        this.paginators = new DataFlowPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DataFlowClient", (String)"getRunLog"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeApplicationCompartmentResponse changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApplicationCompartmentDetails(), "changeApplicationCompartmentDetails is required");
        return (ChangeApplicationCompartmentResponse)this.clientCall(request, ChangeApplicationCompartmentResponse::builder).logger(LOG, "changeApplicationCompartment").serviceDetails("DataFlow", "ChangeApplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/ChangeApplicationCompartment").method(Method.POST).requestBuilder(ChangeApplicationCompartmentRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeApplicationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePoolCompartmentResponse changePoolCompartment(ChangePoolCompartmentRequest request) {
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePoolCompartmentDetails(), "changePoolCompartmentDetails is required");
        return (ChangePoolCompartmentResponse)this.clientCall(request, ChangePoolCompartmentResponse::builder).logger(LOG, "changePoolCompartment").serviceDetails("DataFlow", "ChangePoolCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/ChangePoolCompartment").method(Method.POST).requestBuilder(ChangePoolCompartmentRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangePoolCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePrivateEndpointCompartmentResponse changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateEndpointCompartmentDetails(), "changePrivateEndpointCompartmentDetails is required");
        return (ChangePrivateEndpointCompartmentResponse)this.clientCall(request, ChangePrivateEndpointCompartmentResponse::builder).logger(LOG, "changePrivateEndpointCompartment").serviceDetails("DataFlow", "ChangePrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/ChangePrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangePrivateEndpointCompartmentRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangePrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeRunCompartmentResponse changeRunCompartment(ChangeRunCompartmentRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRunCompartmentDetails(), "changeRunCompartmentDetails is required");
        return (ChangeRunCompartmentResponse)this.clientCall(request, ChangeRunCompartmentResponse::builder).logger(LOG, "changeRunCompartment").serviceDetails("DataFlow", "ChangeRunCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/ChangeRunCompartment").method(Method.POST).requestBuilder(ChangeRunCompartmentRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRunCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSqlEndpointCompartmentResponse changeSqlEndpointCompartment(ChangeSqlEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSqlEndpointCompartmentDetails(), "changeSqlEndpointCompartmentDetails is required");
        return (ChangeSqlEndpointCompartmentResponse)this.clientCall(request, ChangeSqlEndpointCompartmentResponse::builder).logger(LOG, "changeSqlEndpointCompartment").serviceDetails("DataFlow", "ChangeSqlEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/ChangeSqlEndpointCompartment").method(Method.POST).requestBuilder(ChangeSqlEndpointCompartmentRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSqlEndpointCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeSqlEndpointCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        Objects.requireNonNull(request.getCreateApplicationDetails(), "createApplicationDetails is required");
        return (CreateApplicationResponse)this.clientCall(request, CreateApplicationResponse::builder).logger(LOG, "createApplication").serviceDetails("DataFlow", "CreateApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/CreateApplication").method(Method.POST).requestBuilder(CreateApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Application.class, CreateApplicationResponse.Builder::application).handleResponseHeaderString("etag", CreateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateApplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePoolResponse createPool(CreatePoolRequest request) {
        Objects.requireNonNull(request.getCreatePoolDetails(), "createPoolDetails is required");
        return (CreatePoolResponse)this.clientCall(request, CreatePoolResponse::builder).logger(LOG, "createPool").serviceDetails("DataFlow", "CreatePool", "").method(Method.POST).requestBuilder(CreatePoolRequest::builder).basePath("/20200129").appendPathParam("pools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Pool.class, CreatePoolResponse.Builder::pool).handleResponseHeaderString("etag", CreatePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreatePoolResponse.Builder::location).callSync();
    }

    @Override
    public CreatePrivateEndpointResponse createPrivateEndpoint(CreatePrivateEndpointRequest request) {
        Objects.requireNonNull(request.getCreatePrivateEndpointDetails(), "createPrivateEndpointDetails is required");
        return (CreatePrivateEndpointResponse)this.clientCall(request, CreatePrivateEndpointResponse::builder).logger(LOG, "createPrivateEndpoint").serviceDetails("DataFlow", "CreatePrivateEndpoint", "").method(Method.POST).requestBuilder(CreatePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PrivateEndpoint.class, CreatePrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("etag", CreatePrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreatePrivateEndpointResponse.Builder::location).callSync();
    }

    @Override
    public CreateRunResponse createRun(CreateRunRequest request) {
        Objects.requireNonNull(request.getCreateRunDetails(), "createRunDetails is required");
        return (CreateRunResponse)this.clientCall(request, CreateRunResponse::builder).logger(LOG, "createRun").serviceDetails("DataFlow", "CreateRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/CreateRun").method(Method.POST).requestBuilder(CreateRunRequest::builder).basePath("/20200129").appendPathParam("runs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-parent-rpt-url", request.getOpcParentRptUrl()).hasBody().handleBody(Run.class, CreateRunResponse.Builder::run).handleResponseHeaderString("etag", CreateRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSqlEndpointResponse createSqlEndpoint(CreateSqlEndpointRequest request) {
        Objects.requireNonNull(request.getCreateSqlEndpointDetails(), "createSqlEndpointDetails is required");
        return (CreateSqlEndpointResponse)this.clientCall(request, CreateSqlEndpointResponse::builder).logger(LOG, "createSqlEndpoint").serviceDetails("DataFlow", "CreateSqlEndpoint", "").method(Method.POST).requestBuilder(CreateSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SqlEndpoint.class, CreateSqlEndpointResponse.Builder::sqlEndpoint).handleResponseHeaderString("opc-request-id", CreateSqlEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateSqlEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateSqlEndpointResponse.Builder::etag).callSync();
    }

    @Override
    public CreateStatementResponse createStatement(CreateStatementRequest request) {
        Objects.requireNonNull(request.getCreateStatementDetails(), "createStatementDetails is required");
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (CreateStatementResponse)this.clientCall(request, CreateStatementResponse::builder).logger(LOG, "createStatement").serviceDetails("DataFlow", "CreateStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/CreateStatement").method(Method.POST).requestBuilder(CreateStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Statement.class, CreateStatementResponse.Builder::statement).handleResponseHeaderString("etag", CreateStatementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateStatementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest request) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return (DeleteApplicationResponse)this.clientCall(request, DeleteApplicationResponse::builder).logger(LOG, "deleteApplication").serviceDetails("DataFlow", "DeleteApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/DeleteApplication").method(Method.DELETE).requestBuilder(DeleteApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteApplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePoolResponse deletePool(DeletePoolRequest request) {
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        return (DeletePoolResponse)this.clientCall(request, DeletePoolResponse::builder).logger(LOG, "deletePool").serviceDetails("DataFlow", "DeletePool", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/DeletePool").method(Method.DELETE).requestBuilder(DeletePoolRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePrivateEndpointResponse deletePrivateEndpoint(DeletePrivateEndpointRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (DeletePrivateEndpointResponse)this.clientCall(request, DeletePrivateEndpointResponse::builder).logger(LOG, "deletePrivateEndpoint").serviceDetails("DataFlow", "DeletePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/DeletePrivateEndpoint").method(Method.DELETE).requestBuilder(DeletePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeletePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeletePrivateEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (DeleteRunResponse)this.clientCall(request, DeleteRunResponse::builder).logger(LOG, "deleteRun").serviceDetails("DataFlow", "DeleteRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/DeleteRun").method(Method.DELETE).requestBuilder(DeleteRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSqlEndpointResponse deleteSqlEndpoint(DeleteSqlEndpointRequest request) {
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        return (DeleteSqlEndpointResponse)this.clientCall(request, DeleteSqlEndpointResponse::builder).logger(LOG, "deleteSqlEndpoint").serviceDetails("DataFlow", "DeleteSqlEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/DeleteSqlEndpoint").method(Method.DELETE).requestBuilder(DeleteSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSqlEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteSqlEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteStatementResponse deleteStatement(DeleteStatementRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStatementId(), (String)"statementId must not be blank", (Object[])new Object[0]);
        return (DeleteStatementResponse)this.clientCall(request, DeleteStatementResponse::builder).logger(LOG, "deleteStatement").serviceDetails("DataFlow", "DeleteStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/DeleteStatement").method(Method.DELETE).requestBuilder(DeleteStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendPathParam(request.getStatementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteStatementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest request) {
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return (GetApplicationResponse)this.clientCall(request, GetApplicationResponse::builder).logger(LOG, "getApplication").serviceDetails("DataFlow", "GetApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/GetApplication").method(Method.GET).requestBuilder(GetApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Application.class, GetApplicationResponse.Builder::application).handleResponseHeaderString("etag", GetApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPoolResponse getPool(GetPoolRequest request) {
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        return (GetPoolResponse)this.clientCall(request, GetPoolResponse::builder).logger(LOG, "getPool").serviceDetails("DataFlow", "GetPool", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/GetPool").method(Method.GET).requestBuilder(GetPoolRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Pool.class, GetPoolResponse.Builder::pool).handleResponseHeaderString("etag", GetPoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPoolResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPrivateEndpointResponse getPrivateEndpoint(GetPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetPrivateEndpointResponse)this.clientCall(request, GetPrivateEndpointResponse::builder).logger(LOG, "getPrivateEndpoint").serviceDetails("DataFlow", "GetPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/GetPrivateEndpoint").method(Method.GET).requestBuilder(GetPrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PrivateEndpoint.class, GetPrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("etag", GetPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRunResponse getRun(GetRunRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (GetRunResponse)this.clientCall(request, GetRunResponse::builder).logger(LOG, "getRun").serviceDetails("DataFlow", "GetRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/GetRun").method(Method.GET).requestBuilder(GetRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Run.class, GetRunResponse.Builder::run).handleResponseHeaderString("etag", GetRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRunLogResponse getRunLog(GetRunLogRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return (GetRunLogResponse)this.clientCall(request, GetRunLogResponse::builder).logger(LOG, "getRunLog").serviceDetails("DataFlow", "GetRunLog", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/GetRunLog").method(Method.GET).requestBuilder(GetRunLogRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("logs").appendPathParam(request.getName()).accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetRunLogResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetRunLogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRunLogResponse.Builder::etag).handleResponseHeaderLong("content-length", GetRunLogResponse.Builder::contentLength).handleResponseHeaderString("content-type", GetRunLogResponse.Builder::contentType).handleResponseHeaderString("content-encoding", GetRunLogResponse.Builder::contentEncoding).handleResponseHeadersMap("opc-meta-", GetRunLogResponse.Builder::opcMeta).callSync();
    }

    @Override
    public GetSqlEndpointResponse getSqlEndpoint(GetSqlEndpointRequest request) {
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        return (GetSqlEndpointResponse)this.clientCall(request, GetSqlEndpointResponse::builder).logger(LOG, "getSqlEndpoint").serviceDetails("DataFlow", "GetSqlEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/GetSqlEndpoint").method(Method.GET).requestBuilder(GetSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SqlEndpoint.class, GetSqlEndpointResponse.Builder::sqlEndpoint).handleResponseHeaderString("etag", GetSqlEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSqlEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetStatementResponse getStatement(GetStatementRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStatementId(), (String)"statementId must not be blank", (Object[])new Object[0]);
        return (GetStatementResponse)this.clientCall(request, GetStatementResponse::builder).logger(LOG, "getStatement").serviceDetails("DataFlow", "GetStatement", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Statement/GetStatement").method(Method.GET).requestBuilder(GetStatementRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendPathParam(request.getStatementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Statement.class, GetStatementResponse.Builder::statement).handleResponseHeaderString("etag", GetStatementResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetStatementResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataFlow", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListApplicationsResponse)this.clientCall(request, ListApplicationsResponse::builder).logger(LOG, "listApplications").serviceDetails("DataFlow", "ListApplications", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/ApplicationSummary/ListApplications").method(Method.GET).requestBuilder(ListApplicationsRequest::builder).basePath("/20200129").appendPathParam("applications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).appendQueryParam("sparkVersion", (Object)request.getSparkVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(ApplicationSummary.class, ListApplicationsResponse.Builder::items).handleResponseHeaderString("opc-prev-page", ListApplicationsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListApplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListApplicationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPoolsResponse listPools(ListPoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPoolsResponse)this.clientCall(request, ListPoolsResponse::builder).logger(LOG, "listPools").serviceDetails("DataFlow", "ListPools", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/ListPools").method(Method.GET).requestBuilder(ListPoolsRequest::builder).basePath("/20200129").appendPathParam("pools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PoolCollection.class, ListPoolsResponse.Builder::poolCollection).handleResponseHeaderString("opc-prev-page", ListPoolsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListPoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPoolsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListPrivateEndpointsResponse listPrivateEndpoints(ListPrivateEndpointsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPrivateEndpointsResponse)this.clientCall(request, ListPrivateEndpointsResponse::builder).logger(LOG, "listPrivateEndpoints").serviceDetails("DataFlow", "ListPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/ListPrivateEndpoints").method(Method.GET).requestBuilder(ListPrivateEndpointsRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PrivateEndpointCollection.class, ListPrivateEndpointsResponse.Builder::privateEndpointCollection).handleResponseHeaderString("opc-prev-page", ListPrivateEndpointsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListPrivateEndpointsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPrivateEndpointsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRunLogsResponse listRunLogs(ListRunLogsRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (ListRunLogsResponse)this.clientCall(request, ListRunLogsResponse::builder).logger(LOG, "listRunLogs").serviceDetails("DataFlow", "ListRunLogs", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/RunLogSummary/ListRunLogs").method(Method.GET).requestBuilder(ListRunLogsRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(RunLogSummary.class, ListRunLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListRunLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-prev-page", ListRunLogsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListRunLogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRunsResponse listRuns(ListRunsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRunsResponse)this.clientCall(request, ListRunsResponse::builder).logger(LOG, "listRuns").serviceDetails("DataFlow", "ListRuns", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/RunSummary/ListRuns").method(Method.GET).requestBuilder(ListRunsRequest::builder).basePath("/20200129").appendPathParam("runs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("poolId", (Object)request.getPoolId()).appendQueryParam("ownerPrincipalId", (Object)request.getOwnerPrincipalId()).appendQueryParam("displayNameStartsWith", (Object)request.getDisplayNameStartsWith()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreatedGreaterThan", (Object)request.getTimeCreatedGreaterThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(RunSummary.class, ListRunsResponse.Builder::items).handleResponseHeaderString("opc-prev-page", ListRunsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListRunsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRunsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSqlEndpointsResponse listSqlEndpoints(ListSqlEndpointsRequest request) {
        return (ListSqlEndpointsResponse)this.clientCall(request, ListSqlEndpointsResponse::builder).logger(LOG, "listSqlEndpoints").serviceDetails("DataFlow", "ListSqlEndpoints", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpointCollection/ListSqlEndpoints").method(Method.GET).requestBuilder(ListSqlEndpointsRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("sqlEndpointId", (Object)request.getSqlEndpointId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SqlEndpointCollection.class, ListSqlEndpointsResponse.Builder::sqlEndpointCollection).handleResponseHeaderString("opc-next-page", ListSqlEndpointsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSqlEndpointsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListStatementsResponse listStatements(ListStatementsRequest request) {
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (ListStatementsResponse)this.clientCall(request, ListStatementsResponse::builder).logger(LOG, "listStatements").serviceDetails("DataFlow", "ListStatements", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/StatementCollection/ListStatements").method(Method.GET).requestBuilder(ListStatementsRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).appendPathParam("statements").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(StatementCollection.class, ListStatementsResponse.Builder::statementCollection).handleResponseHeaderString("opc-prev-page", ListStatementsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListStatementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListStatementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataFlow", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestErrorsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataFlow", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestLogsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataFlow", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200129").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartPoolResponse startPool(StartPoolRequest request) {
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        return (StartPoolResponse)this.clientCall(request, StartPoolResponse::builder).logger(LOG, "startPool").serviceDetails("DataFlow", "StartPool", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/StartPool").method(Method.POST).requestBuilder(StartPoolRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartSqlEndpointResponse startSqlEndpoint(StartSqlEndpointRequest request) {
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        return (StartSqlEndpointResponse)this.clientCall(request, StartSqlEndpointResponse::builder).logger(LOG, "startSqlEndpoint").serviceDetails("DataFlow", "StartSqlEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/StartSqlEndpoint").method(Method.POST).requestBuilder(StartSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartSqlEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartSqlEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopPoolResponse stopPool(StopPoolRequest request) {
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        return (StopPoolResponse)this.clientCall(request, StopPoolResponse::builder).logger(LOG, "stopPool").serviceDetails("DataFlow", "StopPool", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/StopPool").method(Method.POST).requestBuilder(StopPoolRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopSqlEndpointResponse stopSqlEndpoint(StopSqlEndpointRequest request) {
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        return (StopSqlEndpointResponse)this.clientCall(request, StopSqlEndpointResponse::builder).logger(LOG, "stopSqlEndpoint").serviceDetails("DataFlow", "StopSqlEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/StopSqlEndpoint").method(Method.POST).requestBuilder(StopSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopSqlEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopSqlEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest request) {
        Objects.requireNonNull(request.getUpdateApplicationDetails(), "updateApplicationDetails is required");
        Validate.notBlank((String)request.getApplicationId(), (String)"applicationId must not be blank", (Object[])new Object[0]);
        return (UpdateApplicationResponse)this.clientCall(request, UpdateApplicationResponse::builder).logger(LOG, "updateApplication").serviceDetails("DataFlow", "UpdateApplication", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Application/UpdateApplication").method(Method.PUT).requestBuilder(UpdateApplicationRequest::builder).basePath("/20200129").appendPathParam("applications").appendPathParam(request.getApplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Application.class, UpdateApplicationResponse.Builder::application).handleResponseHeaderString("etag", UpdateApplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateApplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePoolResponse updatePool(UpdatePoolRequest request) {
        Objects.requireNonNull(request.getUpdatePoolDetails(), "updatePoolDetails is required");
        Validate.notBlank((String)request.getPoolId(), (String)"poolId must not be blank", (Object[])new Object[0]);
        return (UpdatePoolResponse)this.clientCall(request, UpdatePoolResponse::builder).logger(LOG, "updatePool").serviceDetails("DataFlow", "UpdatePool", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Pool/UpdatePool").method(Method.PUT).requestBuilder(UpdatePoolRequest::builder).basePath("/20200129").appendPathParam("pools").appendPathParam(request.getPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdatePrivateEndpointResponse updatePrivateEndpoint(UpdatePrivateEndpointRequest request) {
        Objects.requireNonNull(request.getUpdatePrivateEndpointDetails(), "updatePrivateEndpointDetails is required");
        Validate.notBlank((String)request.getPrivateEndpointId(), (String)"privateEndpointId must not be blank", (Object[])new Object[0]);
        return (UpdatePrivateEndpointResponse)this.clientCall(request, UpdatePrivateEndpointResponse::builder).logger(LOG, "updatePrivateEndpoint").serviceDetails("DataFlow", "UpdatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/PrivateEndpoint/UpdatePrivateEndpoint").method(Method.PUT).requestBuilder(UpdatePrivateEndpointRequest::builder).basePath("/20200129").appendPathParam("privateEndpoints").appendPathParam(request.getPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePrivateEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateRunResponse updateRun(UpdateRunRequest request) {
        Objects.requireNonNull(request.getUpdateRunDetails(), "updateRunDetails is required");
        Validate.notBlank((String)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        return (UpdateRunResponse)this.clientCall(request, UpdateRunResponse::builder).logger(LOG, "updateRun").serviceDetails("DataFlow", "UpdateRun", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/Run/UpdateRun").method(Method.PUT).requestBuilder(UpdateRunRequest::builder).basePath("/20200129").appendPathParam("runs").appendPathParam(request.getRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Run.class, UpdateRunResponse.Builder::run).handleResponseHeaderString("etag", UpdateRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSqlEndpointResponse updateSqlEndpoint(UpdateSqlEndpointRequest request) {
        Objects.requireNonNull(request.getUpdateSqlEndpointDetails(), "updateSqlEndpointDetails is required");
        Validate.notBlank((String)request.getSqlEndpointId(), (String)"sqlEndpointId must not be blank", (Object[])new Object[0]);
        return (UpdateSqlEndpointResponse)this.clientCall(request, UpdateSqlEndpointResponse::builder).logger(LOG, "updateSqlEndpoint").serviceDetails("DataFlow", "UpdateSqlEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-flow/20200129/SqlEndpoint/UpdateSqlEndpoint").method(Method.PUT).requestBuilder(UpdateSqlEndpointRequest::builder).basePath("/20200129").appendPathParam("sqlEndpoints").appendPathParam(request.getSqlEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateSqlEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateSqlEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DataFlowWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataFlowPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataFlowClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataFlowClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataFlowClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataFlowClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "dataflow";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"dataflow");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DataFlowClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataFlowClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

