/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.PoolConfig;
import com.oracle.bmc.dataflow.model.PoolLifecycleState;
import com.oracle.bmc.dataflow.model.PoolMetrics;
import com.oracle.bmc.dataflow.model.PoolSchedule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Pool
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="lifecycleState")
    private final PoolLifecycleState lifecycleState;
    @JsonProperty(value="ownerPrincipalId")
    private final String ownerPrincipalId;
    @JsonProperty(value="ownerUserName")
    private final String ownerUserName;
    @JsonProperty(value="poolMetrics")
    private final PoolMetrics poolMetrics;
    @JsonProperty(value="configurations")
    private final List<PoolConfig> configurations;
    @JsonProperty(value="schedules")
    private final List<PoolSchedule> schedules;
    @JsonProperty(value="idleTimeoutInMinutes")
    private final Integer idleTimeoutInMinutes;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "description", "displayName", "freeformTags", "id", "lifecycleDetails", "lifecycleState", "ownerPrincipalId", "ownerUserName", "poolMetrics", "configurations", "schedules", "idleTimeoutInMinutes", "timeCreated", "timeUpdated"})
    public Pool(String compartmentId, Map<String, Map<String, Object>> definedTags, String description, String displayName, Map<String, String> freeformTags, String id, String lifecycleDetails, PoolLifecycleState lifecycleState, String ownerPrincipalId, String ownerUserName, PoolMetrics poolMetrics, List<PoolConfig> configurations, List<PoolSchedule> schedules, Integer idleTimeoutInMinutes, Date timeCreated, Date timeUpdated) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.description = description;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.lifecycleDetails = lifecycleDetails;
        this.lifecycleState = lifecycleState;
        this.ownerPrincipalId = ownerPrincipalId;
        this.ownerUserName = ownerUserName;
        this.poolMetrics = poolMetrics;
        this.configurations = configurations;
        this.schedules = schedules;
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public PoolLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOwnerPrincipalId() {
        return this.ownerPrincipalId;
    }

    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public PoolMetrics getPoolMetrics() {
        return this.poolMetrics;
    }

    public List<PoolConfig> getConfigurations() {
        return this.configurations;
    }

    public List<PoolSchedule> getSchedules() {
        return this.schedules;
    }

    public Integer getIdleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Pool(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", ownerPrincipalId=").append(String.valueOf(this.ownerPrincipalId));
        sb.append(", ownerUserName=").append(String.valueOf(this.ownerUserName));
        sb.append(", poolMetrics=").append(String.valueOf((Object)this.poolMetrics));
        sb.append(", configurations=").append(String.valueOf(this.configurations));
        sb.append(", schedules=").append(String.valueOf(this.schedules));
        sb.append(", idleTimeoutInMinutes=").append(String.valueOf(this.idleTimeoutInMinutes));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pool)) {
            return false;
        }
        Pool other = (Pool)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.ownerPrincipalId, other.ownerPrincipalId) && Objects.equals(this.ownerUserName, other.ownerUserName) && Objects.equals((Object)this.poolMetrics, (Object)other.poolMetrics) && Objects.equals(this.configurations, other.configurations) && Objects.equals(this.schedules, other.schedules) && Objects.equals(this.idleTimeoutInMinutes, other.idleTimeoutInMinutes) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.ownerPrincipalId == null ? 43 : this.ownerPrincipalId.hashCode());
        result = result * 59 + (this.ownerUserName == null ? 43 : this.ownerUserName.hashCode());
        result = result * 59 + (this.poolMetrics == null ? 43 : this.poolMetrics.hashCode());
        result = result * 59 + (this.configurations == null ? 43 : this.configurations.hashCode());
        result = result * 59 + (this.schedules == null ? 43 : this.schedules.hashCode());
        result = result * 59 + (this.idleTimeoutInMinutes == null ? 43 : this.idleTimeoutInMinutes.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="lifecycleState")
        private PoolLifecycleState lifecycleState;
        @JsonProperty(value="ownerPrincipalId")
        private String ownerPrincipalId;
        @JsonProperty(value="ownerUserName")
        private String ownerUserName;
        @JsonProperty(value="poolMetrics")
        private PoolMetrics poolMetrics;
        @JsonProperty(value="configurations")
        private List<PoolConfig> configurations;
        @JsonProperty(value="schedules")
        private List<PoolSchedule> schedules;
        @JsonProperty(value="idleTimeoutInMinutes")
        private Integer idleTimeoutInMinutes;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder lifecycleState(PoolLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder ownerPrincipalId(String ownerPrincipalId) {
            this.ownerPrincipalId = ownerPrincipalId;
            this.__explicitlySet__.add("ownerPrincipalId");
            return this;
        }

        public Builder ownerUserName(String ownerUserName) {
            this.ownerUserName = ownerUserName;
            this.__explicitlySet__.add("ownerUserName");
            return this;
        }

        public Builder poolMetrics(PoolMetrics poolMetrics) {
            this.poolMetrics = poolMetrics;
            this.__explicitlySet__.add("poolMetrics");
            return this;
        }

        public Builder configurations(List<PoolConfig> configurations) {
            this.configurations = configurations;
            this.__explicitlySet__.add("configurations");
            return this;
        }

        public Builder schedules(List<PoolSchedule> schedules) {
            this.schedules = schedules;
            this.__explicitlySet__.add("schedules");
            return this;
        }

        public Builder idleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
            this.__explicitlySet__.add("idleTimeoutInMinutes");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Pool build() {
            Pool model = new Pool(this.compartmentId, this.definedTags, this.description, this.displayName, this.freeformTags, this.id, this.lifecycleDetails, this.lifecycleState, this.ownerPrincipalId, this.ownerUserName, this.poolMetrics, this.configurations, this.schedules, this.idleTimeoutInMinutes, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Pool model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("ownerPrincipalId")) {
                this.ownerPrincipalId(model.getOwnerPrincipalId());
            }
            if (model.wasPropertyExplicitlySet("ownerUserName")) {
                this.ownerUserName(model.getOwnerUserName());
            }
            if (model.wasPropertyExplicitlySet("poolMetrics")) {
                this.poolMetrics(model.getPoolMetrics());
            }
            if (model.wasPropertyExplicitlySet("configurations")) {
                this.configurations(model.getConfigurations());
            }
            if (model.wasPropertyExplicitlySet("schedules")) {
                this.schedules(model.getSchedules());
            }
            if (model.wasPropertyExplicitlySet("idleTimeoutInMinutes")) {
                this.idleTimeoutInMinutes(model.getIdleTimeoutInMinutes());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

