/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.ShapeConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PoolConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="shapeConfig")
    private final ShapeConfig shapeConfig;
    @JsonProperty(value="min")
    private final Integer min;
    @JsonProperty(value="max")
    private final Integer max;

    @Deprecated
    @ConstructorProperties(value={"shape", "shapeConfig", "min", "max"})
    public PoolConfig(String shape, ShapeConfig shapeConfig, Integer min, Integer max) {
        this.shape = shape;
        this.shapeConfig = shapeConfig;
        this.min = min;
        this.max = max;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public ShapeConfig getShapeConfig() {
        return this.shapeConfig;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolConfig(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", min=").append(String.valueOf(this.min));
        sb.append(", max=").append(String.valueOf(this.max));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PoolConfig)) {
            return false;
        }
        PoolConfig other = (PoolConfig)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.min == null ? 43 : this.min.hashCode());
        result = result * 59 + (this.max == null ? 43 : this.max.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="shapeConfig")
        private ShapeConfig shapeConfig;
        @JsonProperty(value="min")
        private Integer min;
        @JsonProperty(value="max")
        private Integer max;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeConfig(ShapeConfig shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder min(Integer min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder max(Integer max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public PoolConfig build() {
            PoolConfig model = new PoolConfig(this.shape, this.shapeConfig, this.min, this.max);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PoolConfig model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            return this;
        }
    }
}

