/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.IpNotationType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecureAccessControlRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ipNotation")
    private final IpNotationType ipNotation;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="vcnIps")
    private final String vcnIps;

    @Deprecated
    @ConstructorProperties(value={"ipNotation", "value", "vcnIps"})
    public SecureAccessControlRule(IpNotationType ipNotation, String value, String vcnIps) {
        this.ipNotation = ipNotation;
        this.value = value;
        this.vcnIps = vcnIps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public IpNotationType getIpNotation() {
        return this.ipNotation;
    }

    public String getValue() {
        return this.value;
    }

    public String getVcnIps() {
        return this.vcnIps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecureAccessControlRule(");
        sb.append("super=").append(super.toString());
        sb.append("ipNotation=").append(String.valueOf((Object)this.ipNotation));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", vcnIps=").append(String.valueOf(this.vcnIps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecureAccessControlRule)) {
            return false;
        }
        SecureAccessControlRule other = (SecureAccessControlRule)((Object)o);
        return Objects.equals((Object)this.ipNotation, (Object)other.ipNotation) && Objects.equals(this.value, other.value) && Objects.equals(this.vcnIps, other.vcnIps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ipNotation == null ? 43 : this.ipNotation.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.vcnIps == null ? 43 : this.vcnIps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ipNotation")
        private IpNotationType ipNotation;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="vcnIps")
        private String vcnIps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ipNotation(IpNotationType ipNotation) {
            this.ipNotation = ipNotation;
            this.__explicitlySet__.add("ipNotation");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder vcnIps(String vcnIps) {
            this.vcnIps = vcnIps;
            this.__explicitlySet__.add("vcnIps");
            return this;
        }

        public SecureAccessControlRule build() {
            SecureAccessControlRule model = new SecureAccessControlRule(this.ipNotation, this.value, this.vcnIps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecureAccessControlRule model) {
            if (model.wasPropertyExplicitlySet("ipNotation")) {
                this.ipNotation(model.getIpNotation());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("vcnIps")) {
                this.vcnIps(model.getVcnIps());
            }
            return this;
        }
    }
}

