/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataflow.model.SqlEndpointNetworkConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="networkType")
@JsonFilter(value="explicitlySetFilter")
public final class SqlEndpointVcnConfig
extends SqlEndpointNetworkConfiguration {
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="hostNamePrefix")
    private final String hostNamePrefix;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="privateEndpointIp")
    private final String privateEndpointIp;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SqlEndpointVcnConfig(String vcnId, String subnetId, String hostNamePrefix, List<String> nsgIds, String privateEndpointIp) {
        this.vcnId = vcnId;
        this.subnetId = subnetId;
        this.hostNamePrefix = hostNamePrefix;
        this.nsgIds = nsgIds;
        this.privateEndpointIp = privateEndpointIp;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getHostNamePrefix() {
        return this.hostNamePrefix;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public String getPrivateEndpointIp() {
        return this.privateEndpointIp;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlEndpointVcnConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", hostNamePrefix=").append(String.valueOf(this.hostNamePrefix));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", privateEndpointIp=").append(String.valueOf(this.privateEndpointIp));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlEndpointVcnConfig)) {
            return false;
        }
        SqlEndpointVcnConfig other = (SqlEndpointVcnConfig)((Object)o);
        return Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.hostNamePrefix, other.hostNamePrefix) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.privateEndpointIp, other.privateEndpointIp) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.hostNamePrefix == null ? 43 : this.hostNamePrefix.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.privateEndpointIp == null ? 43 : this.privateEndpointIp.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="hostNamePrefix")
        private String hostNamePrefix;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="privateEndpointIp")
        private String privateEndpointIp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder hostNamePrefix(String hostNamePrefix) {
            this.hostNamePrefix = hostNamePrefix;
            this.__explicitlySet__.add("hostNamePrefix");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder privateEndpointIp(String privateEndpointIp) {
            this.privateEndpointIp = privateEndpointIp;
            this.__explicitlySet__.add("privateEndpointIp");
            return this;
        }

        public SqlEndpointVcnConfig build() {
            SqlEndpointVcnConfig model = new SqlEndpointVcnConfig(this.vcnId, this.subnetId, this.hostNamePrefix, this.nsgIds, this.privateEndpointIp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlEndpointVcnConfig model) {
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("hostNamePrefix")) {
                this.hostNamePrefix(model.getHostNamePrefix());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointIp")) {
                this.privateEndpointIp(model.getPrivateEndpointIp());
            }
            return this;
        }
    }
}

