/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.CreateRunDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateRunRequest
extends BmcRequest<CreateRunDetails> {
    private CreateRunDetails createRunDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String opcParentRptUrl;

    public CreateRunDetails getCreateRunDetails() {
        return this.createRunDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcParentRptUrl() {
        return this.opcParentRptUrl;
    }

    @InternalSdk
    public CreateRunDetails getBody$() {
        return this.createRunDetails;
    }

    public Builder toBuilder() {
        return new Builder().createRunDetails(this.createRunDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).opcParentRptUrl(this.opcParentRptUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createRunDetails=").append(String.valueOf((Object)this.createRunDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcParentRptUrl=").append(String.valueOf(this.opcParentRptUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateRunRequest)) {
            return false;
        }
        CreateRunRequest other = (CreateRunRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createRunDetails, (Object)other.createRunDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcParentRptUrl, other.opcParentRptUrl);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createRunDetails == null ? 43 : this.createRunDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcParentRptUrl == null ? 43 : this.opcParentRptUrl.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateRunRequest, CreateRunDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateRunDetails createRunDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String opcParentRptUrl = null;

        public Builder createRunDetails(CreateRunDetails createRunDetails) {
            this.createRunDetails = createRunDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcParentRptUrl(String opcParentRptUrl) {
            this.opcParentRptUrl = opcParentRptUrl;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateRunRequest o) {
            this.createRunDetails(o.getCreateRunDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.opcParentRptUrl(o.getOpcParentRptUrl());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateRunRequest build() {
            CreateRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateRunDetails body) {
            this.createRunDetails(body);
            return this;
        }

        public CreateRunRequest buildWithoutInvocationCallback() {
            CreateRunRequest request = new CreateRunRequest();
            request.createRunDetails = this.createRunDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.opcParentRptUrl = this.opcParentRptUrl;
            return request;
        }
    }
}

