/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteStatementRequest
extends BmcRequest<Void> {
    private String runId;
    private String statementId;
    private String opcRequestId;
    private String ifMatch;

    public String getRunId() {
        return this.runId;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().runId(this.runId).statementId(this.statementId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",runId=").append(String.valueOf(this.runId));
        sb.append(",statementId=").append(String.valueOf(this.statementId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteStatementRequest)) {
            return false;
        }
        DeleteStatementRequest other = (DeleteStatementRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.runId, other.runId) && Objects.equals(this.statementId, other.statementId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.statementId == null ? 43 : this.statementId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteStatementRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String runId = null;
        private String statementId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteStatementRequest o) {
            this.runId(o.getRunId());
            this.statementId(o.getStatementId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteStatementRequest build() {
            DeleteStatementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteStatementRequest buildWithoutInvocationCallback() {
            DeleteStatementRequest request = new DeleteStatementRequest();
            request.runId = this.runId;
            request.statementId = this.statementId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

