/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSqlEndpointRequest
extends BmcRequest<Void> {
    private String sqlEndpointId;
    private String opcRequestId;

    public String getSqlEndpointId() {
        return this.sqlEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().sqlEndpointId(this.sqlEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sqlEndpointId=").append(String.valueOf(this.sqlEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSqlEndpointRequest)) {
            return false;
        }
        GetSqlEndpointRequest other = (GetSqlEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sqlEndpointId, other.sqlEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlEndpointId == null ? 43 : this.sqlEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSqlEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sqlEndpointId = null;
        private String opcRequestId = null;

        public Builder sqlEndpointId(String sqlEndpointId) {
            this.sqlEndpointId = sqlEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSqlEndpointRequest o) {
            this.sqlEndpointId(o.getSqlEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSqlEndpointRequest build() {
            GetSqlEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSqlEndpointRequest buildWithoutInvocationCallback() {
            GetSqlEndpointRequest request = new GetSqlEndpointRequest();
            request.sqlEndpointId = this.sqlEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

