/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.UpdatePoolDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePoolRequest
extends BmcRequest<UpdatePoolDetails> {
    private UpdatePoolDetails updatePoolDetails;
    private String poolId;
    private String opcRequestId;
    private String ifMatch;

    public UpdatePoolDetails getUpdatePoolDetails() {
        return this.updatePoolDetails;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePoolDetails getBody$() {
        return this.updatePoolDetails;
    }

    public Builder toBuilder() {
        return new Builder().updatePoolDetails(this.updatePoolDetails).poolId(this.poolId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",updatePoolDetails=").append(String.valueOf((Object)this.updatePoolDetails));
        sb.append(",poolId=").append(String.valueOf(this.poolId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePoolRequest)) {
            return false;
        }
        UpdatePoolRequest other = (UpdatePoolRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.updatePoolDetails, (Object)other.updatePoolDetails) && Objects.equals(this.poolId, other.poolId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.updatePoolDetails == null ? 43 : this.updatePoolDetails.hashCode());
        result = result * 59 + (this.poolId == null ? 43 : this.poolId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePoolRequest, UpdatePoolDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private UpdatePoolDetails updatePoolDetails = null;
        private String poolId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder updatePoolDetails(UpdatePoolDetails updatePoolDetails) {
            this.updatePoolDetails = updatePoolDetails;
            return this;
        }

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePoolRequest o) {
            this.updatePoolDetails(o.getUpdatePoolDetails());
            this.poolId(o.getPoolId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePoolRequest build() {
            UpdatePoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePoolDetails body) {
            this.updatePoolDetails(body);
            return this;
        }

        public UpdatePoolRequest buildWithoutInvocationCallback() {
            UpdatePoolRequest request = new UpdatePoolRequest();
            request.updatePoolDetails = this.updatePoolDetails;
            request.poolId = this.poolId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

