/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataflow.model.UpdateRunDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRunRequest
extends BmcRequest<UpdateRunDetails> {
    private UpdateRunDetails updateRunDetails;
    private String runId;
    private String opcRequestId;
    private String ifMatch;

    public UpdateRunDetails getUpdateRunDetails() {
        return this.updateRunDetails;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateRunDetails getBody$() {
        return this.updateRunDetails;
    }

    public Builder toBuilder() {
        return new Builder().updateRunDetails(this.updateRunDetails).runId(this.runId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",updateRunDetails=").append(String.valueOf((Object)this.updateRunDetails));
        sb.append(",runId=").append(String.valueOf(this.runId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRunRequest)) {
            return false;
        }
        UpdateRunRequest other = (UpdateRunRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.updateRunDetails, (Object)other.updateRunDetails) && Objects.equals(this.runId, other.runId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.updateRunDetails == null ? 43 : this.updateRunDetails.hashCode());
        result = result * 59 + (this.runId == null ? 43 : this.runId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRunRequest, UpdateRunDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private UpdateRunDetails updateRunDetails = null;
        private String runId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder updateRunDetails(UpdateRunDetails updateRunDetails) {
            this.updateRunDetails = updateRunDetails;
            return this;
        }

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRunRequest o) {
            this.updateRunDetails(o.getUpdateRunDetails());
            this.runId(o.getRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRunRequest build() {
            UpdateRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRunDetails body) {
            this.updateRunDetails(body);
            return this;
        }

        public UpdateRunRequest buildWithoutInvocationCallback() {
            UpdateRunRequest request = new UpdateRunRequest();
            request.updateRunDetails = this.updateRunDetails;
            request.runId = this.runId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

