/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.responses;

import com.oracle.bmc.dataflow.model.RunLogSummary;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListRunLogsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcPrevPage;
    private String opcNextPage;
    private List<RunLogSummary> items;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<RunLogSummary> getItems() {
        return this.items;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcPrevPage", "opcNextPage", "items"})
    private ListRunLogsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcPrevPage, String opcNextPage, List<RunLogSummary> items) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcPrevPage = opcPrevPage;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcPrevPage=").append(String.valueOf(this.opcPrevPage));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRunLogsResponse)) {
            return false;
        }
        ListRunLogsResponse other = (ListRunLogsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcPrevPage, other.opcPrevPage) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.items, other.items);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcPrevPage == null ? 43 : this.opcPrevPage.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListRunLogsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcPrevPage;
        private String opcNextPage;
        private List<RunLogSummary> items;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<RunLogSummary> items) {
            this.items = items;
            return this;
        }

        public Builder copy(ListRunLogsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcPrevPage(o.getOpcPrevPage());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        public ListRunLogsResponse build() {
            return new ListRunLogsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcPrevPage, this.opcNextPage, this.items);
        }
    }
}

