/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataintegration.DataIntegration;
import com.oracle.bmc.dataintegration.DataIntegrationPaginators;
import com.oracle.bmc.dataintegration.DataIntegrationWaiters;
import com.oracle.bmc.dataintegration.internal.http.ChangeCompartmentConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateEntityShapeConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePatchConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePatchConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.GetApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.GetConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetCountStatisticConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataEntityConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDependentObjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPatchConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPublishedObjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetReferenceConverter;
import com.oracle.bmc.dataintegration.internal.http.GetSchemaConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.dataintegration.internal.http.GetWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.ListApplicationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListConnectionValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListConnectionsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataAssetsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataEntitiesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataFlowValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataFlowsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDependentObjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListExternalPublicationValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListExternalPublicationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListFoldersConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPatchChangesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPatchesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPipelineValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPipelinesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListProjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPublishedObjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListReferencesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListSchemasConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskRunLogsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskRunsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTasksConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkspacesConverter;
import com.oracle.bmc.dataintegration.internal.http.StartWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.StopWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdatePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateReferenceConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateWorkspaceConverter;
import com.oracle.bmc.dataintegration.requests.ChangeCompartmentRequest;
import com.oracle.bmc.dataintegration.requests.CreateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateEntityShapeRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateFolderRequest;
import com.oracle.bmc.dataintegration.requests.CreatePatchRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateProjectRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteFolderRequest;
import com.oracle.bmc.dataintegration.requests.DeletePatchRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteProjectRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.GetApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetCountStatisticRequest;
import com.oracle.bmc.dataintegration.requests.GetDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.GetDataEntityRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetDependentObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetFolderRequest;
import com.oracle.bmc.dataintegration.requests.GetPatchRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetProjectRequest;
import com.oracle.bmc.dataintegration.requests.GetPublishedObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetReferenceRequest;
import com.oracle.bmc.dataintegration.requests.GetSchemaRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.ListApplicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowsRequest;
import com.oracle.bmc.dataintegration.requests.ListDependentObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListFoldersRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchChangesRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchesRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelineValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelinesRequest;
import com.oracle.bmc.dataintegration.requests.ListProjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListPublishedObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListReferencesRequest;
import com.oracle.bmc.dataintegration.requests.ListSchemasRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListTasksRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkspacesRequest;
import com.oracle.bmc.dataintegration.requests.StartWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.StopWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.UpdateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateFolderRequest;
import com.oracle.bmc.dataintegration.requests.UpdatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.UpdateProjectRequest;
import com.oracle.bmc.dataintegration.requests.UpdateReferenceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.UpdateWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.ChangeCompartmentResponse;
import com.oracle.bmc.dataintegration.responses.CreateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateEntityShapeResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateFolderResponse;
import com.oracle.bmc.dataintegration.responses.CreatePatchResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateProjectResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteFolderResponse;
import com.oracle.bmc.dataintegration.responses.DeletePatchResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteProjectResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.GetApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetCountStatisticResponse;
import com.oracle.bmc.dataintegration.responses.GetDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.GetDataEntityResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetDependentObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetFolderResponse;
import com.oracle.bmc.dataintegration.responses.GetPatchResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetProjectResponse;
import com.oracle.bmc.dataintegration.responses.GetPublishedObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetReferenceResponse;
import com.oracle.bmc.dataintegration.responses.GetSchemaResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.ListApplicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowsResponse;
import com.oracle.bmc.dataintegration.responses.ListDependentObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListFoldersResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchesResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelineValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelinesResponse;
import com.oracle.bmc.dataintegration.responses.ListProjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListPublishedObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListReferencesResponse;
import com.oracle.bmc.dataintegration.responses.ListSchemasResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListTasksResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkspacesResponse;
import com.oracle.bmc.dataintegration.responses.StartWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.StopWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.UpdateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateFolderResponse;
import com.oracle.bmc.dataintegration.responses.UpdatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.UpdateProjectResponse;
import com.oracle.bmc.dataintegration.responses.UpdateReferenceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.UpdateWorkspaceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIntegrationClient
implements DataIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(DataIntegrationClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAINTEGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataintegration.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DataIntegrationWaiters waiters;
    private final DataIntegrationPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DataIntegrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataIntegrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataIntegrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataIntegrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataIntegration-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataIntegrationWaiters(executorService, this);
        this.paginators = new DataIntegrationPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeCompartmentResponse changeCompartment(ChangeCompartmentRequest request) {
        LOG.trace("Called changeCompartment");
        ChangeCompartmentRequest interceptedRequest = ChangeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCompartmentResponse> transformer = ChangeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        LOG.trace("Called createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateApplicationDetails(), (BmcRequest)retriedRequest);
                return (CreateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        LOG.trace("Called createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectionDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateConnectionValidationResponse createConnectionValidation(CreateConnectionValidationRequest request) {
        LOG.trace("Called createConnectionValidation");
        CreateConnectionValidationRequest interceptedRequest = CreateConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectionValidationResponse> transformer = CreateConnectionValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateConnectionValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectionValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectionValidationDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectionValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataAssetResponse createDataAsset(CreateDataAssetRequest request) {
        LOG.trace("Called createDataAsset");
        CreateDataAssetRequest interceptedRequest = CreateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataAssetResponse> transformer = CreateDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataAssetDetails(), (BmcRequest)retriedRequest);
                return (CreateDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataFlowResponse createDataFlow(CreateDataFlowRequest request) {
        LOG.trace("Called createDataFlow");
        CreateDataFlowRequest interceptedRequest = CreateDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataFlowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataFlowResponse> transformer = CreateDataFlowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataFlowResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataFlowResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataFlowDetails(), (BmcRequest)retriedRequest);
                return (CreateDataFlowResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataFlowValidationResponse createDataFlowValidation(CreateDataFlowValidationRequest request) {
        LOG.trace("Called createDataFlowValidation");
        CreateDataFlowValidationRequest interceptedRequest = CreateDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataFlowValidationResponse> transformer = CreateDataFlowValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataFlowValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataFlowValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataFlowValidationDetails(), (BmcRequest)retriedRequest);
                return (CreateDataFlowValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateEntityShapeResponse createEntityShape(CreateEntityShapeRequest request) {
        LOG.trace("Called createEntityShape");
        CreateEntityShapeRequest interceptedRequest = CreateEntityShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityShapeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateEntityShapeResponse> transformer = CreateEntityShapeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateEntityShapeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateEntityShapeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateEntityShapeDetails(), (BmcRequest)retriedRequest);
                return (CreateEntityShapeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateExternalPublicationResponse createExternalPublication(CreateExternalPublicationRequest request) {
        LOG.trace("Called createExternalPublication");
        CreateExternalPublicationRequest interceptedRequest = CreateExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExternalPublicationResponse> transformer = CreateExternalPublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateExternalPublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateExternalPublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateExternalPublicationDetails(), (BmcRequest)retriedRequest);
                return (CreateExternalPublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateExternalPublicationValidationResponse createExternalPublicationValidation(CreateExternalPublicationValidationRequest request) {
        LOG.trace("Called createExternalPublicationValidation");
        CreateExternalPublicationValidationRequest interceptedRequest = CreateExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExternalPublicationValidationResponse> transformer = CreateExternalPublicationValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateExternalPublicationValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateExternalPublicationValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateExternalPublicationValidationDetails(), (BmcRequest)retriedRequest);
                return (CreateExternalPublicationValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest request) {
        LOG.trace("Called createFolder");
        CreateFolderRequest interceptedRequest = CreateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateFolderResponse> transformer = CreateFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateFolderDetails(), (BmcRequest)retriedRequest);
                return (CreateFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePatchResponse createPatch(CreatePatchRequest request) {
        LOG.trace("Called createPatch");
        CreatePatchRequest interceptedRequest = CreatePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePatchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePatchResponse> transformer = CreatePatchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePatchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePatchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePatchDetails(), (BmcRequest)retriedRequest);
                return (CreatePatchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest request) {
        LOG.trace("Called createPipeline");
        CreatePipelineRequest interceptedRequest = CreatePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePipelineResponse> transformer = CreatePipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePipelineResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePipelineResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePipelineDetails(), (BmcRequest)retriedRequest);
                return (CreatePipelineResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePipelineValidationResponse createPipelineValidation(CreatePipelineValidationRequest request) {
        LOG.trace("Called createPipelineValidation");
        CreatePipelineValidationRequest interceptedRequest = CreatePipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePipelineValidationResponse> transformer = CreatePipelineValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePipelineValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePipelineValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePipelineValidationDetails(), (BmcRequest)retriedRequest);
                return (CreatePipelineValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        LOG.trace("Called createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateProjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProjectDetails(), (BmcRequest)retriedRequest);
                return (CreateProjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTaskResponse createTask(CreateTaskRequest request) {
        LOG.trace("Called createTask");
        CreateTaskRequest interceptedRequest = CreateTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTaskResponse> transformer = CreateTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTaskDetails(), (BmcRequest)retriedRequest);
                return (CreateTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTaskRunResponse createTaskRun(CreateTaskRunRequest request) {
        LOG.trace("Called createTaskRun");
        CreateTaskRunRequest interceptedRequest = CreateTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTaskRunResponse> transformer = CreateTaskRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTaskRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTaskRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTaskRunDetails(), (BmcRequest)retriedRequest);
                return (CreateTaskRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTaskValidationResponse createTaskValidation(CreateTaskValidationRequest request) {
        LOG.trace("Called createTaskValidation");
        CreateTaskValidationRequest interceptedRequest = CreateTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTaskValidationResponse> transformer = CreateTaskValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTaskValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTaskValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTaskValidationDetails(), (BmcRequest)retriedRequest);
                return (CreateTaskValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest request) {
        LOG.trace("Called createWorkspace");
        CreateWorkspaceRequest interceptedRequest = CreateWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateWorkspaceResponse> transformer = CreateWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateWorkspaceDetails(), (BmcRequest)retriedRequest);
                return (CreateWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest request) {
        LOG.trace("Called deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        LOG.trace("Called deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConnectionValidationResponse deleteConnectionValidation(DeleteConnectionValidationRequest request) {
        LOG.trace("Called deleteConnectionValidation");
        DeleteConnectionValidationRequest interceptedRequest = DeleteConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectionValidationResponse> transformer = DeleteConnectionValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteConnectionValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectionValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectionValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataAssetResponse deleteDataAsset(DeleteDataAssetRequest request) {
        LOG.trace("Called deleteDataAsset");
        DeleteDataAssetRequest interceptedRequest = DeleteDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataAssetResponse> transformer = DeleteDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataFlowResponse deleteDataFlow(DeleteDataFlowRequest request) {
        LOG.trace("Called deleteDataFlow");
        DeleteDataFlowRequest interceptedRequest = DeleteDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataFlowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataFlowResponse> transformer = DeleteDataFlowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataFlowResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataFlowResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataFlowResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataFlowValidationResponse deleteDataFlowValidation(DeleteDataFlowValidationRequest request) {
        LOG.trace("Called deleteDataFlowValidation");
        DeleteDataFlowValidationRequest interceptedRequest = DeleteDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataFlowValidationResponse> transformer = DeleteDataFlowValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataFlowValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataFlowValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataFlowValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteExternalPublicationResponse deleteExternalPublication(DeleteExternalPublicationRequest request) {
        LOG.trace("Called deleteExternalPublication");
        DeleteExternalPublicationRequest interceptedRequest = DeleteExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteExternalPublicationResponse> transformer = DeleteExternalPublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteExternalPublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteExternalPublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteExternalPublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteExternalPublicationValidationResponse deleteExternalPublicationValidation(DeleteExternalPublicationValidationRequest request) {
        LOG.trace("Called deleteExternalPublicationValidation");
        DeleteExternalPublicationValidationRequest interceptedRequest = DeleteExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteExternalPublicationValidationResponse> transformer = DeleteExternalPublicationValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteExternalPublicationValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteExternalPublicationValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteExternalPublicationValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) {
        LOG.trace("Called deleteFolder");
        DeleteFolderRequest interceptedRequest = DeleteFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFolderResponse> transformer = DeleteFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePatchResponse deletePatch(DeletePatchRequest request) {
        LOG.trace("Called deletePatch");
        DeletePatchRequest interceptedRequest = DeletePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePatchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePatchResponse> transformer = DeletePatchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePatchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePatchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePatchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest request) {
        LOG.trace("Called deletePipeline");
        DeletePipelineRequest interceptedRequest = DeletePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePipelineResponse> transformer = DeletePipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePipelineResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePipelineResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePipelineResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePipelineValidationResponse deletePipelineValidation(DeletePipelineValidationRequest request) {
        LOG.trace("Called deletePipelineValidation");
        DeletePipelineValidationRequest interceptedRequest = DeletePipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePipelineValidationResponse> transformer = DeletePipelineValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePipelineValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePipelineValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePipelineValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        LOG.trace("Called deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteProjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTaskResponse deleteTask(DeleteTaskRequest request) {
        LOG.trace("Called deleteTask");
        DeleteTaskRequest interceptedRequest = DeleteTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTaskResponse> transformer = DeleteTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTaskRunResponse deleteTaskRun(DeleteTaskRunRequest request) {
        LOG.trace("Called deleteTaskRun");
        DeleteTaskRunRequest interceptedRequest = DeleteTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTaskRunResponse> transformer = DeleteTaskRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTaskRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTaskRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTaskRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTaskValidationResponse deleteTaskValidation(DeleteTaskValidationRequest request) {
        LOG.trace("Called deleteTaskValidation");
        DeleteTaskValidationRequest interceptedRequest = DeleteTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTaskValidationResponse> transformer = DeleteTaskValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTaskValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTaskValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTaskValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest request) {
        LOG.trace("Called deleteWorkspace");
        DeleteWorkspaceRequest interceptedRequest = DeleteWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkspaceResponse> transformer = DeleteWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest request) {
        LOG.trace("Called getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        LOG.trace("Called getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConnectionValidationResponse getConnectionValidation(GetConnectionValidationRequest request) {
        LOG.trace("Called getConnectionValidation");
        GetConnectionValidationRequest interceptedRequest = GetConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectionValidationResponse> transformer = GetConnectionValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConnectionValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectionValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectionValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCountStatisticResponse getCountStatistic(GetCountStatisticRequest request) {
        LOG.trace("Called getCountStatistic");
        GetCountStatisticRequest interceptedRequest = GetCountStatisticConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCountStatisticConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCountStatisticResponse> transformer = GetCountStatisticConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCountStatisticResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCountStatisticResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCountStatisticResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataAssetResponse getDataAsset(GetDataAssetRequest request) {
        LOG.trace("Called getDataAsset");
        GetDataAssetRequest interceptedRequest = GetDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataAssetResponse> transformer = GetDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataEntityResponse getDataEntity(GetDataEntityRequest request) {
        LOG.trace("Called getDataEntity");
        GetDataEntityRequest interceptedRequest = GetDataEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataEntityResponse> transformer = GetDataEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataFlowResponse getDataFlow(GetDataFlowRequest request) {
        LOG.trace("Called getDataFlow");
        GetDataFlowRequest interceptedRequest = GetDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataFlowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataFlowResponse> transformer = GetDataFlowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataFlowResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataFlowResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataFlowResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataFlowValidationResponse getDataFlowValidation(GetDataFlowValidationRequest request) {
        LOG.trace("Called getDataFlowValidation");
        GetDataFlowValidationRequest interceptedRequest = GetDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataFlowValidationResponse> transformer = GetDataFlowValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataFlowValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataFlowValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataFlowValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDependentObjectResponse getDependentObject(GetDependentObjectRequest request) {
        LOG.trace("Called getDependentObject");
        GetDependentObjectRequest interceptedRequest = GetDependentObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDependentObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDependentObjectResponse> transformer = GetDependentObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDependentObjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDependentObjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDependentObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExternalPublicationResponse getExternalPublication(GetExternalPublicationRequest request) {
        LOG.trace("Called getExternalPublication");
        GetExternalPublicationRequest interceptedRequest = GetExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExternalPublicationResponse> transformer = GetExternalPublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetExternalPublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetExternalPublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetExternalPublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExternalPublicationValidationResponse getExternalPublicationValidation(GetExternalPublicationValidationRequest request) {
        LOG.trace("Called getExternalPublicationValidation");
        GetExternalPublicationValidationRequest interceptedRequest = GetExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExternalPublicationValidationResponse> transformer = GetExternalPublicationValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetExternalPublicationValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetExternalPublicationValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetExternalPublicationValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest request) {
        LOG.trace("Called getFolder");
        GetFolderRequest interceptedRequest = GetFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFolderResponse> transformer = GetFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPatchResponse getPatch(GetPatchRequest request) {
        LOG.trace("Called getPatch");
        GetPatchRequest interceptedRequest = GetPatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPatchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPatchResponse> transformer = GetPatchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPatchResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPatchResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPatchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest request) {
        LOG.trace("Called getPipeline");
        GetPipelineRequest interceptedRequest = GetPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPipelineResponse> transformer = GetPipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPipelineResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPipelineResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPipelineResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPipelineValidationResponse getPipelineValidation(GetPipelineValidationRequest request) {
        LOG.trace("Called getPipelineValidation");
        GetPipelineValidationRequest interceptedRequest = GetPipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPipelineValidationResponse> transformer = GetPipelineValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPipelineValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPipelineValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPipelineValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        LOG.trace("Called getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetProjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublishedObjectResponse getPublishedObject(GetPublishedObjectRequest request) {
        LOG.trace("Called getPublishedObject");
        GetPublishedObjectRequest interceptedRequest = GetPublishedObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublishedObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublishedObjectResponse> transformer = GetPublishedObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPublishedObjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPublishedObjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPublishedObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetReferenceResponse getReference(GetReferenceRequest request) {
        LOG.trace("Called getReference");
        GetReferenceRequest interceptedRequest = GetReferenceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetReferenceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetReferenceResponse> transformer = GetReferenceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetReferenceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetReferenceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetReferenceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSchemaResponse getSchema(GetSchemaRequest request) {
        LOG.trace("Called getSchema");
        GetSchemaRequest interceptedRequest = GetSchemaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSchemaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSchemaResponse> transformer = GetSchemaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSchemaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSchemaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSchemaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTaskResponse getTask(GetTaskRequest request) {
        LOG.trace("Called getTask");
        GetTaskRequest interceptedRequest = GetTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTaskResponse> transformer = GetTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTaskRunResponse getTaskRun(GetTaskRunRequest request) {
        LOG.trace("Called getTaskRun");
        GetTaskRunRequest interceptedRequest = GetTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTaskRunResponse> transformer = GetTaskRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTaskRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTaskRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTaskRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTaskValidationResponse getTaskValidation(GetTaskValidationRequest request) {
        LOG.trace("Called getTaskValidation");
        GetTaskValidationRequest interceptedRequest = GetTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTaskValidationResponse> transformer = GetTaskValidationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTaskValidationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTaskValidationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTaskValidationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkspaceResponse getWorkspace(GetWorkspaceRequest request) {
        LOG.trace("Called getWorkspace");
        GetWorkspaceRequest interceptedRequest = GetWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkspaceResponse> transformer = GetWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest request) {
        LOG.trace("Called listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApplicationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApplicationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApplicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConnectionValidationsResponse listConnectionValidations(ListConnectionValidationsRequest request) {
        LOG.trace("Called listConnectionValidations");
        ListConnectionValidationsRequest interceptedRequest = ListConnectionValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectionValidationsResponse> transformer = ListConnectionValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConnectionValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectionValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectionValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        LOG.trace("Called listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConnectionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataAssetsResponse listDataAssets(ListDataAssetsRequest request) {
        LOG.trace("Called listDataAssets");
        ListDataAssetsRequest interceptedRequest = ListDataAssetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataAssetsResponse> transformer = ListDataAssetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataAssetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataAssetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataAssetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataEntitiesResponse listDataEntities(ListDataEntitiesRequest request) {
        LOG.trace("Called listDataEntities");
        ListDataEntitiesRequest interceptedRequest = ListDataEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataEntitiesResponse> transformer = ListDataEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataFlowValidationsResponse listDataFlowValidations(ListDataFlowValidationsRequest request) {
        LOG.trace("Called listDataFlowValidations");
        ListDataFlowValidationsRequest interceptedRequest = ListDataFlowValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataFlowValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataFlowValidationsResponse> transformer = ListDataFlowValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataFlowValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataFlowValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataFlowValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataFlowsResponse listDataFlows(ListDataFlowsRequest request) {
        LOG.trace("Called listDataFlows");
        ListDataFlowsRequest interceptedRequest = ListDataFlowsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataFlowsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataFlowsResponse> transformer = ListDataFlowsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataFlowsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataFlowsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataFlowsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDependentObjectsResponse listDependentObjects(ListDependentObjectsRequest request) {
        LOG.trace("Called listDependentObjects");
        ListDependentObjectsRequest interceptedRequest = ListDependentObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDependentObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDependentObjectsResponse> transformer = ListDependentObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDependentObjectsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDependentObjectsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDependentObjectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListExternalPublicationValidationsResponse listExternalPublicationValidations(ListExternalPublicationValidationsRequest request) {
        LOG.trace("Called listExternalPublicationValidations");
        ListExternalPublicationValidationsRequest interceptedRequest = ListExternalPublicationValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExternalPublicationValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExternalPublicationValidationsResponse> transformer = ListExternalPublicationValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListExternalPublicationValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListExternalPublicationValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListExternalPublicationValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListExternalPublicationsResponse listExternalPublications(ListExternalPublicationsRequest request) {
        LOG.trace("Called listExternalPublications");
        ListExternalPublicationsRequest interceptedRequest = ListExternalPublicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExternalPublicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExternalPublicationsResponse> transformer = ListExternalPublicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListExternalPublicationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListExternalPublicationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListExternalPublicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFoldersResponse listFolders(ListFoldersRequest request) {
        LOG.trace("Called listFolders");
        ListFoldersRequest interceptedRequest = ListFoldersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFoldersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFoldersResponse> transformer = ListFoldersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListFoldersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFoldersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFoldersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPatchChangesResponse listPatchChanges(ListPatchChangesRequest request) {
        LOG.trace("Called listPatchChanges");
        ListPatchChangesRequest interceptedRequest = ListPatchChangesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatchChangesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPatchChangesResponse> transformer = ListPatchChangesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPatchChangesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPatchChangesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPatchChangesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPatchesResponse listPatches(ListPatchesRequest request) {
        LOG.trace("Called listPatches");
        ListPatchesRequest interceptedRequest = ListPatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPatchesResponse> transformer = ListPatchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPatchesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPatchesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPatchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPipelineValidationsResponse listPipelineValidations(ListPipelineValidationsRequest request) {
        LOG.trace("Called listPipelineValidations");
        ListPipelineValidationsRequest interceptedRequest = ListPipelineValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPipelineValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPipelineValidationsResponse> transformer = ListPipelineValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPipelineValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPipelineValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPipelineValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest request) {
        LOG.trace("Called listPipelines");
        ListPipelinesRequest interceptedRequest = ListPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPipelinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPipelinesResponse> transformer = ListPipelinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPipelinesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPipelinesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPipelinesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        LOG.trace("Called listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProjectsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProjectsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProjectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublishedObjectsResponse listPublishedObjects(ListPublishedObjectsRequest request) {
        LOG.trace("Called listPublishedObjects");
        ListPublishedObjectsRequest interceptedRequest = ListPublishedObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublishedObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublishedObjectsResponse> transformer = ListPublishedObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPublishedObjectsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPublishedObjectsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPublishedObjectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListReferencesResponse listReferences(ListReferencesRequest request) {
        LOG.trace("Called listReferences");
        ListReferencesRequest interceptedRequest = ListReferencesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReferencesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReferencesResponse> transformer = ListReferencesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListReferencesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListReferencesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListReferencesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSchemasResponse listSchemas(ListSchemasRequest request) {
        LOG.trace("Called listSchemas");
        ListSchemasRequest interceptedRequest = ListSchemasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSchemasConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSchemasResponse> transformer = ListSchemasConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSchemasResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSchemasResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSchemasResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaskRunLogsResponse listTaskRunLogs(ListTaskRunLogsRequest request) {
        LOG.trace("Called listTaskRunLogs");
        ListTaskRunLogsRequest interceptedRequest = ListTaskRunLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskRunLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaskRunLogsResponse> transformer = ListTaskRunLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaskRunLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaskRunLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaskRunLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaskRunsResponse listTaskRuns(ListTaskRunsRequest request) {
        LOG.trace("Called listTaskRuns");
        ListTaskRunsRequest interceptedRequest = ListTaskRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaskRunsResponse> transformer = ListTaskRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaskRunsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaskRunsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaskRunsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTaskValidationsResponse listTaskValidations(ListTaskValidationsRequest request) {
        LOG.trace("Called listTaskValidations");
        ListTaskValidationsRequest interceptedRequest = ListTaskValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTaskValidationsResponse> transformer = ListTaskValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTaskValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTaskValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTaskValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTasksResponse listTasks(ListTasksRequest request) {
        LOG.trace("Called listTasks");
        ListTasksRequest interceptedRequest = ListTasksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTasksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTasksResponse> transformer = ListTasksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTasksResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTasksResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTasksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkspacesResponse listWorkspaces(ListWorkspacesRequest request) {
        LOG.trace("Called listWorkspaces");
        ListWorkspacesRequest interceptedRequest = ListWorkspacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkspacesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkspacesResponse> transformer = ListWorkspacesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkspacesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkspacesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkspacesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartWorkspaceResponse startWorkspace(StartWorkspaceRequest request) {
        LOG.trace("Called startWorkspace");
        StartWorkspaceRequest interceptedRequest = StartWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartWorkspaceResponse> transformer = StartWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StartWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StartWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StartWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopWorkspaceResponse stopWorkspace(StopWorkspaceRequest request) {
        LOG.trace("Called stopWorkspace");
        StopWorkspaceRequest interceptedRequest = StopWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopWorkspaceResponse> transformer = StopWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (StopWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (StopWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (StopWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest request) {
        LOG.trace("Called updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateApplicationDetails(), (BmcRequest)retriedRequest);
                return (UpdateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        LOG.trace("Called updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateConnectionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConnectionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConnectionDetails(), (BmcRequest)retriedRequest);
                return (UpdateConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDataAssetResponse updateDataAsset(UpdateDataAssetRequest request) {
        LOG.trace("Called updateDataAsset");
        UpdateDataAssetRequest interceptedRequest = UpdateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDataAssetResponse> transformer = UpdateDataAssetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDataAssetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDataAssetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDataAssetDetails(), (BmcRequest)retriedRequest);
                return (UpdateDataAssetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDataFlowResponse updateDataFlow(UpdateDataFlowRequest request) {
        LOG.trace("Called updateDataFlow");
        UpdateDataFlowRequest interceptedRequest = UpdateDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataFlowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDataFlowResponse> transformer = UpdateDataFlowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDataFlowResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDataFlowResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDataFlowDetails(), (BmcRequest)retriedRequest);
                return (UpdateDataFlowResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateExternalPublicationResponse updateExternalPublication(UpdateExternalPublicationRequest request) {
        LOG.trace("Called updateExternalPublication");
        UpdateExternalPublicationRequest interceptedRequest = UpdateExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExternalPublicationResponse> transformer = UpdateExternalPublicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateExternalPublicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateExternalPublicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateExternalPublicationDetails(), (BmcRequest)retriedRequest);
                return (UpdateExternalPublicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest request) {
        LOG.trace("Called updateFolder");
        UpdateFolderRequest interceptedRequest = UpdateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFolderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateFolderResponse> transformer = UpdateFolderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateFolderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateFolderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateFolderDetails(), (BmcRequest)retriedRequest);
                return (UpdateFolderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest request) {
        LOG.trace("Called updatePipeline");
        UpdatePipelineRequest interceptedRequest = UpdatePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePipelineConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePipelineResponse> transformer = UpdatePipelineConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdatePipelineResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePipelineResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePipelineDetails(), (BmcRequest)retriedRequest);
                return (UpdatePipelineResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        LOG.trace("Called updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateProjectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProjectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProjectDetails(), (BmcRequest)retriedRequest);
                return (UpdateProjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateReferenceResponse updateReference(UpdateReferenceRequest request) {
        LOG.trace("Called updateReference");
        UpdateReferenceRequest interceptedRequest = UpdateReferenceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateReferenceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateReferenceResponse> transformer = UpdateReferenceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateReferenceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateReferenceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateReferenceDetails(), (BmcRequest)retriedRequest);
                return (UpdateReferenceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTaskResponse updateTask(UpdateTaskRequest request) {
        LOG.trace("Called updateTask");
        UpdateTaskRequest interceptedRequest = UpdateTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTaskResponse> transformer = UpdateTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTaskDetails(), (BmcRequest)retriedRequest);
                return (UpdateTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTaskRunResponse updateTaskRun(UpdateTaskRunRequest request) {
        LOG.trace("Called updateTaskRun");
        UpdateTaskRunRequest interceptedRequest = UpdateTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTaskRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTaskRunResponse> transformer = UpdateTaskRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTaskRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTaskRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTaskRunDetails(), (BmcRequest)retriedRequest);
                return (UpdateTaskRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest request) {
        LOG.trace("Called updateWorkspace");
        UpdateWorkspaceRequest interceptedRequest = UpdateWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWorkspaceResponse> transformer = UpdateWorkspaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateWorkspaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWorkspaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateWorkspaceDetails(), (BmcRequest)retriedRequest);
                return (UpdateWorkspaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DataIntegrationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataIntegrationPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataIntegrationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataIntegrationClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataIntegrationClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

