/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.dataintegration.DataIntegration;
import com.oracle.bmc.dataintegration.model.ApplicationSummary;
import com.oracle.bmc.dataintegration.model.ConnectionSummary;
import com.oracle.bmc.dataintegration.model.ConnectionValidationSummary;
import com.oracle.bmc.dataintegration.model.DataAssetSummary;
import com.oracle.bmc.dataintegration.model.DataEntitySummary;
import com.oracle.bmc.dataintegration.model.DataFlowSummary;
import com.oracle.bmc.dataintegration.model.DataFlowValidationSummary;
import com.oracle.bmc.dataintegration.model.DependentObjectSummary;
import com.oracle.bmc.dataintegration.model.ExternalPublicationSummary;
import com.oracle.bmc.dataintegration.model.ExternalPublicationValidationSummary;
import com.oracle.bmc.dataintegration.model.FolderSummary;
import com.oracle.bmc.dataintegration.model.PatchChangeSummary;
import com.oracle.bmc.dataintegration.model.PatchSummary;
import com.oracle.bmc.dataintegration.model.PipelineSummary;
import com.oracle.bmc.dataintegration.model.PipelineValidationSummary;
import com.oracle.bmc.dataintegration.model.ProjectSummary;
import com.oracle.bmc.dataintegration.model.PublishedObjectSummary;
import com.oracle.bmc.dataintegration.model.ReferenceSummary;
import com.oracle.bmc.dataintegration.model.SchemaSummary;
import com.oracle.bmc.dataintegration.model.TaskRunLogSummary;
import com.oracle.bmc.dataintegration.model.TaskRunSummary;
import com.oracle.bmc.dataintegration.model.TaskSummary;
import com.oracle.bmc.dataintegration.model.TaskValidationSummary;
import com.oracle.bmc.dataintegration.model.WorkRequestError;
import com.oracle.bmc.dataintegration.model.WorkRequestLogEntry;
import com.oracle.bmc.dataintegration.model.WorkRequestSummary;
import com.oracle.bmc.dataintegration.model.WorkspaceSummary;
import com.oracle.bmc.dataintegration.requests.ListApplicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowsRequest;
import com.oracle.bmc.dataintegration.requests.ListDependentObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListFoldersRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchChangesRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchesRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelineValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelinesRequest;
import com.oracle.bmc.dataintegration.requests.ListProjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListPublishedObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListReferencesRequest;
import com.oracle.bmc.dataintegration.requests.ListSchemasRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListTasksRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkspacesRequest;
import com.oracle.bmc.dataintegration.responses.ListApplicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowsResponse;
import com.oracle.bmc.dataintegration.responses.ListDependentObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListFoldersResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchesResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelineValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelinesResponse;
import com.oracle.bmc.dataintegration.responses.ListProjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListPublishedObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListReferencesResponse;
import com.oracle.bmc.dataintegration.responses.ListSchemasResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListTasksResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkspacesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DataIntegrationPaginators {
    private final DataIntegration client;

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataIntegrationPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataIntegrationPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getApplicationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListConnectionValidationsResponse> listConnectionValidationsResponseIterator(final ListConnectionValidationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionValidationsRequest.Builder>(){

            public ListConnectionValidationsRequest.Builder get() {
                return ListConnectionValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionValidationsResponse, String>(){

            public String apply(ListConnectionValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionValidationsRequest.Builder>, ListConnectionValidationsRequest>(){

            public ListConnectionValidationsRequest apply(RequestBuilderAndToken<ListConnectionValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConnectionValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConnectionValidationsRequest, ListConnectionValidationsResponse>(){

            public ListConnectionValidationsResponse apply(ListConnectionValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listConnectionValidations(request);
            }
        });
    }

    public Iterable<ConnectionValidationSummary> listConnectionValidationsRecordIterator(final ListConnectionValidationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionValidationsRequest.Builder>(){

            public ListConnectionValidationsRequest.Builder get() {
                return ListConnectionValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionValidationsResponse, String>(){

            public String apply(ListConnectionValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionValidationsRequest.Builder>, ListConnectionValidationsRequest>(){

            public ListConnectionValidationsRequest apply(RequestBuilderAndToken<ListConnectionValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConnectionValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConnectionValidationsRequest, ListConnectionValidationsResponse>(){

            public ListConnectionValidationsResponse apply(ListConnectionValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listConnectionValidations(request);
            }
        }, (Function)new Function<ListConnectionValidationsResponse, List<ConnectionValidationSummary>>(){

            public List<ConnectionValidationSummary> apply(ListConnectionValidationsResponse response) {
                return response.getConnectionValidationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListConnectionsResponse> listConnectionsResponseIterator(final ListConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DataIntegrationPaginators.this.client.listConnections(request);
            }
        });
    }

    public Iterable<ConnectionSummary> listConnectionsRecordIterator(final ListConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConnectionsRequest.Builder>(){

            public ListConnectionsRequest.Builder get() {
                return ListConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConnectionsResponse, String>(){

            public String apply(ListConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConnectionsRequest.Builder>, ListConnectionsRequest>(){

            public ListConnectionsRequest apply(RequestBuilderAndToken<ListConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConnectionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListConnectionsRequest, ListConnectionsResponse>(){

            public ListConnectionsResponse apply(ListConnectionsRequest request) {
                return DataIntegrationPaginators.this.client.listConnections(request);
            }
        }, (Function)new Function<ListConnectionsResponse, List<ConnectionSummary>>(){

            public List<ConnectionSummary> apply(ListConnectionsResponse response) {
                return response.getConnectionSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataAssetsResponse> listDataAssetsResponseIterator(final ListDataAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return DataIntegrationPaginators.this.client.listDataAssets(request);
            }
        });
    }

    public Iterable<DataAssetSummary> listDataAssetsRecordIterator(final ListDataAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return DataIntegrationPaginators.this.client.listDataAssets(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, List<DataAssetSummary>>(){

            public List<DataAssetSummary> apply(ListDataAssetsResponse response) {
                return response.getDataAssetSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataEntitiesResponse> listDataEntitiesResponseIterator(final ListDataEntitiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataEntitiesRequest.Builder>(){

            public ListDataEntitiesRequest.Builder get() {
                return ListDataEntitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, String>(){

            public String apply(ListDataEntitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataEntitiesRequest.Builder>, ListDataEntitiesRequest>(){

            public ListDataEntitiesRequest apply(RequestBuilderAndToken<ListDataEntitiesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataEntitiesRequest, ListDataEntitiesResponse>(){

            public ListDataEntitiesResponse apply(ListDataEntitiesRequest request) {
                return DataIntegrationPaginators.this.client.listDataEntities(request);
            }
        });
    }

    public Iterable<DataEntitySummary> listDataEntitiesRecordIterator(final ListDataEntitiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataEntitiesRequest.Builder>(){

            public ListDataEntitiesRequest.Builder get() {
                return ListDataEntitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, String>(){

            public String apply(ListDataEntitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataEntitiesRequest.Builder>, ListDataEntitiesRequest>(){

            public ListDataEntitiesRequest apply(RequestBuilderAndToken<ListDataEntitiesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataEntitiesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataEntitiesRequest, ListDataEntitiesResponse>(){

            public ListDataEntitiesResponse apply(ListDataEntitiesRequest request) {
                return DataIntegrationPaginators.this.client.listDataEntities(request);
            }
        }, (Function)new Function<ListDataEntitiesResponse, List<DataEntitySummary>>(){

            public List<DataEntitySummary> apply(ListDataEntitiesResponse response) {
                return response.getDataEntitySummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataFlowValidationsResponse> listDataFlowValidationsResponseIterator(final ListDataFlowValidationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataFlowValidationsRequest.Builder>(){

            public ListDataFlowValidationsRequest.Builder get() {
                return ListDataFlowValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataFlowValidationsResponse, String>(){

            public String apply(ListDataFlowValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataFlowValidationsRequest.Builder>, ListDataFlowValidationsRequest>(){

            public ListDataFlowValidationsRequest apply(RequestBuilderAndToken<ListDataFlowValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataFlowValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataFlowValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse>(){

            public ListDataFlowValidationsResponse apply(ListDataFlowValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listDataFlowValidations(request);
            }
        });
    }

    public Iterable<DataFlowValidationSummary> listDataFlowValidationsRecordIterator(final ListDataFlowValidationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataFlowValidationsRequest.Builder>(){

            public ListDataFlowValidationsRequest.Builder get() {
                return ListDataFlowValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataFlowValidationsResponse, String>(){

            public String apply(ListDataFlowValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataFlowValidationsRequest.Builder>, ListDataFlowValidationsRequest>(){

            public ListDataFlowValidationsRequest apply(RequestBuilderAndToken<ListDataFlowValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataFlowValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataFlowValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse>(){

            public ListDataFlowValidationsResponse apply(ListDataFlowValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listDataFlowValidations(request);
            }
        }, (Function)new Function<ListDataFlowValidationsResponse, List<DataFlowValidationSummary>>(){

            public List<DataFlowValidationSummary> apply(ListDataFlowValidationsResponse response) {
                return response.getDataFlowValidationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDataFlowsResponse> listDataFlowsResponseIterator(final ListDataFlowsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataFlowsRequest.Builder>(){

            public ListDataFlowsRequest.Builder get() {
                return ListDataFlowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataFlowsResponse, String>(){

            public String apply(ListDataFlowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataFlowsRequest.Builder>, ListDataFlowsRequest>(){

            public ListDataFlowsRequest apply(RequestBuilderAndToken<ListDataFlowsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataFlowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataFlowsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataFlowsRequest, ListDataFlowsResponse>(){

            public ListDataFlowsResponse apply(ListDataFlowsRequest request) {
                return DataIntegrationPaginators.this.client.listDataFlows(request);
            }
        });
    }

    public Iterable<DataFlowSummary> listDataFlowsRecordIterator(final ListDataFlowsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataFlowsRequest.Builder>(){

            public ListDataFlowsRequest.Builder get() {
                return ListDataFlowsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataFlowsResponse, String>(){

            public String apply(ListDataFlowsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataFlowsRequest.Builder>, ListDataFlowsRequest>(){

            public ListDataFlowsRequest apply(RequestBuilderAndToken<ListDataFlowsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataFlowsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataFlowsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataFlowsRequest, ListDataFlowsResponse>(){

            public ListDataFlowsResponse apply(ListDataFlowsRequest request) {
                return DataIntegrationPaginators.this.client.listDataFlows(request);
            }
        }, (Function)new Function<ListDataFlowsResponse, List<DataFlowSummary>>(){

            public List<DataFlowSummary> apply(ListDataFlowsResponse response) {
                return response.getDataFlowSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListDependentObjectsResponse> listDependentObjectsResponseIterator(final ListDependentObjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDependentObjectsRequest.Builder>(){

            public ListDependentObjectsRequest.Builder get() {
                return ListDependentObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDependentObjectsResponse, String>(){

            public String apply(ListDependentObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDependentObjectsRequest.Builder>, ListDependentObjectsRequest>(){

            public ListDependentObjectsRequest apply(RequestBuilderAndToken<ListDependentObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDependentObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDependentObjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDependentObjectsRequest, ListDependentObjectsResponse>(){

            public ListDependentObjectsResponse apply(ListDependentObjectsRequest request) {
                return DataIntegrationPaginators.this.client.listDependentObjects(request);
            }
        });
    }

    public Iterable<DependentObjectSummary> listDependentObjectsRecordIterator(final ListDependentObjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDependentObjectsRequest.Builder>(){

            public ListDependentObjectsRequest.Builder get() {
                return ListDependentObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDependentObjectsResponse, String>(){

            public String apply(ListDependentObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDependentObjectsRequest.Builder>, ListDependentObjectsRequest>(){

            public ListDependentObjectsRequest apply(RequestBuilderAndToken<ListDependentObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDependentObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDependentObjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDependentObjectsRequest, ListDependentObjectsResponse>(){

            public ListDependentObjectsResponse apply(ListDependentObjectsRequest request) {
                return DataIntegrationPaginators.this.client.listDependentObjects(request);
            }
        }, (Function)new Function<ListDependentObjectsResponse, List<DependentObjectSummary>>(){

            public List<DependentObjectSummary> apply(ListDependentObjectsResponse response) {
                return response.getDependentObjectSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListExternalPublicationValidationsResponse> listExternalPublicationValidationsResponseIterator(final ListExternalPublicationValidationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExternalPublicationValidationsRequest.Builder>(){

            public ListExternalPublicationValidationsRequest.Builder get() {
                return ListExternalPublicationValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExternalPublicationValidationsResponse, String>(){

            public String apply(ListExternalPublicationValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExternalPublicationValidationsRequest.Builder>, ListExternalPublicationValidationsRequest>(){

            public ListExternalPublicationValidationsRequest apply(RequestBuilderAndToken<ListExternalPublicationValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExternalPublicationValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExternalPublicationValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse>(){

            public ListExternalPublicationValidationsResponse apply(ListExternalPublicationValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listExternalPublicationValidations(request);
            }
        });
    }

    public Iterable<ExternalPublicationValidationSummary> listExternalPublicationValidationsRecordIterator(final ListExternalPublicationValidationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExternalPublicationValidationsRequest.Builder>(){

            public ListExternalPublicationValidationsRequest.Builder get() {
                return ListExternalPublicationValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExternalPublicationValidationsResponse, String>(){

            public String apply(ListExternalPublicationValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExternalPublicationValidationsRequest.Builder>, ListExternalPublicationValidationsRequest>(){

            public ListExternalPublicationValidationsRequest apply(RequestBuilderAndToken<ListExternalPublicationValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExternalPublicationValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExternalPublicationValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse>(){

            public ListExternalPublicationValidationsResponse apply(ListExternalPublicationValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listExternalPublicationValidations(request);
            }
        }, (Function)new Function<ListExternalPublicationValidationsResponse, List<ExternalPublicationValidationSummary>>(){

            public List<ExternalPublicationValidationSummary> apply(ListExternalPublicationValidationsResponse response) {
                return response.getExternalPublicationValidationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListExternalPublicationsResponse> listExternalPublicationsResponseIterator(final ListExternalPublicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExternalPublicationsRequest.Builder>(){

            public ListExternalPublicationsRequest.Builder get() {
                return ListExternalPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExternalPublicationsResponse, String>(){

            public String apply(ListExternalPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExternalPublicationsRequest.Builder>, ListExternalPublicationsRequest>(){

            public ListExternalPublicationsRequest apply(RequestBuilderAndToken<ListExternalPublicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExternalPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExternalPublicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExternalPublicationsRequest, ListExternalPublicationsResponse>(){

            public ListExternalPublicationsResponse apply(ListExternalPublicationsRequest request) {
                return DataIntegrationPaginators.this.client.listExternalPublications(request);
            }
        });
    }

    public Iterable<ExternalPublicationSummary> listExternalPublicationsRecordIterator(final ListExternalPublicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExternalPublicationsRequest.Builder>(){

            public ListExternalPublicationsRequest.Builder get() {
                return ListExternalPublicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExternalPublicationsResponse, String>(){

            public String apply(ListExternalPublicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExternalPublicationsRequest.Builder>, ListExternalPublicationsRequest>(){

            public ListExternalPublicationsRequest apply(RequestBuilderAndToken<ListExternalPublicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExternalPublicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExternalPublicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExternalPublicationsRequest, ListExternalPublicationsResponse>(){

            public ListExternalPublicationsResponse apply(ListExternalPublicationsRequest request) {
                return DataIntegrationPaginators.this.client.listExternalPublications(request);
            }
        }, (Function)new Function<ListExternalPublicationsResponse, List<ExternalPublicationSummary>>(){

            public List<ExternalPublicationSummary> apply(ListExternalPublicationsResponse response) {
                return response.getExternalPublicationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListFoldersResponse> listFoldersResponseIterator(final ListFoldersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFoldersRequest.Builder>(){

            public ListFoldersRequest.Builder get() {
                return ListFoldersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFoldersResponse, String>(){

            public String apply(ListFoldersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFoldersRequest.Builder>, ListFoldersRequest>(){

            public ListFoldersRequest apply(RequestBuilderAndToken<ListFoldersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListFoldersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFoldersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListFoldersRequest, ListFoldersResponse>(){

            public ListFoldersResponse apply(ListFoldersRequest request) {
                return DataIntegrationPaginators.this.client.listFolders(request);
            }
        });
    }

    public Iterable<FolderSummary> listFoldersRecordIterator(final ListFoldersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFoldersRequest.Builder>(){

            public ListFoldersRequest.Builder get() {
                return ListFoldersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFoldersResponse, String>(){

            public String apply(ListFoldersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFoldersRequest.Builder>, ListFoldersRequest>(){

            public ListFoldersRequest apply(RequestBuilderAndToken<ListFoldersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListFoldersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFoldersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListFoldersRequest, ListFoldersResponse>(){

            public ListFoldersResponse apply(ListFoldersRequest request) {
                return DataIntegrationPaginators.this.client.listFolders(request);
            }
        }, (Function)new Function<ListFoldersResponse, List<FolderSummary>>(){

            public List<FolderSummary> apply(ListFoldersResponse response) {
                return response.getFolderSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListPatchChangesResponse> listPatchChangesResponseIterator(final ListPatchChangesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPatchChangesRequest.Builder>(){

            public ListPatchChangesRequest.Builder get() {
                return ListPatchChangesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchChangesResponse, String>(){

            public String apply(ListPatchChangesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchChangesRequest.Builder>, ListPatchChangesRequest>(){

            public ListPatchChangesRequest apply(RequestBuilderAndToken<ListPatchChangesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPatchChangesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchChangesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPatchChangesRequest, ListPatchChangesResponse>(){

            public ListPatchChangesResponse apply(ListPatchChangesRequest request) {
                return DataIntegrationPaginators.this.client.listPatchChanges(request);
            }
        });
    }

    public Iterable<PatchChangeSummary> listPatchChangesRecordIterator(final ListPatchChangesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPatchChangesRequest.Builder>(){

            public ListPatchChangesRequest.Builder get() {
                return ListPatchChangesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchChangesResponse, String>(){

            public String apply(ListPatchChangesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchChangesRequest.Builder>, ListPatchChangesRequest>(){

            public ListPatchChangesRequest apply(RequestBuilderAndToken<ListPatchChangesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPatchChangesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchChangesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPatchChangesRequest, ListPatchChangesResponse>(){

            public ListPatchChangesResponse apply(ListPatchChangesRequest request) {
                return DataIntegrationPaginators.this.client.listPatchChanges(request);
            }
        }, (Function)new Function<ListPatchChangesResponse, List<PatchChangeSummary>>(){

            public List<PatchChangeSummary> apply(ListPatchChangesResponse response) {
                return response.getPatchChangeSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListPatchesResponse> listPatchesResponseIterator(final ListPatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            public ListPatchesResponse apply(ListPatchesRequest request) {
                return DataIntegrationPaginators.this.client.listPatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listPatchesRecordIterator(final ListPatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPatchesRequest.Builder>(){

            public ListPatchesRequest.Builder get() {
                return ListPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPatchesResponse, String>(){

            public String apply(ListPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPatchesRequest.Builder>, ListPatchesRequest>(){

            public ListPatchesRequest apply(RequestBuilderAndToken<ListPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPatchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPatchesRequest, ListPatchesResponse>(){

            public ListPatchesResponse apply(ListPatchesRequest request) {
                return DataIntegrationPaginators.this.client.listPatches(request);
            }
        }, (Function)new Function<ListPatchesResponse, List<PatchSummary>>(){

            public List<PatchSummary> apply(ListPatchesResponse response) {
                return response.getPatchSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListPipelineValidationsResponse> listPipelineValidationsResponseIterator(final ListPipelineValidationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPipelineValidationsRequest.Builder>(){

            public ListPipelineValidationsRequest.Builder get() {
                return ListPipelineValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPipelineValidationsResponse, String>(){

            public String apply(ListPipelineValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPipelineValidationsRequest.Builder>, ListPipelineValidationsRequest>(){

            public ListPipelineValidationsRequest apply(RequestBuilderAndToken<ListPipelineValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPipelineValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPipelineValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPipelineValidationsRequest, ListPipelineValidationsResponse>(){

            public ListPipelineValidationsResponse apply(ListPipelineValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listPipelineValidations(request);
            }
        });
    }

    public Iterable<PipelineValidationSummary> listPipelineValidationsRecordIterator(final ListPipelineValidationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPipelineValidationsRequest.Builder>(){

            public ListPipelineValidationsRequest.Builder get() {
                return ListPipelineValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPipelineValidationsResponse, String>(){

            public String apply(ListPipelineValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPipelineValidationsRequest.Builder>, ListPipelineValidationsRequest>(){

            public ListPipelineValidationsRequest apply(RequestBuilderAndToken<ListPipelineValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPipelineValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPipelineValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPipelineValidationsRequest, ListPipelineValidationsResponse>(){

            public ListPipelineValidationsResponse apply(ListPipelineValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listPipelineValidations(request);
            }
        }, (Function)new Function<ListPipelineValidationsResponse, List<PipelineValidationSummary>>(){

            public List<PipelineValidationSummary> apply(ListPipelineValidationsResponse response) {
                return response.getPipelineValidationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListPipelinesResponse> listPipelinesResponseIterator(final ListPipelinesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPipelinesRequest.Builder>(){

            public ListPipelinesRequest.Builder get() {
                return ListPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPipelinesResponse, String>(){

            public String apply(ListPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPipelinesRequest.Builder>, ListPipelinesRequest>(){

            public ListPipelinesRequest apply(RequestBuilderAndToken<ListPipelinesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPipelinesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPipelinesRequest, ListPipelinesResponse>(){

            public ListPipelinesResponse apply(ListPipelinesRequest request) {
                return DataIntegrationPaginators.this.client.listPipelines(request);
            }
        });
    }

    public Iterable<PipelineSummary> listPipelinesRecordIterator(final ListPipelinesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPipelinesRequest.Builder>(){

            public ListPipelinesRequest.Builder get() {
                return ListPipelinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPipelinesResponse, String>(){

            public String apply(ListPipelinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPipelinesRequest.Builder>, ListPipelinesRequest>(){

            public ListPipelinesRequest apply(RequestBuilderAndToken<ListPipelinesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPipelinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPipelinesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPipelinesRequest, ListPipelinesResponse>(){

            public ListPipelinesResponse apply(ListPipelinesRequest request) {
                return DataIntegrationPaginators.this.client.listPipelines(request);
            }
        }, (Function)new Function<ListPipelinesResponse, List<PipelineSummary>>(){

            public List<PipelineSummary> apply(ListPipelinesResponse response) {
                return response.getPipelineSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DataIntegrationPaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            public ListProjectsResponse apply(ListProjectsRequest request) {
                return DataIntegrationPaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getProjectSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListPublishedObjectsResponse> listPublishedObjectsResponseIterator(final ListPublishedObjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPublishedObjectsRequest.Builder>(){

            public ListPublishedObjectsRequest.Builder get() {
                return ListPublishedObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishedObjectsResponse, String>(){

            public String apply(ListPublishedObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishedObjectsRequest.Builder>, ListPublishedObjectsRequest>(){

            public ListPublishedObjectsRequest apply(RequestBuilderAndToken<ListPublishedObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublishedObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishedObjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublishedObjectsRequest, ListPublishedObjectsResponse>(){

            public ListPublishedObjectsResponse apply(ListPublishedObjectsRequest request) {
                return DataIntegrationPaginators.this.client.listPublishedObjects(request);
            }
        });
    }

    public Iterable<PublishedObjectSummary> listPublishedObjectsRecordIterator(final ListPublishedObjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPublishedObjectsRequest.Builder>(){

            public ListPublishedObjectsRequest.Builder get() {
                return ListPublishedObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPublishedObjectsResponse, String>(){

            public String apply(ListPublishedObjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPublishedObjectsRequest.Builder>, ListPublishedObjectsRequest>(){

            public ListPublishedObjectsRequest apply(RequestBuilderAndToken<ListPublishedObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPublishedObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPublishedObjectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPublishedObjectsRequest, ListPublishedObjectsResponse>(){

            public ListPublishedObjectsResponse apply(ListPublishedObjectsRequest request) {
                return DataIntegrationPaginators.this.client.listPublishedObjects(request);
            }
        }, (Function)new Function<ListPublishedObjectsResponse, List<PublishedObjectSummary>>(){

            public List<PublishedObjectSummary> apply(ListPublishedObjectsResponse response) {
                return response.getPublishedObjectSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListReferencesResponse> listReferencesResponseIterator(final ListReferencesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReferencesRequest.Builder>(){

            public ListReferencesRequest.Builder get() {
                return ListReferencesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReferencesResponse, String>(){

            public String apply(ListReferencesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReferencesRequest.Builder>, ListReferencesRequest>(){

            public ListReferencesRequest apply(RequestBuilderAndToken<ListReferencesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReferencesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReferencesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReferencesRequest, ListReferencesResponse>(){

            public ListReferencesResponse apply(ListReferencesRequest request) {
                return DataIntegrationPaginators.this.client.listReferences(request);
            }
        });
    }

    public Iterable<ReferenceSummary> listReferencesRecordIterator(final ListReferencesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReferencesRequest.Builder>(){

            public ListReferencesRequest.Builder get() {
                return ListReferencesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReferencesResponse, String>(){

            public String apply(ListReferencesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReferencesRequest.Builder>, ListReferencesRequest>(){

            public ListReferencesRequest apply(RequestBuilderAndToken<ListReferencesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReferencesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReferencesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReferencesRequest, ListReferencesResponse>(){

            public ListReferencesResponse apply(ListReferencesRequest request) {
                return DataIntegrationPaginators.this.client.listReferences(request);
            }
        }, (Function)new Function<ListReferencesResponse, List<ReferenceSummary>>(){

            public List<ReferenceSummary> apply(ListReferencesResponse response) {
                return response.getReferenceSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListSchemasResponse> listSchemasResponseIterator(final ListSchemasRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchemasRequest.Builder>(){

            public ListSchemasRequest.Builder get() {
                return ListSchemasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchemasResponse, String>(){

            public String apply(ListSchemasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchemasRequest.Builder>, ListSchemasRequest>(){

            public ListSchemasRequest apply(RequestBuilderAndToken<ListSchemasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSchemasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchemasRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSchemasRequest, ListSchemasResponse>(){

            public ListSchemasResponse apply(ListSchemasRequest request) {
                return DataIntegrationPaginators.this.client.listSchemas(request);
            }
        });
    }

    public Iterable<SchemaSummary> listSchemasRecordIterator(final ListSchemasRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchemasRequest.Builder>(){

            public ListSchemasRequest.Builder get() {
                return ListSchemasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchemasResponse, String>(){

            public String apply(ListSchemasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchemasRequest.Builder>, ListSchemasRequest>(){

            public ListSchemasRequest apply(RequestBuilderAndToken<ListSchemasRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSchemasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchemasRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSchemasRequest, ListSchemasResponse>(){

            public ListSchemasResponse apply(ListSchemasRequest request) {
                return DataIntegrationPaginators.this.client.listSchemas(request);
            }
        }, (Function)new Function<ListSchemasResponse, List<SchemaSummary>>(){

            public List<SchemaSummary> apply(ListSchemasResponse response) {
                return response.getSchemaSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListTaskRunLogsResponse> listTaskRunLogsResponseIterator(final ListTaskRunLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTaskRunLogsRequest.Builder>(){

            public ListTaskRunLogsRequest.Builder get() {
                return ListTaskRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRunLogsResponse, String>(){

            public String apply(ListTaskRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRunLogsRequest.Builder>, ListTaskRunLogsRequest>(){

            public ListTaskRunLogsRequest apply(RequestBuilderAndToken<ListTaskRunLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRunLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskRunLogsRequest, ListTaskRunLogsResponse>(){

            public ListTaskRunLogsResponse apply(ListTaskRunLogsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskRunLogs(request);
            }
        });
    }

    public Iterable<TaskRunLogSummary> listTaskRunLogsRecordIterator(final ListTaskRunLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTaskRunLogsRequest.Builder>(){

            public ListTaskRunLogsRequest.Builder get() {
                return ListTaskRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRunLogsResponse, String>(){

            public String apply(ListTaskRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRunLogsRequest.Builder>, ListTaskRunLogsRequest>(){

            public ListTaskRunLogsRequest apply(RequestBuilderAndToken<ListTaskRunLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRunLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskRunLogsRequest, ListTaskRunLogsResponse>(){

            public ListTaskRunLogsResponse apply(ListTaskRunLogsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskRunLogs(request);
            }
        }, (Function)new Function<ListTaskRunLogsResponse, List<TaskRunLogSummary>>(){

            public List<TaskRunLogSummary> apply(ListTaskRunLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTaskRunsResponse> listTaskRunsResponseIterator(final ListTaskRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTaskRunsRequest.Builder>(){

            public ListTaskRunsRequest.Builder get() {
                return ListTaskRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRunsResponse, String>(){

            public String apply(ListTaskRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRunsRequest.Builder>, ListTaskRunsRequest>(){

            public ListTaskRunsRequest apply(RequestBuilderAndToken<ListTaskRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskRunsRequest, ListTaskRunsResponse>(){

            public ListTaskRunsResponse apply(ListTaskRunsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskRuns(request);
            }
        });
    }

    public Iterable<TaskRunSummary> listTaskRunsRecordIterator(final ListTaskRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTaskRunsRequest.Builder>(){

            public ListTaskRunsRequest.Builder get() {
                return ListTaskRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskRunsResponse, String>(){

            public String apply(ListTaskRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskRunsRequest.Builder>, ListTaskRunsRequest>(){

            public ListTaskRunsRequest apply(RequestBuilderAndToken<ListTaskRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskRunsRequest, ListTaskRunsResponse>(){

            public ListTaskRunsResponse apply(ListTaskRunsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskRuns(request);
            }
        }, (Function)new Function<ListTaskRunsResponse, List<TaskRunSummary>>(){

            public List<TaskRunSummary> apply(ListTaskRunsResponse response) {
                return response.getTaskRunSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListTaskValidationsResponse> listTaskValidationsResponseIterator(final ListTaskValidationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTaskValidationsRequest.Builder>(){

            public ListTaskValidationsRequest.Builder get() {
                return ListTaskValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskValidationsResponse, String>(){

            public String apply(ListTaskValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskValidationsRequest.Builder>, ListTaskValidationsRequest>(){

            public ListTaskValidationsRequest apply(RequestBuilderAndToken<ListTaskValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskValidationsRequest, ListTaskValidationsResponse>(){

            public ListTaskValidationsResponse apply(ListTaskValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskValidations(request);
            }
        });
    }

    public Iterable<TaskValidationSummary> listTaskValidationsRecordIterator(final ListTaskValidationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTaskValidationsRequest.Builder>(){

            public ListTaskValidationsRequest.Builder get() {
                return ListTaskValidationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTaskValidationsResponse, String>(){

            public String apply(ListTaskValidationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTaskValidationsRequest.Builder>, ListTaskValidationsRequest>(){

            public ListTaskValidationsRequest apply(RequestBuilderAndToken<ListTaskValidationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTaskValidationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTaskValidationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTaskValidationsRequest, ListTaskValidationsResponse>(){

            public ListTaskValidationsResponse apply(ListTaskValidationsRequest request) {
                return DataIntegrationPaginators.this.client.listTaskValidations(request);
            }
        }, (Function)new Function<ListTaskValidationsResponse, List<TaskValidationSummary>>(){

            public List<TaskValidationSummary> apply(ListTaskValidationsResponse response) {
                return response.getTaskValidationSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListTasksResponse> listTasksResponseIterator(final ListTasksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTasksRequest.Builder>(){

            public ListTasksRequest.Builder get() {
                return ListTasksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTasksResponse, String>(){

            public String apply(ListTasksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTasksRequest.Builder>, ListTasksRequest>(){

            public ListTasksRequest apply(RequestBuilderAndToken<ListTasksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTasksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTasksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTasksRequest, ListTasksResponse>(){

            public ListTasksResponse apply(ListTasksRequest request) {
                return DataIntegrationPaginators.this.client.listTasks(request);
            }
        });
    }

    public Iterable<TaskSummary> listTasksRecordIterator(final ListTasksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTasksRequest.Builder>(){

            public ListTasksRequest.Builder get() {
                return ListTasksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTasksResponse, String>(){

            public String apply(ListTasksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTasksRequest.Builder>, ListTasksRequest>(){

            public ListTasksRequest apply(RequestBuilderAndToken<ListTasksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListTasksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTasksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListTasksRequest, ListTasksResponse>(){

            public ListTasksResponse apply(ListTasksRequest request) {
                return DataIntegrationPaginators.this.client.listTasks(request);
            }
        }, (Function)new Function<ListTasksResponse, List<TaskSummary>>(){

            public List<TaskSummary> apply(ListTasksResponse response) {
                return response.getTaskSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataIntegrationPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkspacesResponse> listWorkspacesResponseIterator(final ListWorkspacesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkspacesRequest.Builder>(){

            public ListWorkspacesRequest.Builder get() {
                return ListWorkspacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkspacesResponse, String>(){

            public String apply(ListWorkspacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkspacesRequest.Builder>, ListWorkspacesRequest>(){

            public ListWorkspacesRequest apply(RequestBuilderAndToken<ListWorkspacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkspacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkspacesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkspacesRequest, ListWorkspacesResponse>(){

            public ListWorkspacesResponse apply(ListWorkspacesRequest request) {
                return DataIntegrationPaginators.this.client.listWorkspaces(request);
            }
        });
    }

    public Iterable<WorkspaceSummary> listWorkspacesRecordIterator(final ListWorkspacesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkspacesRequest.Builder>(){

            public ListWorkspacesRequest.Builder get() {
                return ListWorkspacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkspacesResponse, String>(){

            public String apply(ListWorkspacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkspacesRequest.Builder>, ListWorkspacesRequest>(){

            public ListWorkspacesRequest apply(RequestBuilderAndToken<ListWorkspacesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkspacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkspacesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkspacesRequest, ListWorkspacesResponse>(){

            public ListWorkspacesResponse apply(ListWorkspacesRequest request) {
                return DataIntegrationPaginators.this.client.listWorkspaces(request);
            }
        }, (Function)new Function<ListWorkspacesResponse, List<WorkspaceSummary>>(){

            public List<WorkspaceSummary> apply(ListWorkspacesResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DataIntegrationPaginators(DataIntegration client) {
        this.client = client;
    }
}

