/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRunRequest;
import com.oracle.bmc.dataintegration.responses.DeleteTaskRunResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTaskRunConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteTaskRunConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteTaskRunRequest interceptRequest(DeleteTaskRunRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteTaskRunRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTaskRunKey(), (String)"taskRunKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId())).path("applications").path(HttpUtils.encodePathSegment((String)request.getApplicationKey())).path("taskRuns").path(HttpUtils.encodePathSegment((String)request.getTaskRunKey()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteTaskRunResponse> fromResponse() {
        Function<Response, DeleteTaskRunResponse> transformer = new Function<Response, DeleteTaskRunResponse>(){

            public DeleteTaskRunResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.DeleteTaskRunResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteTaskRunResponse.Builder builder = DeleteTaskRunResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteTaskRunResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

