/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.requests.DeleteWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.DeleteWorkspaceResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteWorkspaceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteWorkspaceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteWorkspaceRequest interceptRequest(DeleteWorkspaceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteWorkspaceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId()));
        if (request.getQuiesceTimeout() != null) {
            target = target.queryParam("quiesceTimeout", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getQuiesceTimeout())});
        }
        if (request.getIsForceOperation() != null) {
            target = target.queryParam("isForceOperation", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsForceOperation())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteWorkspaceResponse> fromResponse() {
        Function<Response, DeleteWorkspaceResponse> transformer = new Function<Response, DeleteWorkspaceResponse>(){

            public DeleteWorkspaceResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.DeleteWorkspaceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteWorkspaceResponse.Builder builder = DeleteWorkspaceResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteWorkspaceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

