/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.model.PatchChangeSummaryCollection;
import com.oracle.bmc.dataintegration.requests.ListPatchChangesRequest;
import com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPatchChangesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListPatchChangesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListPatchChangesRequest interceptRequest(ListPatchChangesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListPatchChangesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getApplicationKey(), (String)"applicationKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId())).path("applications").path(HttpUtils.encodePathSegment((String)request.getApplicationKey())).path("patchChanges");
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getSincePatch() != null) {
            target = target.queryParam("sincePatch", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSincePatch())});
        }
        if (request.getToPatch() != null) {
            target = target.queryParam("toPatch", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getToPatch())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListPatchChangesResponse> fromResponse() {
        Function<Response, ListPatchChangesResponse> transformer = new Function<Response, ListPatchChangesResponse>(){

            public ListPatchChangesResponse apply(Response rawResponse) {
                Optional opcTotalItemsHeader;
                Optional opcPrevPageHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(PatchChangeSummaryCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListPatchChangesResponse.Builder builder = ListPatchChangesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.patchChangeSummaryCollection((PatchChangeSummaryCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page")).isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-total-items")).isPresent()) {
                    builder.opcTotalItems((Integer)HeaderUtils.toValue((String)"opc-total-items", (String)((String)((List)opcTotalItemsHeader.get()).get(0)), Integer.class));
                }
                ListPatchChangesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

