/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataintegration.model.DataFlow;
import com.oracle.bmc.dataintegration.requests.UpdateDataFlowRequest;
import com.oracle.bmc.dataintegration.responses.UpdateDataFlowResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDataFlowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateDataFlowConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateDataFlowRequest interceptRequest(UpdateDataFlowRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateDataFlowRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkspaceId(), (String)"workspaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataFlowKey(), (String)"dataFlowKey must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateDataFlowDetails(), (String)"updateDataFlowDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200430").path("workspaces").path(HttpUtils.encodePathSegment((String)request.getWorkspaceId())).path("dataFlows").path(HttpUtils.encodePathSegment((String)request.getDataFlowKey()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateDataFlowResponse> fromResponse() {
        Function<Response, UpdateDataFlowResponse> transformer = new Function<Response, UpdateDataFlowResponse>(){

            public UpdateDataFlowResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dataintegration.responses.UpdateDataFlowResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DataFlow.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateDataFlowResponse.Builder builder = UpdateDataFlowResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.dataFlow((DataFlow)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateDataFlowResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

