/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.CompositeType;
import com.oracle.bmc.dataintegration.model.ConfiguredType;
import com.oracle.bmc.dataintegration.model.DataType;
import com.oracle.bmc.dataintegration.model.DerivedType;
import com.oracle.bmc.dataintegration.model.DynamicType;
import com.oracle.bmc.dataintegration.model.JavaType;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=BaseType.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConfiguredType.class, name="CONFIGURED_TYPE"), @JsonSubTypes.Type(value=JavaType.class, name="JAVA_TYPE"), @JsonSubTypes.Type(value=DynamicType.class, name="DYNAMIC_TYPE"), @JsonSubTypes.Type(value=DerivedType.class, name="DERIVED_TYPE"), @JsonSubTypes.Type(value=DataType.class, name="DATA_TYPE"), @JsonSubTypes.Type(value=CompositeType.class, name="COMPOSITE_TYPE")})
@JsonFilter(value="explicitlySetFilter")
public class BaseType {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="description")
    private final String description;

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseType)) {
            return false;
        }
        BaseType other = (BaseType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "BaseType(key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", objectStatus=" + this.getObjectStatus() + ", description=" + this.getDescription() + ")";
    }

    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "objectStatus", "description"})
    @Deprecated
    protected BaseType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.objectStatus = objectStatus;
        this.description = description;
    }

    public static enum ModelType {
        DynamicType("DYNAMIC_TYPE"),
        StructuredType("STRUCTURED_TYPE"),
        DataType("DATA_TYPE"),
        JavaType("JAVA_TYPE"),
        ConfiguredType("CONFIGURED_TYPE"),
        CompositeType("COMPOSITE_TYPE"),
        DerivedType("DERIVED_TYPE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

