/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CompositeType
extends BaseType {
    @JsonProperty(value="parentType")
    private final CompositeType parentType;
    @JsonProperty(value="elements")
    private final List<TypedObject> elements;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public CompositeType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description, CompositeType parentType, List<TypedObject> elements, ConfigDefinition configDefinition) {
        super(key, modelVersion, parentRef, name, objectStatus, description);
        this.parentType = parentType;
        this.elements = elements;
        this.configDefinition = configDefinition;
    }

    public Builder toBuilder() {
        return new Builder().parentType(this.parentType).elements(this.elements).configDefinition(this.configDefinition);
    }

    public CompositeType getParentType() {
        return this.parentType;
    }

    public List<TypedObject> getElements() {
        return this.elements;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "CompositeType(super=" + super.toString() + ", parentType=" + this.getParentType() + ", elements=" + this.getElements() + ", configDefinition=" + this.getConfigDefinition() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeType)) {
            return false;
        }
        CompositeType other = (CompositeType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeType this$parentType = this.getParentType();
        CompositeType other$parentType = other.getParentType();
        if (this$parentType == null ? other$parentType != null : !((Object)this$parentType).equals(other$parentType)) {
            return false;
        }
        List<TypedObject> this$elements = this.getElements();
        List<TypedObject> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        ConfigDefinition this$configDefinition = this.getConfigDefinition();
        ConfigDefinition other$configDefinition = other.getConfigDefinition();
        if (this$configDefinition == null ? other$configDefinition != null : !((Object)this$configDefinition).equals(other$configDefinition)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CompositeType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CompositeType $parentType = this.getParentType();
        result = result * 59 + ($parentType == null ? 43 : ((Object)$parentType).hashCode());
        List<TypedObject> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        ConfigDefinition $configDefinition = this.getConfigDefinition();
        result = result * 59 + ($configDefinition == null ? 43 : ((Object)$configDefinition).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parentType")
        private CompositeType parentType;
        @JsonProperty(value="elements")
        private List<TypedObject> elements;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder parentType(CompositeType parentType) {
            this.parentType = parentType;
            this.__explicitlySet__.add("parentType");
            return this;
        }

        public Builder elements(List<TypedObject> elements) {
            this.elements = elements;
            this.__explicitlySet__.add("elements");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public CompositeType build() {
            CompositeType __instance__ = new CompositeType(this.key, this.modelVersion, this.parentRef, this.name, this.objectStatus, this.description, this.parentType, this.elements, this.configDefinition);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CompositeType o) {
            Builder copiedBuilder = this.key(o.getKey()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).name(o.getName()).objectStatus(o.getObjectStatus()).description(o.getDescription()).parentType(o.getParentType()).elements(o.getElements()).configDefinition(o.getConfigDefinition());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CompositeType.Builder(parentType=" + this.parentType + ", elements=" + this.elements + ", configDefinition=" + this.configDefinition + ")";
        }
    }
}

