/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConnectionFromAdwc;
import com.oracle.bmc.dataintegration.model.ConnectionFromAtp;
import com.oracle.bmc.dataintegration.model.ConnectionFromJdbc;
import com.oracle.bmc.dataintegration.model.ConnectionFromMySQL;
import com.oracle.bmc.dataintegration.model.ConnectionFromObjectStorage;
import com.oracle.bmc.dataintegration.model.ConnectionFromOracle;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=Connection.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionFromObjectStorage.class, name="ORACLE_OBJECT_STORAGE_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAdwc.class, name="ORACLE_ADWC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAtp.class, name="ORACLE_ATP_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromOracle.class, name="ORACLEDB_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromMySQL.class, name="MYSQL_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromJdbc.class, name="GENERIC_JDBC_CONNECTION")})
@JsonFilter(value="explicitlySetFilter")
public class Connection {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="primarySchema")
    private final Schema primarySchema;
    @JsonProperty(value="connectionProperties")
    private final List<ConnectionProperty> connectionProperties;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Schema getPrimarySchema() {
        return this.primarySchema;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Schema this$primarySchema = this.getPrimarySchema();
        Schema other$primarySchema = other.getPrimarySchema();
        if (this$primarySchema == null ? other$primarySchema != null : !((Object)this$primarySchema).equals(other$primarySchema)) {
            return false;
        }
        List<ConnectionProperty> this$connectionProperties = this.getConnectionProperties();
        List<ConnectionProperty> other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !((Object)this$connectionProperties).equals(other$connectionProperties)) {
            return false;
        }
        ObjectMetadata this$metadata = this.getMetadata();
        ObjectMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, String> this$keyMap = this.getKeyMap();
        Map<String, String> other$keyMap = other.getKeyMap();
        return !(this$keyMap == null ? other$keyMap != null : !((Object)this$keyMap).equals(other$keyMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Connection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 43 : ((Object)$objectVersion).hashCode());
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Schema $primarySchema = this.getPrimarySchema();
        result = result * 59 + ($primarySchema == null ? 43 : ((Object)$primarySchema).hashCode());
        List<ConnectionProperty> $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : ((Object)$connectionProperties).hashCode());
        ObjectMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, String> $keyMap = this.getKeyMap();
        result = result * 59 + ($keyMap == null ? 43 : ((Object)$keyMap).hashCode());
        return result;
    }

    public String toString() {
        return "Connection(key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectVersion=" + this.getObjectVersion() + ", objectStatus=" + this.getObjectStatus() + ", identifier=" + this.getIdentifier() + ", primarySchema=" + this.getPrimarySchema() + ", connectionProperties=" + this.getConnectionProperties() + ", isDefault=" + this.getIsDefault() + ", metadata=" + this.getMetadata() + ", keyMap=" + this.getKeyMap() + ")";
    }

    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "objectStatus", "identifier", "primarySchema", "connectionProperties", "isDefault", "metadata", "keyMap"})
    @Deprecated
    protected Connection(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.primarySchema = primarySchema;
        this.connectionProperties = connectionProperties;
        this.isDefault = isDefault;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public static enum ModelType {
        OracleAdwcConnection("ORACLE_ADWC_CONNECTION"),
        OracleAtpConnection("ORACLE_ATP_CONNECTION"),
        OracleObjectStorageConnection("ORACLE_OBJECT_STORAGE_CONNECTION"),
        OracledbConnection("ORACLEDB_CONNECTION"),
        MysqlConnection("MYSQL_CONNECTION"),
        GenericJdbcConnection("GENERIC_JDBC_CONNECTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

