/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.CreateConfigProvider;
import com.oracle.bmc.dataintegration.model.CreateTaskFromDataLoaderTask;
import com.oracle.bmc.dataintegration.model.CreateTaskFromIntegrationTask;
import com.oracle.bmc.dataintegration.model.CreateTaskFromPipelineTask;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=CreateTaskDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateTaskFromIntegrationTask.class, name="INTEGRATION_TASK"), @JsonSubTypes.Type(value=CreateTaskFromDataLoaderTask.class, name="DATA_LOADER_TASK"), @JsonSubTypes.Type(value=CreateTaskFromPipelineTask.class, name="PIPELINE_TASK")})
@JsonFilter(value="explicitlySetFilter")
public class CreateTaskDetails {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="inputPorts")
    private final List<InputPort> inputPorts;
    @JsonProperty(value="outputPorts")
    private final List<OutputPort> outputPorts;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="opConfigValues")
    private final ConfigValues opConfigValues;
    @JsonProperty(value="configProviderDelegate")
    private final CreateConfigProvider configProviderDelegate;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<InputPort> getInputPorts() {
        return this.inputPorts;
    }

    public List<OutputPort> getOutputPorts() {
        return this.outputPorts;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigValues getOpConfigValues() {
        return this.opConfigValues;
    }

    public CreateConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTaskDetails)) {
            return false;
        }
        CreateTaskDetails other = (CreateTaskDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<InputPort> this$inputPorts = this.getInputPorts();
        List<InputPort> other$inputPorts = other.getInputPorts();
        if (this$inputPorts == null ? other$inputPorts != null : !((Object)this$inputPorts).equals(other$inputPorts)) {
            return false;
        }
        List<OutputPort> this$outputPorts = this.getOutputPorts();
        List<OutputPort> other$outputPorts = other.getOutputPorts();
        if (this$outputPorts == null ? other$outputPorts != null : !((Object)this$outputPorts).equals(other$outputPorts)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        ConfigValues this$opConfigValues = this.getOpConfigValues();
        ConfigValues other$opConfigValues = other.getOpConfigValues();
        if (this$opConfigValues == null ? other$opConfigValues != null : !((Object)this$opConfigValues).equals(other$opConfigValues)) {
            return false;
        }
        CreateConfigProvider this$configProviderDelegate = this.getConfigProviderDelegate();
        CreateConfigProvider other$configProviderDelegate = other.getConfigProviderDelegate();
        if (this$configProviderDelegate == null ? other$configProviderDelegate != null : !((Object)this$configProviderDelegate).equals(other$configProviderDelegate)) {
            return false;
        }
        RegistryMetadata this$registryMetadata = this.getRegistryMetadata();
        RegistryMetadata other$registryMetadata = other.getRegistryMetadata();
        return !(this$registryMetadata == null ? other$registryMetadata != null : !((Object)this$registryMetadata).equals(other$registryMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateTaskDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<InputPort> $inputPorts = this.getInputPorts();
        result = result * 59 + ($inputPorts == null ? 43 : ((Object)$inputPorts).hashCode());
        List<OutputPort> $outputPorts = this.getOutputPorts();
        result = result * 59 + ($outputPorts == null ? 43 : ((Object)$outputPorts).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        ConfigValues $opConfigValues = this.getOpConfigValues();
        result = result * 59 + ($opConfigValues == null ? 43 : ((Object)$opConfigValues).hashCode());
        CreateConfigProvider $configProviderDelegate = this.getConfigProviderDelegate();
        result = result * 59 + ($configProviderDelegate == null ? 43 : ((Object)$configProviderDelegate).hashCode());
        RegistryMetadata $registryMetadata = this.getRegistryMetadata();
        result = result * 59 + ($registryMetadata == null ? 43 : ((Object)$registryMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "CreateTaskDetails(key=" + this.getKey() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectStatus=" + this.getObjectStatus() + ", identifier=" + this.getIdentifier() + ", inputPorts=" + this.getInputPorts() + ", outputPorts=" + this.getOutputPorts() + ", parameters=" + this.getParameters() + ", opConfigValues=" + this.getOpConfigValues() + ", configProviderDelegate=" + this.getConfigProviderDelegate() + ", registryMetadata=" + this.getRegistryMetadata() + ")";
    }

    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectStatus", "identifier", "inputPorts", "outputPorts", "parameters", "opConfigValues", "configProviderDelegate", "registryMetadata"})
    @Deprecated
    protected CreateTaskDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<InputPort> inputPorts, List<OutputPort> outputPorts, List<Parameter> parameters, ConfigValues opConfigValues, CreateConfigProvider configProviderDelegate, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.parameters = parameters;
        this.opConfigValues = opConfigValues;
        this.configProviderDelegate = configProviderDelegate;
        this.registryMetadata = registryMetadata;
    }

    public static enum ModelType {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK");

        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ModelType: " + key);
        }

        static {
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

