/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.DataEntityFromFile;
import com.oracle.bmc.dataintegration.model.DataEntityFromTable;
import com.oracle.bmc.dataintegration.model.DataEntityFromView;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=DataEntity.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataEntityFromTable.class, name="TABLE_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromView.class, name="VIEW_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromFile.class, name="FILE_ENTITY")})
@JsonFilter(value="explicitlySetFilter")
public class DataEntity {
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEntity)) {
            return false;
        }
        DataEntity other = (DataEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMetadata this$metadata = this.getMetadata();
        ObjectMetadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "DataEntity(metadata=" + this.getMetadata() + ")";
    }

    @ConstructorProperties(value={"metadata"})
    @Deprecated
    protected DataEntity(ObjectMetadata metadata) {
        this.metadata = metadata;
    }

    public static enum ModelType {
        ViewEntity("VIEW_ENTITY"),
        TableEntity("TABLE_ENTITY"),
        FileEntity("FILE_ENTITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

