/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.PushDownOperation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Join
extends PushDownOperation {
    @JsonProperty(value="condition")
    private final String condition;
    @JsonProperty(value="policy")
    private final Policy policy;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Join(String condition, Policy policy) {
        this.condition = condition;
        this.policy = policy;
    }

    public Builder toBuilder() {
        return new Builder().condition(this.condition).policy(this.policy);
    }

    public String getCondition() {
        return this.condition;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "Join(super=" + super.toString() + ", condition=" + this.getCondition() + ", policy=" + (Object)((Object)this.getPolicy()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Policy this$policy = this.getPolicy();
        Policy other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)((Object)this$policy)).equals((Object)other$policy)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Policy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)((Object)$policy)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum Policy {
        InnerJoin("INNER_JOIN"),
        LeftJoin("LEFT_JOIN"),
        RightJoin("RIGHT_JOIN"),
        FullJoin("FULL_JOIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Policy> map;

        private Policy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Policy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Policy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Policy.class);
            map = new HashMap<String, Policy>();
            for (Policy v : Policy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="condition")
        private String condition;
        @JsonProperty(value="policy")
        private Policy policy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder condition(String condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Join build() {
            Join __instance__ = new Join(this.condition, this.policy);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Join o) {
            Builder copiedBuilder = this.condition(o.getCondition()).policy(o.getPolicy());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Join.Builder(condition=" + this.condition + ", policy=" + (Object)((Object)this.policy) + ")";
        }
    }
}

