/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ProjectionRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class NameListRule
extends ProjectionRule {
    @JsonProperty(value="isSkipRemainingRulesOnMatch")
    private final Boolean isSkipRemainingRulesOnMatch;
    @JsonProperty(value="scope")
    private final Object scope;
    @JsonProperty(value="isCascade")
    private final Boolean isCascade;
    @JsonProperty(value="matchingStrategy")
    private final MatchingStrategy matchingStrategy;
    @JsonProperty(value="isCaseSensitive")
    private final Boolean isCaseSensitive;
    @JsonProperty(value="ruleType")
    private final RuleType ruleType;
    @JsonProperty(value="names")
    private final List<String> names;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public NameListRule(String key, String modelVersion, ParentReference parentRef, Boolean isJavaRegexSyntax, ConfigValues configValues, Integer objectStatus, String description, Boolean isSkipRemainingRulesOnMatch, Object scope, Boolean isCascade, MatchingStrategy matchingStrategy, Boolean isCaseSensitive, RuleType ruleType, List<String> names) {
        super(key, modelVersion, parentRef, isJavaRegexSyntax, configValues, objectStatus, description);
        this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
        this.scope = scope;
        this.isCascade = isCascade;
        this.matchingStrategy = matchingStrategy;
        this.isCaseSensitive = isCaseSensitive;
        this.ruleType = ruleType;
        this.names = names;
    }

    public Builder toBuilder() {
        return new Builder().isSkipRemainingRulesOnMatch(this.isSkipRemainingRulesOnMatch).scope(this.scope).isCascade(this.isCascade).matchingStrategy(this.matchingStrategy).isCaseSensitive(this.isCaseSensitive).ruleType(this.ruleType).names(this.names);
    }

    public Boolean getIsSkipRemainingRulesOnMatch() {
        return this.isSkipRemainingRulesOnMatch;
    }

    public Object getScope() {
        return this.scope;
    }

    public Boolean getIsCascade() {
        return this.isCascade;
    }

    public MatchingStrategy getMatchingStrategy() {
        return this.matchingStrategy;
    }

    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public List<String> getNames() {
        return this.names;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "NameListRule(super=" + super.toString() + ", isSkipRemainingRulesOnMatch=" + this.getIsSkipRemainingRulesOnMatch() + ", scope=" + this.getScope() + ", isCascade=" + this.getIsCascade() + ", matchingStrategy=" + (Object)((Object)this.getMatchingStrategy()) + ", isCaseSensitive=" + this.getIsCaseSensitive() + ", ruleType=" + (Object)((Object)this.getRuleType()) + ", names=" + this.getNames() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameListRule)) {
            return false;
        }
        NameListRule other = (NameListRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isSkipRemainingRulesOnMatch = this.getIsSkipRemainingRulesOnMatch();
        Boolean other$isSkipRemainingRulesOnMatch = other.getIsSkipRemainingRulesOnMatch();
        if (this$isSkipRemainingRulesOnMatch == null ? other$isSkipRemainingRulesOnMatch != null : !((Object)this$isSkipRemainingRulesOnMatch).equals(other$isSkipRemainingRulesOnMatch)) {
            return false;
        }
        Boolean this$isCascade = this.getIsCascade();
        Boolean other$isCascade = other.getIsCascade();
        if (this$isCascade == null ? other$isCascade != null : !((Object)this$isCascade).equals(other$isCascade)) {
            return false;
        }
        Boolean this$isCaseSensitive = this.getIsCaseSensitive();
        Boolean other$isCaseSensitive = other.getIsCaseSensitive();
        if (this$isCaseSensitive == null ? other$isCaseSensitive != null : !((Object)this$isCaseSensitive).equals(other$isCaseSensitive)) {
            return false;
        }
        Object this$scope = this.getScope();
        Object other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        MatchingStrategy this$matchingStrategy = this.getMatchingStrategy();
        MatchingStrategy other$matchingStrategy = other.getMatchingStrategy();
        if (this$matchingStrategy == null ? other$matchingStrategy != null : !((Object)((Object)this$matchingStrategy)).equals((Object)other$matchingStrategy)) {
            return false;
        }
        RuleType this$ruleType = this.getRuleType();
        RuleType other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !((Object)((Object)this$ruleType)).equals((Object)other$ruleType)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NameListRule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isSkipRemainingRulesOnMatch = this.getIsSkipRemainingRulesOnMatch();
        result = result * 59 + ($isSkipRemainingRulesOnMatch == null ? 43 : ((Object)$isSkipRemainingRulesOnMatch).hashCode());
        Boolean $isCascade = this.getIsCascade();
        result = result * 59 + ($isCascade == null ? 43 : ((Object)$isCascade).hashCode());
        Boolean $isCaseSensitive = this.getIsCaseSensitive();
        result = result * 59 + ($isCaseSensitive == null ? 43 : ((Object)$isCaseSensitive).hashCode());
        Object $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        MatchingStrategy $matchingStrategy = this.getMatchingStrategy();
        result = result * 59 + ($matchingStrategy == null ? 43 : ((Object)((Object)$matchingStrategy)).hashCode());
        RuleType $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : ((Object)((Object)$ruleType)).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum RuleType {
        Include("INCLUDE"),
        Exclude("EXCLUDE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleType> map;

        private RuleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleType.class);
            map = new HashMap<String, RuleType>();
            for (RuleType v : RuleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MatchingStrategy {
        NameOrTags("NAME_OR_TAGS"),
        TagsOnly("TAGS_ONLY"),
        NameOnly("NAME_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MatchingStrategy> map;

        private MatchingStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MatchingStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MatchingStrategy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MatchingStrategy.class);
            map = new HashMap<String, MatchingStrategy>();
            for (MatchingStrategy v : MatchingStrategy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="isJavaRegexSyntax")
        private Boolean isJavaRegexSyntax;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isSkipRemainingRulesOnMatch")
        private Boolean isSkipRemainingRulesOnMatch;
        @JsonProperty(value="scope")
        private Object scope;
        @JsonProperty(value="isCascade")
        private Boolean isCascade;
        @JsonProperty(value="matchingStrategy")
        private MatchingStrategy matchingStrategy;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="ruleType")
        private RuleType ruleType;
        @JsonProperty(value="names")
        private List<String> names;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder isJavaRegexSyntax(Boolean isJavaRegexSyntax) {
            this.isJavaRegexSyntax = isJavaRegexSyntax;
            this.__explicitlySet__.add("isJavaRegexSyntax");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isSkipRemainingRulesOnMatch(Boolean isSkipRemainingRulesOnMatch) {
            this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
            this.__explicitlySet__.add("isSkipRemainingRulesOnMatch");
            return this;
        }

        public Builder scope(Object scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder isCascade(Boolean isCascade) {
            this.isCascade = isCascade;
            this.__explicitlySet__.add("isCascade");
            return this;
        }

        public Builder matchingStrategy(MatchingStrategy matchingStrategy) {
            this.matchingStrategy = matchingStrategy;
            this.__explicitlySet__.add("matchingStrategy");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder ruleType(RuleType ruleType) {
            this.ruleType = ruleType;
            this.__explicitlySet__.add("ruleType");
            return this;
        }

        public Builder names(List<String> names) {
            this.names = names;
            this.__explicitlySet__.add("names");
            return this;
        }

        public NameListRule build() {
            NameListRule __instance__ = new NameListRule(this.key, this.modelVersion, this.parentRef, this.isJavaRegexSyntax, this.configValues, this.objectStatus, this.description, this.isSkipRemainingRulesOnMatch, this.scope, this.isCascade, this.matchingStrategy, this.isCaseSensitive, this.ruleType, this.names);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(NameListRule o) {
            Builder copiedBuilder = this.key(o.getKey()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).isJavaRegexSyntax(o.getIsJavaRegexSyntax()).configValues(o.getConfigValues()).objectStatus(o.getObjectStatus()).description(o.getDescription()).isSkipRemainingRulesOnMatch(o.getIsSkipRemainingRulesOnMatch()).scope(o.getScope()).isCascade(o.getIsCascade()).matchingStrategy(o.getMatchingStrategy()).isCaseSensitive(o.getIsCaseSensitive()).ruleType(o.getRuleType()).names(o.getNames());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "NameListRule.Builder(isSkipRemainingRulesOnMatch=" + this.isSkipRemainingRulesOnMatch + ", scope=" + this.scope + ", isCascade=" + this.isCascade + ", matchingStrategy=" + (Object)((Object)this.matchingStrategy) + ", isCaseSensitive=" + this.isCaseSensitive + ", ruleType=" + (Object)((Object)this.ruleType) + ", names=" + this.names + ")";
        }
    }
}

